; This function will copy and rotate an object
; using the ARRAY command.
;Bob Zelna

(DEFUN C:CR (/ OBJ RP P1 REF ANG ANG1 ANG2 ANS KIL)
  (PRINC "\nSelect which objects to move...")
  (SETQ OBJ (SSGET)
        RP (GETPOINT"\nSelect your rotation point: ")
        P1 (GETPOINT RP "\nPick the first endpoint: ")
        REF (GETPOINT RP "\n...the second endpoint? ")
        ANG1 (ANGLE RP P1)
        ANG2 (ANGLE RP REF)
        ANG (ABS (- ANG1 ANG2)))
  (IF (> ANG PI)
    (SETQ ANG (ABS (- ANG (* 2 PI))))
  )
  (SETQ ANG (ANGTOS ANG 0 6))
  (PRINC"\nThe angle of rotation in degrees is ")
  (PRINC ANG)
  (SETQ ANS (STRCASE (GETSTRING"\nRotate counter-clockwise? <Y> "))
        KIL (STRCASE (GETSTRING"\nDelete old objects? <Y> ")))
  (IF (EQ ANS "N")
    (SETQ ANG (STRCAT "-" ANG))
  )
  (COMMAND "ARRAY" OBJ "" "P" RP "2" "0" ANG "")
  (IF (OR (EQ KIL "Y") (EQ KIL "")) (COMMAND "ERASE" OBJ ""))
  (MENUCMD "S= ")
)
