;Stretch command
;Bob Zelna

(command ".UNDEFINE" "STRETCH")
(defun C:SS (/ pt1 pt2 ss0 ss1 ss2 ename index echo)
  (setq echo (getvar "cmdecho"))
  (setvar "cmdecho" 0)
  (if (and (setq pt1 (getpoint "\nFirst corner:")
                 pt2 (getcorner pt1 "\nOpposite corner:")
                 ss1 (ssget "C" pt1 pt2)
           )
      )
    (progn
      (prompt "\nAdd or Remove objects...")
      (command ".SELECT" ss1 pause)
      (setq ss0 (ssget "P")
            ss2 (ssadd)
            index -1
      )
      (while (setq ename (ssname ss1 (setq index (1+ index))))
        (if (null (ssmemb ename ss0))
          (ssadd ename ss2)
        )
      )
      (setq ename (ssname ss2 0))
      (princ "\nBase point:")
      (apply 'Command
        (append
          (if ename (list ".SELECT" ss2 ""))
          (list ".STRETCH" "C" pt1 pt2)
          (if ename (list "R" "P"))
          (list "" pause)
        )
      )
    )
  )
  (setvar "cmdecho" echo)
  (princ)
)
