; File......: OUTP.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
;
; This function is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
;     Rev 1.4   17 Jan 1995 03:01:00   TED
;  Fixed a parameter validation bug.
;
;     Rev 1.3   28 Sep 1992 00:49:46   GLENN
;  Ted Means corrected a small bug.
;
;     Rev 1.2   15 Aug 1991 23:07:08   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;
;     Rev 1.1   14 Jun 1991 19:54:52   GLENN
;  Minor edit to file header
;
;     Rev 1.0   01 Apr 1991 01:03:46   GLENN
;  Nanforum Toolkit
;


;  $DOC$
;  $FUNCNAME$
;      FT_OUTP()
;  $CATEGORY$
;      DOS/BIOS
;  $ONELINER$
;      Write a byte to a specified I/O port
;  $SYNTAX$
;     FT_OUTP( <nPort>, <nValue> ) -> lResult
;  $ARGUMENTS$
;      <nPort> is the port from which to retrieve the byte.
;
;      <nValue> is the value between 0 and 255 to write to the port.
;  $RETURNS$
;     .T. if all parameters were valid and the byte was written to
;         the port.
;     .F. if invalid parameters were passed.
;  $DESCRIPTION$
;     It may sometimes be useful to write a byte to a port without having
;     to resort to C or assembler.  This function allows you to do so.
;
;     The source code is written to adhere to Turbo Assembler's IDEAL mode.
;     To use another assembler, you will need to rearrange the PROC and
;     SEGMENT directives, and also the ENDP and ENDS directives (a very
;     minor task).
;  $EXAMPLES$
;     lOk := FT_OUTP( 100, 0 )   // send a Chr(0) to port 100 (064h)
;  $SEEALSO$
;     FT_INP()
;  $END$
;


IDEAL

Public    FT_OUTP

Extrn     __ParInfo:Far
Extrn     __ParNI:Far
Extrn     __RetL:Far

Segment   _NanFor   Word      "CODE"
          Assume    CS:_NanFor

Proc      FT_OUTP   Far

          Xor       AX,AX                     ; Request param count
          Push      AX                        ; Put request on stack
          Call      __ParInfo                 ; Get param count
          Add       SP,2                      ; Realign stack
          Mov       CX,AX                     ; Prepare for later loop
          Cmp       AX,2                      ; At least two params?
          JE        @@Types                   ; If so, continue

@@Bogus:  Xor       AX,AX                     ; Set return value to false
          Jmp       Short @@Exit              ; Quit

@@Types:  Push      CX                        ; Put param # on stack
          Call      __ParInfo                 ; Get param type
          Pop       CX                        ; Realign stack and restore CX
          Test      AX,2                      ; Numeric?
          JZ        @@Bogus                   ; No, so abort
          Loop      @@Types                   ; Go to top of loop

          Mov       AX,1                      ; Specify first param
          Push      AX                        ; Put param # on stack
          Call      __ParNI                   ; Get value
          Add       SP,2                      ; Realign stack
          Push      AX                        ; Save value for later

          Mov       AX,2                      ; Specify first param
          Push      AX                        ; Put param # on stack
          Call      __ParNI                   ; Get value
          Add       SP,2                      ; Realign stack
          Pop       DX                        ; Get port back
          Or        AH,AH                     ; Make sure a byte was passed
          JNZ       @@Bogus                   ; If not, return .F.
          Out       DX,AL                     ; Write a byte to the port
          Mov       AX,1                      ; Set return value to true

@@Exit:  Push      AX                         ; Put return value on stack
         Call      __RetL                     ; Return it to Clipper app
         Add       SP,2                       ; Realign stack
         RetF
Endp     FT_OUTP
Ends     _NanFor
End