-----BEGIN PGP SIGNED MESSAGE-----

- -------------------------------------------------------------------------------
 CBV - Callback verifier                                          Jul 19,1994
- -------------------------------------------------------------------------------

- -------------------------------------------------------------------------------
Important: date must be set-up as month/day/year in commo.set
- -------------------------------------------------------------------------------
                            -----
                            BEGIN
                            -----
{:cbvstart}
{setv phase,CBV}                   set phase
{setv usrprompt,Press [Enter] for options}
{call mtbox,m4gfx.M4}              draw empty box
{call cbvbegin}                    begin cbv
{setg 45,,y}                       wait 15 sec for input
{setv usrprompt,Press [Enter] to initiate callback}
{call tellbox,m4gfx.M4}            instructions
{setv crlf}                        clear out old value
{gets-h crlf,1}                    get one keypress
{send ^[[0m^[[2J^L}                clear screen
{send Look for "RING" then type "ATA" <Enter>. See you in a minute!^M^J}
{call calluser}                    call user
{setv logtxt,CBV failed}           log in case all three attempts failed
{comp fail,y}                      last attempt failed?
{ifco restartm4}                   if so, quit
{call queryusr}                    query user (if M) on return for password
{call wait4sys}
{call dobbs}                       do bbs
{return}

{:cbvbegin}                                run cbv
{call cbvset}                              setup
{setv logtxt,Callback Verifier Entered}    log
{call getime}                              log
{setv repeat,getnum,3}                     get from user, up to 3 times
{call repeat}                              ...
{setv outmsg, Please wait...}
{call instruct}
{setv logtxt,User Error: Phone number not entered}
{comp fail,y}                              did last input fail?
{ifco quit}                                if so, quit
{call readdd}                              scan dialing dir for number
{comp fail}                                was number found?
{ifco-c oldnum,newnum}                     if so, new num else old number
{return}

 {:cbvset}                            setup
 {setv fonfile,commo.fon}
 {setv idlen,10}
 {setv showlog,no}
 {setg 10,,y}
 {curs y}
 {setv fail}
 {setv fontries,0}
 {setv newuser}
 {setv cbvnumin}
 {setv early}
 {setv centesimal,19}                      set centuries-passed
 {setv xposx,19}                           x-pos of dialing input field
 {setv xmsg,%xposx}
 {incr xmsg,14}
 {setv yposy,12}                           y-pos of dialing input field
 {setv ymsg,%yposy}                        set message info field
 {incr ymsg}                               for user input to underneath num input
 {comp graphics,1}                         if mono
 {ifco-c b&w,color}                        do mono, else do color
 {setv inputline,^[[%yposy%;%xposx%H%intxt%()- }
 {setv 3blank,}
 {setv 4blank,}
 {setv instrhi,^[[%yposy%;%xmsg%H%intxt%}
 {setv instruct,%instrhi}
 {setv instrlow,^[[%ymsg%;%xoffset%H%intxt%}
 {setv choices,^[[%ymsg%;%xposx%H%choicf%}
 {setv clearmsg}
 {setv choicout}
 {setv blankvar,                                                              }
 {comp graphics,0}
 {ifco-c tty}
 {setv wtimes,0}                      time warning counter
 {setv wtries,0}                      bad char-warning counter
 {loca y}
 {spdc y}
 {parm ,,,A,}                         ansi on
 {setv early}
 {setv pause,0}
 {setv callwait,%normwait}            default dialout wait time
 {return}

 {:tty}
 {setv blocks}
 {setv infield}
 {setv intxt,^M^J}
 {setv choicf}
 {setv shadebk}
 {setv inputline,^M^JInput your DATA number}
 {setv 3blank,^M^J?}
 {setv 4blank,^M^J?}
 {setv instrhi,%intxt%}
 {setv instruct,%instrhi%}
 {setv instrlow}
 {setv choices,%choicf%^M^J}
 {return}

 {:b&w}
 {setv infield,^[[0m}
 {setv intxt,^[[0m}
 {setv choicf,^[[0m}
 {setv shadebk,^[[0m}
 {return}

 {:color}
 {setv infield,^[[0;30;46m}
 {setv intxt,%ansi4}
 {setv choicf,%ansi4}
 {setv shadebk,^[[0;30;42m}
 {return}

- --------------------------------------------------------------------------------
                  get phone number from user
- --------------------------------------------------------------------------------
- ------------------------------------------
                               get fields
- ------------------------------------------

 {:getnum}
 {call ccar}
 {setv redoall}
 {send %inputline}                        setup
 {setv fieldnam,getarea}
 {call dofield}
 {setv fieldnam,getpref}
 {call dofield}
 {setv fieldnam,getsuf}
 {call dofield}
 {comp fail}
 {ifco ret}
 {return}

  {:dofield}
  {setv repeat,%fieldnam%,3}              repeat field 3x
  {call repeat}                           "
  {comp redoall,y}                        request to redo all fields?
  {ifco ret}                              if so, escape repeat loop
  {comp fail,y}                           else, did field entry fail?
  {ifco ret}                              if so escape repeat loop
  {return}

  {:getarea}              area code
  {setv outmsg,Your area code}
  {call instruct}
  {setv blankgr,%3blank}                  first field
  {setv lenf,3}
  {setv xoffset,1}
  {call getfield}
  {call testf}
  {comp redoall,y}
  {ifco ret}
  {comp fail,y}
  {ifco rit}
  {setv cbvnumin,%num}                    else put in CBVNUMIN
  {subs 1stdigi,1,1,%num}                 0,1 in first digit?
  {inst taboo1st,%1stdigi}
  {comp %_pos,0}
  {ifco ,quit}
  {inst taboo,%num}
  {comp %_pos,0}
  {ifco-e ,police}
  {setv areacode,%num}
  {goto ret}

  {:getpref}              area code
  {setv outmsg,Your 3-digit prefix}
  {call instruct}
  {setv blankgr,%3blank}                  second field
  {setv lenf,3}
  {setv xoffset,5}
  {call getfield}
  {call testf}
  {comp redoall,y}
  {ifco ret}
  {comp fail,y}
  {ifco rit}
  {setv cbvnumin,%cbvnumin%%num}
  {subs 1stdigi,1,1,num}                  first digit of prefix=0?
  {inst taboo1st,%1stdigi}
  {comp %_pos,0}
  {ifco-e ,quit}
  {inst taboo,%num}
  {comp %_pos,0}
  {ifco-e ,police}
  {setv prefix,%num}
  {goto ret}

  {:getsuf}               suffix
  {setv outmsg,Your 4-digit suffix}
  {call instruct}
  {setv blankgr,%4blank}
  {setv lenf,4}
  {setv xoffset,9}                          third field
  {call getfield}
  {call testf}
  {comp redoall,y}
  {ifco ret}
  {comp fail,y}
  {ifco rit}
  {setv suffix,%num}
  {setv cbvnumin,%cbvnumin%%num}
  {goto ret}

    {:getfield}                           get fields of data
    {call ccar}
    {setv num}
    {setv fail}
    {incr xoffset,%xposx}
    {call prepfield}
    {comp graphics,0}
    {ifco-e ewait}
    {gets-h num,%lenf}
    {return}

    {:ewait}   wait for enter keypress
    {gets num,%lenf}
    {return}

     {:prepfield}
     {comp graphics,0}
     {ifco-c ttyfield,ansifield}
     {return}

      {:ttyfield}
      {send %blankgr%}
      {return}

      {:ansifield}
      {send ^[[%yposy%;%xoffset%H%shadebk%%blankgr%^[[%yposy%;%xoffset%H}
      {return}


- --------------------------------------
                          Test Feilds
- --------------------------------------

    {:testf}         test input field for bad length OR bad chars
    {setv fail}
    {inst num,^[}               did user hit esc key?
    {comp %_pos,0}
    {ifco ,bakmen}
    {leng %num}                  short?
    {comp %_len,%lenf}
    {ifco-lc warnlen}
    {comp fail,y}
    {ifco rit}
    {setv early}
    {setv repeat,isnum,%lenf}    all numeric?
    {call repeat}
    {comp early,yes}
    {ifco warnchar}
    {return}

  {:bakmen} back to menus
  {setv redoall}
  {setv choictxt,[Esc] to quit - Any other key restarts}
  {call sendchoice}
  {setv choice}
  {setg 10,,n}
  {gets-h choice,1}           get one char
  {setg 10,,y}
  {comp choice,^[}            was escape hit again?
  {ifco ,rit}                 redo field
  {call quit}
  {stop}

  {:isnum}                       is input numeric
  {subs digi,%timecount,1,%num}  grab digit in pos (timecount is from repeat)
  {instr numeric,%digi}          is digit numeric?
  {ifco rit,ret}

  {:warnlen}                 warn user about length of field
  {setv fail,y}              set fail flag to redo whole
  {call wtry}
  {setv outmsg,Not enough digits}
  {call instruct}
  {call testchoice}          find user choice
  {return}

  {:warnchar}                 warn bad tries
  {setv early}
  {setv fail,y}
  {call wtry}
  {setv outmsg,Type numbers only}
  {call instruct}
  {call testchoice}
  {return}

  {:warntime}          warn user about time
  {setv fail,y}
  {incr wtimes}
  {setv logtxt,User Error: Online timeout}
  {comp wtimes,5}
  {ifco-g quit}
  {setv outmsg,Time is running out!}
  {call instruct}
  {return}

   {:wtry}
   {setv outmsg,Tries all used}
   {setv logtxt,User error: Too many input errors}
   {incr wtries}          increment counter
   {comp wtries,10}       is it at max?
   {ifco-g quitwith}      if so, quit
   {return}

   {:testchoice}              test user input
   {setv redoall}
   {setv choictxt,[Esc] quit - [Enter] continue - [Space] restart}
   {call sendchoice}
   {setv choice}
   {setg 10,,n}
   {parm ,,,T,}
   {gets-h choice,1}
   {setg 10,,y}
   {parm ,,,A,}
   {call choicout}
   {comp choice,}
   {ifco quit}
   {comp choice}              <Enter> (restart all fields)
   {ifco rit}                 redo field
   {setv redoall,y}           else set flag to redo whole
   {return}

- -------------------------------------------------------------------------------
                  Online Error Messages, Instructions
- -------------------------------------------------------------------------------

 {:instruct}
 {call ccar}
 {call clearmsg}
 {send %instruct%%outmsg%}
 {return}

  {:clearmsg}           blank out last message
  {comp graphics,0}
  {ifco rit}
  {call ccar}
  {send %instruct%%clearmsg%}
  {leng %outmsg}
  {subs clearmsg,1,%_len,%blankvar}
  {return}

 {:sendchoice}
 {call ccar}
 {call choicout}
 {send %choices%%choictxt%}
 {return}

 {:choicout}
 {comp graphics,0}
 {ifco rit}
 {call ccar}
 {send %choices%%choicout%}
 {leng %choictxt}
 {subs choicout,1,%_len,%blankvar}
 {return}

- --------------------------------------------------------------------------------
                     number exists in dialing dir
- --------------------------------------------------------------------------------

{:oldnum}                        number exists in dialing dir
{setv newuser,n}                 not a new user
{call getcbvar}                  get dialing cbv vars
{call dconvert}                  get today's info
{call compday}                   convert & compare dates
{setv outmsg, Access Denied}
{setv logtxt,[%cbvid%,%cbvcode%,%cbvdate%] Known bad number}
{comp cbvstat,b}                 bad number?
{ifco quit}                      if so, quit
{comp cbvstat,x}                 world number?
{ifco worldnum}                  if so, get world file
{comp cbvstat,v}                 verified or not?
{ifco verified}
{comp cbvstat,m}                 if so, verified else maybe
{ifco maybe}
{comp cbvstat,s}                 skip checking for this number?
{ifco skipcbv}                   if so, skip check
{return}

- ---------------------- get fields in dialing dir ------------------------

 {:getcbvar}         freeform read
 {setv k,%entry}
 {inst k,^(}              CBVID
 {setv pos,%_pos}
 {decr pos}
 {subs bf,1,%pos,%k}
 {setv oc, }
 {call leadspace}          remove leading spaces
 {call trailspace}
 {setv cbvid,%bf}

 {call nxfield}
 {setv cbvnum,%field}     CBVNUM

 {call nxfield}
 {setv cbvpass,%field}    CBVPASS

 {call nxfield}
 {setv cbvcode,%field}    CBVCODE
 {call nxfield}
 {setv bf,%k}
 {call leadspace}
 {call trailspace}
 {setv cbvdate,%bf}       CBVDATE
 {call foncodes}
 {return}

 {:nxfield}             get next field
 {setv field}           blank-out
 {inst k,^(}            left-brack
 {setv pos,%_pos}
 {comp pos,0}
 {ifco rit}
 {incr pos}
 {subs k,%pos,100,%k}   get all chars one-to-right of brack
 {inst k,^)}            right-brack
 {setv pos,%_pos}
 {decr pos}             point one char to left
 {subs field,1,%pos,%k} else extract data from field
 {incr pos,2}
 {subs k,%pos,100,%k}
 {return}

  input:  BF (string to extract undesired chars from)
          OC (string of undesired chars)
  output: BF (string with no leading/trailing undesired chars)

  {:leadspace}                input BF, get rid of leading spaces
  {leng %bf}                  get length of input var
  {setv len,%_len}            put in LEN
  {setv tbf,%bf}
  {setv repeat,ospace,%len}   check each pos in BF until non-space is found
  {call repeat}
  {setv bf,%tbf}
  {return}

   {:ospace}                    out space
   {subs spc,%timecount,1,%bf}  get one char
   {inst %oc,%spc}              is undesired char in string?
   {comp %_pos,0}               if not there...
   {ifco ret}                   trunc it out, else quit
    {:truncspc}                 trunc space
    {subs %tbf,2,100,%tbf}      trunc it  one char from left
    {return}

  {:trailspace}                  get rid of trailing spaces
  {leng %bf}                     get length of var
  {setv len,%_len}               put in LEN
  {setv tbf,%bf}
  {setv repeat,tspace,%len%}     repeat scan for every char
  {call repeat}
  {setv bf,%tbf}
  {return}

   {:tspace}
   {subs spc,-%timecount,1,%bf} get TIMECOUNT char from right-of string
   {inst %oc,%spc}             is it space?
   {ifco ,ret}                 if so, extract it; else done
   {setv tout,%timecount}      TOUT=positive value of string pos
   {setv tlen,%len}            TLEN=temp length of string
   {decr tlen,%tout}           TLEN-TOUT=string without trailing space
   {subs tbf,1,%tlen,%bf}      assign to TBF
   {return}

  {:trunkk} trunc last char from k
  {leng %k}
  {setv len,%_len}
  {decr len}
  {subs k,1,%len,%k}
  {return}

 {:foncodes}                       fon file codes for both
 {subs cbvarea,1,3,%cbvid}         get area code of number
 {subs cbvstat,1,1,%cbvcode}       get status of user
 {subs cbvsecur,2,1,%cbvcode}      get security level of user
 {subs cbvtries,3,1,%cbvcode}      get tries-made-today
 {subs cbvmonth,1,2,%cbvdate}      get month of last connect
 {subs cbvday,4,2,%cbvdate}        get day of last connect
 {subs cbvyear,7,2,%cbvdate}       get year of last connect
 {setv thisdate,%_dat}             set today's full date
 {subs month,1,2,%thisdate}        get month
 {subs day,4,2,%thisdate}          get day
 {subs year,7,2,%thisdate}         get year
 {return}

- -------------------------------------------------------------------------------
 PBX number (world)
- -------------------------------------------------------------------------------

 {:worldnum}
 {setv callwait,%pbxwait%}     make setdial parms=pbx wait time
 {setv worldpfx,%cbvnum}       WORLDPFX=number
 {setv passname,%cbvpass}      PASSWORD
 {setv eaccess,%cbvtries}      extension access
 {setv waccess,%cbvsecur}      world access
 {comp eaccess,O}              open/closed access extensions?
 {ifco-c extopen,extprot}      set SECURITY var accordingly
 {call wfonfile}               identify fon file name/create if new
 {comp waccess,O}              open/closed access world?
 {ifco-c wrldopen,wclosed}     query user depending on world-type
 {setv cbvnumin,%extension}    assign cbvnumin=extension
 {call readdd}                 find extension in fonfile
 {comp fail}                   if not failed
 {ifco-c oldnum,newnum}        oldnum, else newnum

 have done oldnum-verified up to writcode - resume work at passblan
 make passblanks=to (location of cbvcode)-(length of cbvid+cbvdialout+password)
 need to do unverified and newnum before dialout

 {return}

 {:wfonfile}                         identify new world fon file
 {subs worldf,1,8,%cbvid}            filename
 {subs worlde,9,2,%cbvid}            first 2 digits of extension
 {setv worldfil,%worldf%.%worlde%A}  assemble filename
 {ifex-c %worldfil%,,makeworld}      make world file
 {setv fonfile,%worldfil}
 {fonf %fonfile%}
 {return}

  {:makeworld}                      make a new world fon file
  {wopen %worldfil%}
  {writ  PBX dialing directory for %cbvid% created %_dat%.}
  {writ  All numbers prefixed by: %worldpfx%}
  {writ  Extensions: %security%}
  {comp %waccess,O}
  {ifco-c openp,closp}
  {writ -------------------------------------------------------------------}
  {wclos}
  {return}

   {:openp} open access world
   {writ  Open Access PBX: %passname%}
   {return}

   {:closp}  note that world is password-protected
   {writ  Password-Protected PBX. Password: %passname%}
   {return}

 {:extopen} extensions are open-access
 {setv security,Open Access}
 {return}

 {:extprot} extensions are protected by password
 {setv security,Password Protected}
 {return}

- ------------------------------------------------------------
 open access world
- ------------------------------------------------------------


 {:wrldopen}                        open-access world
 {setv worldname,%cbvpass}          set passtext as world name
 {setv worldtype,Open Access}       establish world type
 {call askext}                      prompt for extension
 {return}


- -------------------------------------------------------------
password-protected world
- -------------------------------------------------------------

 {:wclosed}                                  password-protected world
 {setv worldname,-Name Unavailable-}         set passtext as world name
 {setv worldtype,Protected}                  establish world type
 {setv outmsg,Enter PBX Password}            prompt user to enter password
 {call passbox,m4gfx.M4}                     draw passbox
 {setv choictxt,Last entry to this PBX: %cbvdate%}   info about entry
 {call sendchoice}                           send info
 {call passbox,m4gfx.M4}
 {call askpass}                              ask password
 {comp password,%passname}                   is it good?
 {ifco-c askext,badpass}                     if so, ask extension else badpass
 {return}

- -------------------------------------------------------------
prompt world caller
- -------------------------------------------------------------

 {:askext} ask caller for extension to dial
 {setv repeat,askextqs,3}       ask extension questions
 {call repeat}                  three chances
 {comp fail,y}                  if failed
 {ifco quit}                    quit
 {call validial}                check for valid extension dialout string
 {return}

 {:askextqs}               ask all questions for extension
 {setv fail}               clear fail flag
 {call maxextlen}          get maximum field length based on modem buffer size
 {call extenbox}           draw box
 {comp graphics,0}         tty?
 {ifco-c ttyask1,ansiask}  if so, ask in tty
 {call queryext}           actual query field
 {comp fail}
 {ifco ret,rit}
 {return}

 {:extenbox}                     phone extension request box
 {setv blocks,}
 {subs fblocks,1,%maxextlen,%blocks}        get graphics block background
 {setv blocks}
 {setv txt1, PBX: %worldname% - %worldtype%                                             }
 {setv txt2, Extensions are %security%}
 {setv txt3, Append dialing string below with your extension/access codes}
 {setv txt4, }
 {setv txt5, %worldpfx%%fblocks%}
 {setv txt6, }
 {setv txt7, HELP: Press [Enter] by itself for help or to exit}
 {setv txt8}
 {call explode,m4gfx.M4}
 {return}

 {:maxextlen}  get maximum extension length that can be appended to dial string
 {setv maxextlen,%buffermax}
 {leng %worldpfx}
 {decr maxextlen,%_len}
 {leng %_dialpf}
 {decr maxextlen,%_len}
 {leng %_dialsf}
 {decr maxextlen,%_len}
 {return}

  {:ttyask1}                     input background for TTY
  {setv extquery,%intxt%}        simple cr/lf for TTY
  {return}

  {:ansiask}                                 set graphics background blocks
  {setv blocks,}
  {subs fblocks,1,%maxextlen,%blocks}        get graphics block background
  {setv blocks}
  {setv twid,4}
  {leng %worldpfx}
  {incr twid,%_len}
  {incr twid}
  {setv extquery,^[[13;%twid%H%intxt%%fblocks%^[[13;%twid%H} set ansi query string
  {return}

   {:queryext}                           actually ask for extension
   {send %extquery%}                     display query field
   {setg 20,extimout,y}                  20s timeout,extimeout;echo on
   {gets extension,%maxextlen,exthelp}   get input for MAXEXTLEN length
   {return}                              put in EXTENSION if enter, exthelp

    {:extimeout}                         extension input timeout
    {setv fail,y}                        fail=yes
    {setv txt1,NOTE:}
    {setv txt2,Input timeout. Please enter your extension.}
    {setv txt3, }
    {setv txt4}
    {call explode,m4gfx.M4}             display as box
    {return}

    {:exthelp}                     extension cbv help
    {setv fail,y}                  fail=yes
    {setv showfile,exten.hlp}      define help file
    {call et,m4gfx.M4}             display
    {return}

    {:validial}    check input to see if it's a valid dialout string
    {leng %extension}               get length of EXTENSION typed-in
    {setv idlen,%_len}              put in EXLEN
    {setv repeat,chkeachc,%idlen}   check each digit for EXLEN
    {call repeat}                   ...
    {comp fail,y}                   did input fail integrity?
    {ifco quit}                     if so, quit back
    {return}                        else, good entry

    {:chkeachc} check each char in EXTENSION for numeric-ness and comma-ness
    {setv fail}                           clear fail flag
    {subs digi,%timecount,1,%extension}   get one digit
    {inst numeric,%digi}                  is it numeric?
    {comp %_pos,0}                        if not
    {ifco-c chkcomma}                     then check for comma
    {comp fail,y}                         did it fail comma test?
    {ifco badentry}                       if bad, inform
    {return}                              else, next check

     {:chkcomma}                          check for comma
     {comp digi,,}                        was digit a comma?
     {ifco rit}                           if so return
     {comp digi,-}
     {ifco rit}
     {setv fail,y}                        if not, fail=on
     {return}                             return

   {:badentry}                                         bad entry was made
   {setv txt1,Your entry contained invalid characters}      ...
   {setv txt2,Only numbers and commas are acceptable }  ...
   {setv txt3}
   {call explode,m4gfx.M4}                            explode box
   {pause 1}
   {goto ret}


- -------------------------------------------------------------------------------
                      Read/Write Dialing Directory
- -------------------------------------------------------------------------------
                         --------------
                         Write Routines
                         --------------

 {:writcode}

 include passblanks to fill out missing chars in password field
 if new user, append to file, else locate old user and rewrite

 {unmark}
 {fonf %fonfile%}
 {wclos}
 {wopen m4temp.fon}
 {writ %_tim% %_dat% }
 {writ Temp file empty}
 {wclos}
 {call passblank}
 {comp newuser,y}
 {ifco-c neuwrite,relocate}
 {return}

 {:neuwrite}            write new user
 {fonf m4temp.fon}         load temp dir temporarily
 {wopen-a %fonfile%}    append current
 {writ  %cbvid% ^(%cbvnum%^) ^(%cbvpass%^)%passblan%^(%cbvstat%%cbvsecur%%cbvtries%^) ^(^) %_dat%}
 {wclos}
 {fonf %fonfile%}       load current
 {return}

  {:relocate}               rewrite old user
  {wopen m4temp.fon}
  {ropen %fonfile%,ret}
  {setv beforee,%tct}       get file pos before entry
  {decr beforee}
  {setv repeat,movdd,%beforee}
  {call repeat}
  {read %data}
  {writ  %cbvid% ^(%cbvnum%^) ^(%cbvpass%^)%passblan%^(%cbvstat%%cbvsecur%%cbvtries%^) ^(^) %_dat%}
  {setv repeat,movdd,999}
  {call repeat}
  {wclos}
  {rclos}
  {fonf m4temp.fon}                   load tmp fonfile, old commo is saved
  {call dd2tt}                     copy temp to commo fon
  {fonf %fonfile%}                 load commo fon with changes
  {return}

   {:movdd}       move thru dialing dir, reading & writing to temp file
   {read %data}
   {writ %data}
   {return}

  {:dd2tt}                      transfer tempdialing dir to commo
  {ropen m4temp.fon,ret}
  {wopen %fonfile%}
  {setv repeat,movdd,999}
  {call repeat}
  {wclos}
  {rclos}
  {return}

  {:cur2tmp}
  {ropen %fonfile%,ret}
  {wopen m4temp.fon}
  {setv repeat,movdd,999}
  {call repeat}
  {wclos}
  {rclos}
  {return}

                       -------------
                       Read Routines
                       -------------

 {:readdd}                   read dialing dir
 {setv fail}
 {setv tct,0}                reset temp counter
 {ropen %fonfile%,nther}      open file
 {call readdd1}
 {rclos}
 {return}
  {:readdd1}                 read in lines
  {incr tct}                 increment temp counter
  {read %entry}              read whole entry
  {subs cbvid,2,%idlen%,%entry}   extract cbvid number
  {comp cbvid,%cbvnumin}     is it the one the user input?
  {ifco rit}
  {goto readdd1}

   {:nther}
   {setv fail,y}
   {return}

- ------------------------------------------------------------------------------
                          End Write Routines
- ------------------------------------------------------------------------------
                              --------------
                              Super-Verified
                              --------------

                             super-verified (S)
 super-verified user is calling. No callback required.

 {:skipcbv}                                skip verification
 {setv newuser,n}                          not a new user
 {setv outmsg, Super-Verified Account}     note to user
 {call instruct}                           display
 {setv logtxt,[%cbvid%,%cbvcode%,%cbvdate%] Super-Verified}  log
 {call getime}                             log
 {comp cbvpass,%cbvid}                     was password  not established?
 {ifco-c toplev,vpass}                     if so make pass, else ask for pass
 {call wait4sys}                           show verified screen
 {call dobbs}                              do the bbs
 {exit}

- ------------------------------------------------------------------------------
                              verified
- ------------------------------------------------------------------------------

  verified user calling. is it too late at night? if so, ask password.
  then check to see if he called today. If so, drop his try counter.
  if not, reset counter. then re-write his access code to the dialing dir,
  and popback to callback.


  {:verified}
  {setv newuser,n}
  {setv outmsg, Verified Account}
  {call instruct}
  {setv logtxt,[%cbvid%,%cbvcode%,%cbvdate%] Verified}
  {call getime}
  {call vpass}                 ask for pass
  {call writcode}              write adjusted try count
  {setv fail}                  (from vtries: not used)
  {return}

  {:vtries}                    assess & adjust verifed user tries
  {comp calltoday,y}           user's last call today?
  {ifco downcount}             if so, bring counter down
  {comp calltoday,n}           user's last call today?
  {ifco recount}               if not, reset try counter
  {return}

   {:downcount}                 bring counter down
   {setv fail,y}                default fail=y
   {comp cbvtries,0}            are tries exhausted?
   {ifco rit}                   if so, return
   {setv fail}                  else fail=nul
   {decr cbvtries}              drop cbv try count
   {setv logtxt,[%cbvcode% to %cbvstat%%cbvsecur%%cbvtries%] Daily try-count reduced}
   {call getime}
   {return}

   {:recount}                   reset counter
   {setv logtxt,[%cbvcode% to %cbvstat%%cbvsecur%%cbvsecur%] Daily try-count replenished}
   {call getime}
   {setv cbvtries,%cbvsecur}    make tries=security level
   {call downcount}             and reduce try-count by 1
   {return}

    {:vpass}                get verified user password
    {comp fonfile,commo.fon}
    {ifco vpass1}
    {comp eaccess,O}
    {ifco rit}
    {call vpass1}
    {return}

    {:vpass1}
    {setv outmsg, Enter your password}
    {call passbox,m4gfx.M4}
    {call askpass}
    {setv choictxt,You last called: %cbvdate%}
    {call sendchoice}
    {comp password,%cbvpass}
    {ifco rit}
    {call badpass}
    {return}

   {:askpass}                   ask password 3 times, with 20s timeout
   {setg 20,passwait,y}         20s return from repeat
   {loca y}
   {spdc y}
   {setv fail}                  clear fail flag
   {setv early}                 clear early flag
   {setv repeat,getpass,3}      ask 3 times
   {call repeat}                "
   {comp early,yes}             early return?
   {ifco ,badpass}              if not, (blank field) quit
   {setv early}                 clear early flag
   {setv fail}                  clear fail flag
   {return}                     else return

    {:getpass}                  password template
    {setv logtxt, Asking for Password}
    {call getime}
    {setv password}             clear old password val
    {setv xoffset,17}           print offset
    {setv xxoff,%xoffset}       put col offset in XXOFF
    {incr xxoff,25}             XXOFF=instructions to right of input field
    {call passgraph}            password graphics
    {gets-p password,25}        password length 25
    {comp %password}            blank field?
    {ifco rit,ret}              if so repeat, else break repeat loop

     {:passgraph}
     {comp graphics,0}
     {ifco-c ttypass,anspass}
     {return}

      {:anspass}
**    {setv choices,^[[%ymsg%;%xoffset%H%intxt%}
      {setv instruct,^[[%yposy%;%xxoff%H%intxt%} refresh new INSTRUCT pos
      {call instruct}             clear old & show new instruction msg
      {send ^[[%yposy%;%xoffset%H%shadebk%^[[%yposy%;%xoffset%H}
      {return}

      {:ttypass}
      {setv instruct,^M^J%intxt%}
      {call instruct}
      {send ^M^JPassword?}
      {return}


 {:badpass}                       password did not match
 {comp password}
 {ifco nopass}
 {setv outmsg, Password did not match}
 {setv logtxt,[%password%] Password failed}
 {call quitwith}
 {return}

 {:nopass}                           empty password field
 {setv outmsg, No Password Entered}
 {setv logtxt, Empty Password failed}
 {call quitwith}
 {return}

 {:cdrop}
 {setv logtxt,Carrier dropped}
 {call restartm4}
 {return}

 {:quitwith}         restart bbs
 {call instruct}
 {:quit}             w/o local display
 {call outcbv}
 {return}

 {:restartm4}  restart M4 with logtxt message
 {call getime}
 {goto begin}

 {:woutcbv}              leave back to menus/logoff & write new date
 {call writcode}
 {:outcbv}
 {call getime}
 {comp menus,ON}
 {ifco ,exitcyc}
 {call menu_beg,m4popcom.M4}
 {stop}


 {:police}
 {setv logtxt,[%cbvnumin%] Taboo Number Entered}
 {call restartm4}
 {return}

- -------------------------------------------------------------------------------
                              maybe
- -------------------------------------------------------------------------------

 user has not verified; check if too late - if so, inform, hangup
 if not, tell him last attempt failed; if last call was today, lower
 try count. If last call wasn't today, lower security level. If security
 level is zero, quit. If not, callback.

{:maybe}                       user has not verified
{setv logtxt,[%cbvid%,%cbvcode%,%cbvdate%] Unverified}
{call getime}
{comp cbvsecur,0}              is he effectively locked out?
{ifco-e mallused}              if so, hangup
{call myarea}                  in my areacode?
{call prefixok?}               is prefix ok?
comp cbvtries,0}              has he used all his tries today?
ifco-e mcantcall}             if so, tell him to call back tomorrow
{call toolate}                 if too late, inform w/o penalty
{comp lateflag,y}              if so,
{ifco calater}                 tell him to call later
{call tellfail}                inform that last attempt failed
{comp calltoday,y}             called today?
{ifco-c downmct,downlev}       if so, drop count,else drop lev
{call writcode}                write revised cbvinfo
{return}

{:mcantcall}
{setv outmsg, Try again tomorrow!}
{setv logtxt,Daily attempts exceeded}
{pause 1}
{call instruct}
{call outcbv}
{return}

{:mallused}
{setv outmsg, Access Denied}
{setv logtxt,[%cbvcode%,%cbvnum%] Unconfirmed bad number}
{call instruct}
{pause 1}
{call outcbv}
{return}

 {:downmct}             drop call count
 {comp cbvtries,0}      all tries used today?
 {ifco mcantcall}       if so, can't call him today
 {decr %cbvtries}       drop call count
 {return}

 {:downlev}          bring user level down, if zero, goodbye
 {setv outmsg, Sorry, all attempts used}
 {setv logtxt,Remaining attempts exhausted}
 {comp cbvsecur,0}             security lev at 0?
 {ifco outcbv}                 if so, he can go no further
 {decr cbvsecur}               else, drop security level
 {setv cbvtries,%cbvsecur}     set tries left=days left
 {return}

 {:tellfail}
 {setv outmsg, Your last CBV attempt failed}
 {call instruct}
 {setg 5,,y}
 {gets crlf}
 {return}

    {:calater}              inform user to call later
    {setv outmsg, Number noted}
    {setv logtxt,CBV attempt is too late}
    {call instruct}
    {setg 1,,y}
    {gets crlf}
    {setv txt1, Sorry, but this is not an acceptable time to verify. }
    {setv txt2, Please note that new verifications can only be made  }
    {setv txt3,              %cbvstart% to %cbvend%}
    {setv txt4}
    {call explode,m4gfx.m4}
    {setg 15}
    {gets crlf}
    {call outcbv}
    {return}

- -------------------------------------------------------------------------------
                                new
- -------------------------------------------------------------------------------

{:newnum}                           number does not exist in dialing dir
{setv newuser,y}                    set newuser flag
{call myarea}                       in my areacode?
{call prefixok?}                    is prefix ok?
{call newcode}                      establish code
{call toolate}                      too late to verify..
{comp lateflag,y}                   is it?
{ifco calater}                      if so, send msg, hangup
{return}

  {:newpass}                repeat ask-password/confirm 3 times
  {setv early}              clear early flag
  {setv repeat,2pass,3}     repeat pass-one and confirm 3 times
  {call repeat}
  {setv logtxt,User could not establish password}
  {comp early,yes}          was exit early?
  {ifco ,restartm4}         if so, return else quit
  {setv logtxt,Password established}
  {call getime}
  {setv logtxt,"%password%"}
  {call getime}
  {setv outmsg, Password established}
  {call instruct}
  {setv choictxt,You are verified. Please wait...}
  {return}

   {:2pass}                  ask password 3x, 20s timeout
   {setg 5,passwait,y}       wait 5 seconds for keypress
   {setv fail}               clear fail flag
   {setv pass1}              clear old value in pass1
   {setv pass2}              clear old value in pass2
   {call pass1}              initial pass
   {comp fail,y}             did pass1 field fail?
   {ifco rit}                if so, return
   {call pass2}              confirmation pass
   {comp pass2,%pass1}       if they match,
   {ifco ret}                exit from this sub
   {setv logtxt,Passwords did not match}
   {call getime}
   {setv choictxt,NOTE: Passwords did not match, Press <enter>}
   {call sendchoice}         send blue msg
   {setg 5,passwait,y}       wait 5 seconds for keypress
   {setv choice}             clear old value
   {gets-h choice,1}         get on char
   {return}

   {:pass1}                  ask initial pass
   {setv choices,^[[13;17H%intxt%}
   {setv instruct,^[[12;50H%intxt%}
   {setv outmsg, Input a desired password}
   {setv choictxt,NOTE: Password must be 5-25 chars long}
   {call sendchoice}
   {call askpass}            ask password
   {leng %password}          get length of input
   {setv len,%_len}          put %_len in len
   {comp len,5}              greater or equal to 5?
   {ifco-ge ,pas2short}      if not pass was too short
   {setv pass1,%password}    put in pass1
   {return}

   {:pass2}                  ask second pass to confirm
   {setv choices,^[[13;17H%intxt%}
   {setv instruct,^[[12;50H%intxt%}
   {setv outmsg, Input pass again to confirm}
   {call askpass}            ask again
   {setv early}              clear early flag
   {setv pass2,%password}    put in pass2
   {return}

   {:pas2short}              password too short
   {setv logtxt,Pass too short (%len%)}
   {call getime}
   {setv choictxt,Password too short (%len%), Press <enter>}
   {call sendchoice}         inform
   {setg 5,passwait,y}       wait 5s
   {setv choice}             clear old response
   {gets-h choice,1}         get on char
   {setv fail,y}             set fail to yes
   {return}

   {:passwait}             tell user about input timeout
   {setv logtxt,User input timeout warning}
   {call getime}
   {setv choictxt,Timeout in 5 seconds, Press <enter>}
   {call sendchoice}       send blue text
   {setg 5,restartm4,y}         in 5 seconds, quit
   {setv choice}           clear old choice
   {gets-h choice,1}       get one char
   {setv fail,y}           set fail flag
   {return}

  {:newcode}                 establish new cbv account
  {setv cbvid,%cbvnumin}
  {comp fonfile,commo.fon}
  {ifco-c normlnew,worldnew}
  {setv cbvstat,M}
  {setv cbvsecur,3}
  {setv cbvtries,3}
  {setv cbvpass,%cbvid}
  {call writcode}
  {setv logtxt,[%cbvstat%%cbvsecur%%cbvtries%,%cbvid%] New}
  {call getime}
  {return}

  {:normlnew}
  {comp calltype,10}
  {ifco-e 10type}
  {subs cbvnum,4,7,%cbvnumin}
  {setv cbvnum,    %cbvnum}
  {return}

  {:10type}
  {setv cbvnum,1%cbvid%}
  {return}

  {:worldnew}
  {setv cbvnum,%worldpfx%%cbvnumin%}
  {return}

   {:passblank}                       set passblanks var to fit format
   {setv passblank, }                 default passblank 1 blank
   {comp fonfile,commo.fon}
   {ifco ,rit}
   {setv plen,26}
   {leng %cbvpass}
   {decr plen,%_len}
   {subs passblan,1,%plen%,%blankvar}
   {return}

   {:myarea}                 is num in my areacode?
   {comp areacode,%myarea}   is this in 206 areacode?
   {ifco 7digit}             if so it's a 7digit number
   {inst altarea,%areacode}  is areacode in alternate areacode list?
   {comp %_pos,0}            if not in list
   {ifco-e ,10digit}         fall-thru, else note as 10 digit num
   {setv calltype,0}         since neither, note as 0 digit num
   {call nmyarea}
   {return}

   {:7digit}   this call will be a 7-digit dialout
   {setv calltype,7}
   {return}

   {:10digit}  this call will be a 10 digit dialout
   {setv calltype,10}
   {return}

   {:prefixok?}  check phone prefix for this areacode
   {setv prefixok,n}           default is not found
   {setv repeat,chxprx,999}    parse arrays up to 999 times
   {call repeat}               ''
   {comp prefixok,n}           is it a bad prefix?
   {ifco nmyarea}              if so, pop user
   {setv prxvar}               clear vars
   {setv prxok}                clear
   {return}

    {:chxprx}    check prefix against ok tables for this area code
    {setv-s prxvar,%areacode%_%timecount%} this is var: 206_1
    {comp prxvar}                          is var empty?
    {ifco ret}                             if so, done
    {inst prxvar,%prefix}                  is prefix in list?
    {comp %_pos,0}                         if not
    {ifco rit}                             return
    {setv prefixok,y}                      else set okflag
    {goto ret}                             and quit

   Note: if person is let into bbs at this point as guest,
         no callback should be made!

   {:nmyarea}
   {call newcode}
   {setv outmsg, Indexing...}
   {setv logtxt,Not a local call}
   {call instruct}
   {setg 1,,y}
   {setv txt1, Your number is not locally dialable. Therefore, BBS access }
   {setv txt2, cannot be granted. However, your number has been noted in  }
   {setv txt3, the system dialing directory. }
   {setv txt4}
   {call explode,m4gfx.m4}
   {setg 5,,y}
   {gets crlf}
   {call outcbv}
   {stop}

- -------------------------------------------------------------------------------
                               callback
- -------------------------------------------------------------------------------


{:calluser}
{setv baud}
{setv disptform,y}
{spdc n}
{setv fail}
{setv early}
{clear}
{call faketop}
{setv logtxt,Calling-back user}
{call getime}
{call modemprep}             prepare modem internally
{call dtt}                   test line and clear it of silent caller
{call ctcbv}                 dialback - one try. so we know user disconnected
{call cbv}                   verify - one try
{comp fail}
{ifco rit,restartm4}

   {:cbv}                            telco callback verify
   {pause %recover}                  wait for dialtone to recover
   {setv logtxt,Waiting for %silent%s of inactivity}
   {call getime}
   {setv logtxt,Activity sensed during silent pause}
   {setg %silent,,n}
   {gets modmess,40,restartm4}
   {call hangup}                     check for carrier
   {setv fail}                       clear fail flag
   {unmark}                          unmark all nums
   {mark %cbvid%}                    mark callback num
   {setv modtxt,%_dialpf%%cbvnum%}   modem text
   {setv logtxt,Dialing %cbvnum%}    log text
   {call getime}                     log
   {setd %callwait%,1}               dialout 100, wait 1
   {dial 1,cbv1,cbv2}                dialout, when done: cbv1
   {:cbv1}                           return point for dialout
   {setv modtxt,%_dialrt%}           modem text
   {comp %_dtc,4}                    operator intervention?
   {ifco operator}                   if so, stop
   {comp %_dtc,2}                    fail?
   {ifco cdfail}                     if so, cdfail
   {comp %_dtc,3}                    software timeout?
   {ifco cdtimout}                   if so, cdtimeout
   {comp %_dtc,0}                    no number?
   {ifco cnumnot}                    if so, cnumnot
   {comp %_dtc,1}                    if dtc=1
   {ifco cdsuc}                      success
   {call restartm4}                  else quit
   {return}

   {:cbv2} Interdial response recieved
   {setv modtxt,%_dialrt%}
   {setv logtxt,Interdial Response [DTC=%_dtc%]}
   {goto restartm4}

   {:cdsuc}                 successful re-connect
   {setv message,%_dialrt}  make dialing response text our modem message
   {spdc n}
   {setv fail}
   {setg %intercon%,rit,n}  in case SAMELINE=N set get parms
   {call twomess}           get 2nd connect string, and diagnose connect msg
   {setv fail}              clear fail flag
   {noca cdrop}             carrier check
   {call m4idcbv}           id flag
   {call badrate}           check for bad baud rate
   {setv disptform,n}       no log display
   {send %bg%%clr%}         clear screen
   {return}

   {:wait4sys}
   {setv usrprompt,Please wait. Preparing system ...}
   {setv txt1,%sysname%}
   {setv txt2,     -= Verified Caller =-     }
   {setv txt3,       Preparing system...     }
   {setv txt4}
   {call explode,m4gfx.M4}
   {return}

   {:cdfail} problem dialing out, callout again
   {comp %_dialrt,NO CARRIER}
   {ifco cdhardf}
   {setv logtxt,Dialing Failure [DTC=%_dtc%]}
   {call getime}
   {setv fail,y}
   {return}

   {:cdhardf}
   {setv logtxt,Dialing Hardware Timeout [DTC=%_dtc%]}
   {goto restartm4}

   {:cdtimout} possibly voice connect, quit
   {setv logtxt,Dialing Software Timeout [DTC=%_dtc%]}
   {goto restartm4}

   {:cnumnot} for some reason, disk error, no number in dir so quit
   {setv logtxt,No Number in CBV PhoneDir [DTC=%_dtc%]}
   {goto restartm4}


{:queryusr}                 ask user for password, etc
{setv early}                clear EARLY flag
{comp cbvstat,M}            is security lev at 0?
{ifco-c uplev}              if so bring it to Verified
{return}

    {:uplev}      bring security level up
    {setv usrprompt,Waiting for Input}
    {call passbox,m4gfx.M4}                       make password GFX
    {call newpass}                                 establish password
    {setv cbvcode,%cbvstat%%cbvsecur%%cbvtries%}   establish CBVCODE
    {setv cbvstat,V}                               and CVBSTATus
    {setv cbvsecur,4}                              and CBVSECURity level
    {setv cbvtries,4}                              and CBVTRIES remaining today
    {setv cbvpass,%password}                       and CBVPASSword
    {setv newuser,n}                               not a new user
    {setv logtxt,[%cbvcode% to %cbvstat%%cbvsecur%%cbvtries%] Security Level Raised}
    {call getime}                                  log
    {call writcode}                                write new info
    {return}


    {:toplev}   top-level access Super-Verified
    {setv usrprompt,Waiting for Input}
    {call passbox,m4gfx.M4}                        make password GFX
    {call newpass}                                 establish password
    {setv cbvcode,%cbvstat%%cbvsecur%%cbvtries%}   establish CBVCODE
    {setv cbvstat,S}                               and CVBSTATus
    {setv cbvsecur,4}                              and CBVSECURity level
    {setv cbvtries,4}                              and CBVTRIES remaining today
    {setv cbvpass,%password}                       and CBVPASSword
    {setv newuser,n}                               not a new user
    {setv logtxt,[%cbvcode% to %cbvstat%%cbvsecur%%cbvtries%] Security Level Raised}
    {call getime}                                  log
    {call writcode}                                write new info
    {return}



- ------------------------------------------------------------------------------
                   TCBV for CBV
- ------------------------------------------------------------------------------

   {:ctcbv}                               telco callback verify
   {pause %recover}
   {ifca restartm4}
   {setg %tcbvlisten%,rit,n}             listen for x seconds, return on timeout
   {setv out,%_dialpf%%mynum}  set dial string
   {setv logtxt,Dialing TelCo}
   {setv modtxt,%out}
   {call getime}
   {ifca restartm4}
   {call modmess}                        check for modem message
   {comp message}                        if no reponse (software timeout)
   {ifco ctcbvwait}                      wait for ringback
   {setv logtxt,Error: Modem Hardware Timeout}  set log
   {comp message,NO CARRIER}             NO CARRIER? (modem timed out)
   {ifco restartm4}                      increase modem timout register
   {setv logtxt,Inappropriate message}   bad message
   {goto restartm4}                      otherwise dialtone test
   {return}

   {:ctcbvwait}                          wait for telco ringback
   {ifca restartm4}
   setv out,%mcts}
   {setg 5,rit,n}                       wait for NO CARRIER for 5 seconds
   {call modmess}                       get modem message, MCTS implied
   {comp message,NO CARRIER}
   {ifco ,badone}
   {setv logtxt,Disconnecting}
   {call getime}
   {setv logtxt,Waiting for ringback}
   {call getime}
   {setg %tcbvwait%,rit}                set wait period for incoming RING
   {call modmess}                       wait for ring
   {call ctcbvok?}                      check if we got RING
   {return}                             repeat, else quit

   {:ctcbvok?}                           did telco callback?
   {ifca restartm4}
   {comp message,RING}                  if not
   {ifco ,badone}                       bad response
   {setv logtxt,Incoming call}
   {call getime}
   {call offhook}                       phone offhook
   {pause %recover}                     wait for hangup
   {call onhook}                        phone onhook
   {setv logtxt,TelCo ringback OK}
   {call getime}
   {return}                             and return

    {:badone}                           telco callback didn't work
    {setv logtxt,Bad modem message}
    {goto restartm4}


- ------------------------------------------------------------------------------
                   Day/Date/Time Coversion routines
- ------------------------------------------------------------------------------
 {:toolate}            see if cbv is too late
 {call soundonoff}     set sound toggle
 {setv testvar,ver}    set late flag for verification
 {call toolate?}
 {return}

 {:dconvert}                       convert mm/dd/yy format to DDDD days
 {setv calltoday,y}                CALLTODAY=Y
 {setv inmonth,%month}
 {setv inday,%day}
 {setv inyear,%year}
 {call 0ad,m4event.M4}              convert today's date to days
 {return}

 {:compday}                        compare days
 {setv dtoday,%from0ad}
 {setv inmonth,%cbvmonth}
 {setv inday,%cbvday}
 {setv inyear,%cbvyear}
 {call 0ad,m4event.M4}              convert last connect date to days
 {setv drecord,%from0ad}
 {comp dtoday,%drecord}
 {ifco rit}
 {setv calltoday,n}                CALLTODAY=N
 {return}

- ------------------------------------------------------------------------------
                              End CBV
- ------------------------------------------------------------------------------


-----BEGIN PGP SIGNATURE-----
Version: 2.6.2

iQEVAwUBLx1mlh1uLkXXbMBBAQHlhgf/SjxQ7CF8hYSQD9d87tRhHDAMO1aY9r/P
a8hJaEZS58fVwv2LtTpIIj7nDeqm8sQWq16gpe6loYv2v9THYJ9lwB+P5LeGMCg+
5iF+2QQ57Kb29l8FpgjDgNuIQEfCzOegmTuPEVCq+kIyAjNorF6cUz2QerIIkIYY
GFrNrgKYNyJhCgeoT91Y6ljSpgYnpRyGl0TEMFGb92Ud1oaMrUHjrSysobMnS29f
SE9rHsP5IZJWBUYox6EBASZEukFOmLuCKW+S5J+8W3J1gsGpdLaNDpmXsMUJTdiv
lbS2Pdsvyp9pphkRGMok0nenilivr49NYMFkCHKSifsy/eJ1INHv0w==
=DuM9
-----END PGP SIGNATURE-----
