-----BEGIN PGP SIGNED MESSAGE-----

- -----------------------------------------------------------------------------
                         Special Routines
- -----------------------------------------------------------------------------

{:rit}                  return
{return}

{:ret}                  early return sub to breakout of repeat command
{setv early,yes}        if this flag is set to yes, an early return was done
{pops}                  clear last location on macro stack
{setv timec%rnestnum}   clear old vars
{setv rnest%rnestnum}   ""
{return}

{:st}{}                 all stop

                           -----------------
                            Repeat Command
                           -----------------

Input var: repeat   (format: subroutine,# repetitions)

{:repeat}
{setv timecount,0}                        clear out current repetition counter
{comp rnestnum}
{ifco-c makenest}
{incr rnestnum}                           add one to Repeat NEST NUMber
{call takeapart}                          dissassemble repeat arguments
{call storit}                             store arguments for this level in array
{call repeat1}                            run the desired sub x number of times
{call restorit}                           restore arguments if called from
{return}                                  another repeat statememt

 {:takeapart}                              dissassemble command arguments
 {instr repeat,,}                          find first comma in REPEAT
 {setv cpos,%_pos}                         left-of-comma
 {decr cpos}                               decrement to make left of comma
 {subs sub,1,%cpos%,%repeat}               left-trunc from comma for SUBname
 {subs repetitions,%_pos%,100,%repeat}     right-trunc from comma for REPTETITIONS
 {subs repetitions,2,100,%repetitions}     comma out
 {return}

 {:restorit}                              restore old sub with parms
 {decr rnestnum}                          pop back to last repeat level
 {comp rnestnum,0}                        is level 0?
 {ifco-le rit}                            if so, we're done
 {setv-s repeat,rnest%rnestnum}           reassign stored command arguments
 {call takeapart}                         dissassemble them as if new
 {setv-s timecount,timec%rnestnum}        restore last execution-count
 {return}

 {:storit}                               store arguments, and exe count
 {setv rnest%rnestnum%,%repeat}          repeat parms to Repeat NEST array
 {setv timec%rnestnum%,%timecount}       store execution-count
 {return}

         {:repeat1}                       perform repetetive call to subroutine
         {comp timecount,%repetitions}    see if repeat count has been met
         {ifco-e rit}                     if so, return
         {incr timecount}                 increment repeat counter
         {call storit}                    store arguments + exe counter
         {call %sub}                      `execute' subroutine
         {goto repeat1}

            {:makenest}                   sets rnestnum if not set
            {setv rnestnum,0}
            {return}

                               ----------
                               End Repeat
                               ----------
{:ins}
{:begin}
clear}
{call setup}
{call fselbox}
{call homfiles}
{call homepath}
{setv path,%home%\%mask%}
{call hom}
{stop}
{return}


{:hom}
{call homfiles}
{call newset}
{call showfiles}
{call topbar}
{return}

{:setup}
{parm ,,,T,}
{curs n}
{wind-k}
{setv blanks,                                        }
{setv maxfiles,14}          1-24  files displayed
{setv fclr,70}
{return}

- ----------------------- file selector boxes -----------------------------

{:fselbox}        file selector boxes
{call backbox}
{call filebox}
{call infobox}
{call instruct}
{return}

 {:backbox}                   background box for file selector
 {setv boxdim,21,42}           x,y
 {setv boxat,3,15}            x,y
 setv boxcolor,78}
 setv boxcolor,31}
 {setv boxcolor,50}
 {call setbox}
 {call showbox}
 {return}

  {:filebox}                            file selector window
  {setv boxcolor,79}
  {setv fwinhi,%boxhi}                  win to # files
  {decr fwinhi,4}                       add two for window heighth
  {setv fwinwid,12}                     width to filename wid +2
  {setv fwincol,%boxcol}                display col=boxcol
  {incr fwincol,2}                      add 1 for display col
  {setv fwinrow,%boxrow}                display row=box row
  {incr fwinrow,2}                      add one to disp one below
  {call fil2box}                        transfer these vars to boxvars
  {return}

  {:infobox}
  {setv boxcolor,75}
  {setv boxdim,6,21}           x,y
  {setv boxat,5,33}            x,y
  {call setbox}
  {call showbox}
  {setv boxcolor,79}
  {return}

  {:instruct}
  {parm ,,,T,}
  {setv icol,34}
  {setv tcol,40}
  {setv kc,5b}
  {setv ic,51}
  {disp 12,%icol,%kc,PgUp}
  {disp 12,%tcol,%ic,Last page}
  {disp 13,%icol,%kc,PgDn}
  {disp 13,%tcol,%ic,Next page}
  {disp 14,%icol,%kc,Home}
  {disp 14,%tcol,%ic,Top of dir}
  {disp 15,%icol,%kc,End}
  {disp 15,%tcol,%ic,End of dir}
  {disp 16,%icol,%kc,Esc}
  {disp 16,%tcol,%ic,Quit}
  {disp 17,%icol,%kc,Enter}
  {disp 17,%tcol,%ic,Select}
  {disp 18,%icol,%kc,}
  {disp 18,%tcol,%ic,Move Selector}
  {disp 19,%icol,%kc,>}
  {disp 19,%tcol,%ic,Select File/Dir}
  {disp 20,%icol,%kc,<}
  {disp 20,%tcol,%ic,Back Dir}
  {return}



  {:fil2box}
  {setv boxdim,%fwinhi%,%fwinwid%}
  {setv boxat,%fwinrow%,%fwincol%}
  {setv fcol,%fwincol}
  {incr fcol}
  {call setbox}
  {call showbox}
  {return}


- ------------------- box-drawing routines ------------------------

 {:setbox}
 {call boxdim}             get box dimensions
 {call boxat}              get box display position
 {call boxwinchars}        get box dislay chars
 {return}

  {:boxdim}                get box dimensions
  {setv dim,%boxdim}
  {call getdim}
  {setv boxhi,%row}
  {setv boxwid,%col}
  {setv boxbet,%bet}
  {return}

  {:boxat}                det box display pos
  {setv dim,%boxat}
  {call getdim}
  {setv boxrow,%row}
  {setv boxcol,%col}
  {return}

   {:getdim}              disassemble dimensions (display or size)
    input:  dim
    output: row,col,bet
         row=x-pos
         col=y-pos
         bet=x-pos-2     (middle chars between)
   {instr dim,,}
   {setv pos,%_pos}
   {setv posl,%pos}
   {setv posr,%pos}
   {decr posl}
   {incr posr}
   {subs row,1,%posl,%dim}
   {subs col,%posr,100,%dim}
   {setv bet,%row}
   {decr bet,2}
   {setv posl}
   {setv posr}
   {setv pos}
   {setv dim}
   {return}


 {:boxwinchars}           get box window chars
 {setv bshad,}
 {setv yblks,                                                                                    }
 {setv yline,}
 {setv xline,}
 {subs boxlintop,1,%boxwid,%yline}
 {setv boxwintop,%boxlintop%}
 {subs boxmiddl,1,%boxwid,%yblks}
 {setv boxmiddl,%xline%%boxmiddl%%xline%}
 {setv boxwinbot,%boxlintop%}
 {setv boxlintop}
{call shadset}
 {setv xline}
 {setv yline}
 {setv yblks}
 {return}

 {:shadset}
 {setv shadwid,%boxwid}
 {incr shadwid,2}
 {subs botshad,1,%shadwid,%yblks}
 {setv botshadoff,%boxcol}
 {incr botshadoff}
 {setv betshad,%boxwid}
 {incr betshad,%boxcol}
 {incr betshad,2}
 {return}

- --------- display box --------------------------------------------


 {:showbox}                                   display box
 {disp %boxrow,%boxcol,%boxcolor,%boxwintop}       disp top @ boxrow,boxcol
 {setv repeat,boxlines,%boxbet}             disp middle of box lines
 {call repeat}                              for BOXBETween times
 {setv row,%timecount}                      assign new row offset for
 {incr row,%boxrow}                         bottom of box
 {disp %row,%boxcol,%boxcolor,%boxwinbot}          and display it
 return}
 {incr row}
 {disp %row,%botshadoff,00,%botshad}
 {decr row}
 {return}

   {:boxlines}                              disp middle of box lines
   {setv row,%timecount}                    assign cur count to ROWline
   {incr row,%boxrow}                       make it offset of last disp line
   {disp %row,%boxcol,%boxcolor,%boxmiddl%}         display middle of box line
{disp %row,%betshad,00, }
   {return}
- -------------------------------------------------------------------

            File-gathering
- ----------------------------------------------------------------

{:files}
{comp page,1}
{ifco-c page1}
{call firstfile}
{call nextfiles}
{return}


{:homfiles}                   initialize file display
{setv page,1}
{setv atend}
{setv firstpass,1}
{setv stormor}
{setv frow,%fwinrow}
{incr frow}
call defmask}
{setv mask,*.*}
{setv show,y}
{setv store,y}
{call files}
{return}

:defmask}
comp mask}
ifco ,rit}
setv mask,*.*}
return}

 {:homepath}                      reorient to home dir
 {setv home,%_hom}
 {leng %home}
 {setv len,%_len}
 {decr len}
 {subs %home,1,%len,%home}
 {subs homedisk,1,2,%home}
 {return}

 {:firstfile}                     get 1st file in directory
 {comp firstpass,1}               if not firstpass
 {ifco ,rit}                      return
 {file %path%}                    else, get first snapshot of dir
 {setv f0,%_ffn}                  assign first file to f0
*{setv s0,%_ffs}
*{setv t0,%_ffd% @ %_fft%}
 {setv justgot,%_ffn}             note this was last filename
 {return}

 {:nextfiles}                     get subsequent files
 {setv f2get,%maxfiles}           num files to get=max files
 {decr f2get,%firstpass}          subtract 1 if first pass
 {setv repeat,getfile,%f2get%}    repeat getfile this many times
 {call repeat}
 {setv shortlist,%timecount}
 {incr shortlist,%firstpass}
 {setv firstpass,0}
 {return}

  {:getfile}                     get a file, assign to array
  {file-x}                       get non-1st file
  {setv thisfile,%_ffn}          put to thisfile
  {call atend?}                  at end of dir?
  {comp store,y}                 if store=on
  {ifco-c storefile}             store file in array
  {comp atend,y}
  {ifco ret}
  {return}

    {:storefile}                 store file in array
    {setv araypos,%timecount}    current array pos = counter
    {decr araypos}               subtract 1 (so 1st file is F0 if non-1st pass)
    {incr araypos,%firstpass}    add one if first pass (1st file is f1)
    {setv-s f%araypos,thisfile}  assign to f(arraynum)
*   {setv s%araypos,%_ffs}
    {setv t%araypos,%_ffd% @ %_fft%}
    {return}

    {:atend?}                    are we at end of list?
    {comp justgot,%thisfile}     is file we just got this file?
    {ifco-c atend}               if so were at end
    {setv justgot,%thisfile}     assign thisfile to just got
    {return}

     {:atend}
     {setv thisfile,### End ### }
     {setv atend,y}
     {setv wegot,%timecount}
     {incr wegot}
     {return}

     {:enddata}
     {setv s,No}
     {setv t,No Time/Date       }
     {return}

     {:blankfil}
     {setv thisfile,            }
     {return}
- ------------------------------------display files


 {:showfiles}
 {setv repeat,show,%shortlist%}
 {call repeat}
 {comp shortlist,%maxfiles}
 {ifco-e rit}
 {incr frow}
 {setv blankfiles,%maxfiles}
 {decr blankfiles,%shortlist}
 {setv repeat,blankbx,%blankfiles%}
 {call repeat}
 {return}

    {:show}
    {setv fc,%timecount}
    {decr fc}                           start counting from 0
    {setv-s thisfile,f%fc}              grab file from f0 (first file)
    {setv frow,%fwinrow}                default file window row
    {incr frow}                         add one to put inside border
    {incr frow,%fc}                     add offset for file display pos
    {disp %frow,%fcol,%fclr,%thisfile}  display
    {return}


    {:blankbx}
    {setv blbord,               }
    {incr frow}
    {disp %frow,%fwincol,%fclr,%blbord}  display
    {return}

{:pgd}
{comp atend,y}                 are we at end of dir?
{ifco rit}                     if so, return
{incr page}                    advance page
{call files}                   get files
{call newset}
{call showfiles}               draw box
{call topbar}
{return}

{:newset}
{setv fwinhi,%shortlist}       shortlist is how many files we got
{incr fwinhi,3}                add 3 for box-height
{call fil2box}                 calc box parms
{return}


{:pgu}
{comp page,1}
{ifco rit}
{setv atend}
{decr page}
{call getf2skp}
{call files}
{call newset}
{call showfiles}
{call botbar}
{return}

 {:page1}
 {setv firstpass,1}
 {return}

 {:getf2skp}                 get files to skip
 {comp page,1}               after decr are we at pg 1?
 {ifco-e rit}                if so, return
 {setv f2skip,%page}         else get number of pages
 {decr f2skip}               go back 1 (skip upto page before display page)
 {mult f2skip,%maxfiles}     find num of files to skip ala pages
 {decr f2skip}               take off one file to skip due to first file
 {file %path}                get first file
 {setv repeat,skpfiles,%f2skip}    get rest of em
 {call repeat}
 {return}

    {:skpfiles}   skipo this'n
    {file-x}
    {return}


 {:end}
 {call wholedir}                get whole directory
 {setv page,%lastpage}
 {incr araypos}
 {setv f%araypos,### End ### }
 {incr araypos}
 {setv shortlist,%araypos}
 {call newset}
 {call showfiles}
 {decr araypos}
 {call botbar}
 {return}


 {:wholedir}                  get whole directory w/last page & last file num
 {setv early}
 {setv lastpass,0}            set last pass flag to 0  (no)
 {setv firstpass,1}           set first pass flag to 1 (yes)
 {file %path}                 get 1st file
 {setv justgot,%_ffn}         make it one we just got
 {setv f0,%_ffn}              assign as f0 in array
 {setv lastfile,1}            default last file (1)
 {setv repeat,nextpage,999}   get a page of files at a time until end of dir
 {call repeat}                ""
 {setv lastpage,%timecount}   note last page gotten
 {return}

  {:nextpage}                       get a page of files
  {setv f2get,%maxfiles}            set initial # files-to-get at default
  {decr f2get,%firstpass}           subtract 1 if first pass
  {setv repeat,skip2end,%f2get%}    skip # files in one page
  {call repeat}                     ""
  {setv firstpass,0}                since after 1st pass, set to zero
  {incr lastfile,%timecount}        add # files found to lastfile marker
  {comp early,yes}                  did we return early from file get?
  {ifco ,rit}                       if not, return
  {setv lastpass,1}                 else, flip lastpass flag
  {goto ret}                        and exit

   {:skip2end}                     skip file with check for end
   {file-x}                        get (next)file
   {setv thisfile,%_ffn}           filename is THISFILE
   {comp thisfile,%justgot}        is file we have, one we just got?
   {ifco ret}                      if so, we are done with dir
   {setv araypos,%timecount}       set F(array) pointer to filecount
   {decr araypos}                  subtract one to make file#1->F(0)
   {incr araypos,%firstpass}       if firstpass, add 1 for non-x file gotten
   {setv-s f%araypos,thisfile}     assign to array for later use
   {setv justgot,%thisfile}        else make JUSTGOT=THISFILE
   {return}

- ------------------------------------------------------------------

{:botbar}                         reset bar
{setv araynum,%araypos}
{setv-s thisfile,f%araynum}
{call buffile}
{setv xpos,%fwinrow}
{incr xpos,%araypos}
{incr xpos}
{setv ypos,%fwincol}
{incr ypos}
{call newbar}
{return}


{:topbar}
{setv araynum,0}
{setv-s thisfile,f%araynum}
{call buffile}
{setv xpos,%fwinrow}
{incr xpos}
{setv ypos,%fwincol}
{incr ypos}
{call newbar}
{return}

 {:buffile}                         buffer filename with blanks
 {setv thisfile,%thisfile%%blanks}
 {subs thisfile,1,12,%thisfile}
 {return}

 {:newbar}
 {disp %xpos,%ypos,4e,%thisfile}
 {setv-s s,s%araynum}
 {setv-s t,t%araynum}
 {comp thisfile,### End ### }
 {ifco-c enddata}
 {disp 6,34,74, %thisfile%     }
 {disp 7,34,71,                   }
 {disp 7,34,71, %s% bytes}
 {disp 8,34,71, %t%}
 {disp 4,18,51,                                     }
 {disp 4,18,5b,%path%}
 {return}

 {:oldbar}
 {disp %xpos,%ypos,70,%thisfile}
 disp %xpos,31,71,                                   }
 {return}

{:dna}
{comp araynum,%araypos}
{ifco pgd}
{call oldbar}
{incr xpos}
{incr araynum}
{setv-s thisfile,f%araynum}
{call buffile}
{call newbar}
{return}

{:upa}
{comp araynum,0}
{ifco pgu}
{call oldbar}
{decr xpos}
{decr araynum}
{setv-s thisfile,f%araynum}
{call buffile}
{call newbar}
{return}

{:rta}
{:ent}
{comp thisfile,### End ### }
{ifco rit}
{subs dirchars,1,3,%thisfile}
{comp dirchars,\..}
{ifco pathback}
{subs pathdown,1,1,%dirchars}
{comp pathdown,\}
{ifco-c pathdown,select}
{return}

{:lfa}
{call pathback}
{return}

{:select}
{call fpath}
{setv file,%fpath%\%thisfile%}
{info-q Select: %file%?}
{ifex %home%\%thisfile%,fthere}
{info-q File must be copied to M4 directory. Copy?}
{ifco ,resfile}
{exec copy %file% %home%}
{call quit}
{return}

 {:resfile}
 {setv thisfile,%oldfile}
 {return}


 {:fthere}
 {comp %fpath,%home}
 {ifco quit}
 {info-q File already exists in M4 directory.}
 {setv thisfile,%oldfile}
 {return}


{:fpath}
{setv fpath,%path}
{instr fpath,%mask}
{setv pos,%_pos}
{subs fpath,1,%pos,%fpath}
{leng %fpath}
{setv len,%_len}
{decr len,2}
{subs fpath,1,%len,%fpath}
{return}

{:blanout}
{instr thisfile, }
{setv pos,%_pos}
{decr pos}
{subs thisfile,1,%pos,%thisfile}
{return}

{:pathdown}
{call blanout}
{call fpath}
{setv path,%fpath%%thisfile%\%mask%}
{call hom}
{return}

{:pathback}
{comp path,%homedisk%\%mask%}
{ifco rit}
{setv holdpath,%path}
{call lastslash}
{decr rpos}
{subs path,1,%rpos,%path}
{call lastslash}
{decr rpos}
{subs path,1,%rpos,%path}
{setv path,%path%\%mask%}
{call hom}
{return}


{:lastslash}
{setv rpos,0}
{setv pos,1}
{leng %path}
{setv plen,%_len}
{setv fpath,%path}
{setv repeat,getsla,%plen%}
{call repeat}
{return}

 {:getsla}
 {setv slapos,%pos}
 {instr fpath,\}
 {setv pos,%_pos}
 {comp pos,0}
 {ifco ret}
 {incr rpos,%pos}
 {incr pos}
 {subs fpath,%pos,200,%fpath}
 {return}

 :del}
 :newmask}
 input mask,Type in new filemask (e.g. *.*)}
 call begin}
 return}


 {:esc}
 {:quit}
 {setv repeat,outaray,%maxfiles}
 {call repeat}
 {setv blanks}
 {setv maxfiles}
 {setv fclr}
 {setv boxdim}
 {setv boxat}
 {setv boxcolor}
 {setv row}
 {setv col}
 {setv bet}
 {setv boxhi}
 {setv boxwid}
 {setv boxbet}
 {setv boxrow}
 {setv boxcol}
 {setv boxwinto}
 {setv boxwinbo}
 {setv boxmiddl}
 {setv timecoun}
 {setv rnestnum}
 {setv repeat}
 {setv cpos}
 {setv sub}
 {setv repetition}
 {setv fwinhi}
 {setv fwinwid}
 {setv fwinmid}
 {setv fwincol}
 {setv fwinrow}
 {setv fcol}
 {setv icol}
 {setv tcol}
 {setv kc}
 {setv ic}
 {setv page}
 {setv firstpas}
 {setv frow}
 {setv mask}
 {setv show}
 {setv store}
 {setv f0}
 {setv s0}
 {setv t0}
 {setv justgot}
 {setv f2get}
 setv thisfile}
 {setv wegot}
 {setv araypos}
 {setv shortlist}
 {setv home}
 {setv len}
 {setv homedisk}
 {setv fc}
 {setv araynum}
 {setv xpos}
 {setv ypos}
 {setv s}
 {setv t}
 {setv blankfil}
 {setv blbord}
 {setv holdpath}
 {setv rpos}
 {setv plen}
 {setv fpath}
 {setv slapos}
 {setv dirchars}
 {setv pathdown}
 {setv f2skip}
 {setv lastpass}
 {setv lastfile}
 {setv early}
 {setv lastpage}
 {setv path}
 {goto %retsub%,%retfile%}

 {:outaray}
 {setv-s s%timecount}
 {setv-s f%timecount}
 {setv-s t%timecount}
 {return}


-----BEGIN PGP SIGNATURE-----
Version: 2.6.2

iQEVAwUBLxGgYx1uLkXXbMBBAQHOOQf+NPU6tAWURvvPzt7n4p4HiRPYud0dQbf6
aCQuWRod0hlprpjiADrYbditqEMDob1RsYpRYnlIoL7pRczQh7P7813CyeVNNIv0
zNJWhwrdrFTAGmTJeS6IwPOvio0Gbv6+SrFyH0pzXBOKhMqf3xXjkHQ3xmasnLLQ
wrorV+0daDoelzU//Ug2xfrkkTZ6xXF/VreKBEfP8CEtBcvI1niy+sBjfTJ19dPO
d95OGqtAfHCmQTp01cC+apUUjvBbvJ30eRYBTQ8P5SuTwqnMvjk++Z0MNmrmquaA
GXZVPtpLsCVwsb2Bg2Jj/+/KB3o2Kd8r7s6Hzeu+ROidj9ILZJOnkg==
=6wVw
-----END PGP SIGNATURE-----
