; ------------------------------------------------------------------------
; File........:	CLPCPU.ASM
; Author......:	Pepijn Smits
; Date........:	December 1994
; Copyright...:	(c)1994 by SPS/Softwarebureau Pepijn Smits
; Assembler...:	Microsoft Assembler (MASM) v5.10
; Notes.......:	CA-Clipper 5.2x Assembly code for CPU()/FPU() Functions.
;		I deserve credits for converting the code into Clipper 
;		callable functions. But NOT for most of the CPU/FPU code!
;
;		The functions to test the CPU and FPU are based on code
;		found in the book: Undocumented PC, by F. van Gilluwe
;		[Addison-Wesley, ISBN 0-201-62277-7]. Therefore, most of
;		the credits go there.. (Excellent book, BTW)
; ------------------------------------------------------------------------
; Syntax in Clipper:
;      
;	CPU()	--> nCPU
;
;	nCPU can be one of
;
;	1	->	8088 or 8086 or 80186 based computer
;	2	->	80286 based computer
;	3	->	i386 based computer
;	4	->	i486 based computer
;	5	->	Pentium based computer
;
;	FPU()	--> nFPU
;
;	0	->	None
;	1	->	8087
;	2	->	80287
;	3	->	80387
;	4	->	80486 with FPU on Chip
;	5	->	Pentium with FPU on Chip
;
; ------------------------------------------------------------------------
PUBLIC		CPU
PUBLIC		FPU
EXTRN		__RETNI:FAR

DGROUP		group CPUDATA
CPUDATA		segment	public 'DATA'

cpu_val		dw	0
fpu_val		dw	-1
fpu_temp	dw	0

CPUDATA		ends
CPUCODE		segment 'CODE'
ASSUME		cs:CPUCODE,ds:DGROUP,es:DGROUP

CPU		PROC	FAR
		cmp	[cpu_val],0
		jne	cpu_exit
		call	CPUVALUE
		mov	[cpu_val],ax
cpu_exit:	mov	ax,[cpu_val]
		push	ax
		call	__RETNI
		pop	ax
		ret
CPU		ENDP

FPU		PROC	FAR
		cmp	[cpu_val],0
		jne	cpu_okay
		call	CPUVALUE
		mov	[cpu_val],ax
cpu_okay:	cmp	[fpu_val],-1
		jne	fpu_exit
		call	FPUVALUE
		mov	[fpu_val],ax
fpu_exit:	mov	ax,[fpu_val]
		push	ax
		call	__RETNI
		pop	ax
		ret
FPU		ENDP

old_int6_seg dw 0                  ; temp storage for old int 6
old_int6_off dw 0                  ;  vector (bad opcode)
old_intD_seg dw 0                  ; temp storage for old int D
old_intD_off dw 0                  ;  vector (protection fault)
badoff       dw 0                  ; temp return offset if bad offset
                                   ;  interrupt 6 called

.8086   ; all instructions 8088/8086 unless overridden later

cpuvalue proc    near
        push    cx
        push    dx
        push    ds
        push    es

; 8088/8086 test - Use rotate quirk - All later CPUs mask the CL
;   register with 0Fh, when shifting a byte by cl bits.  This 
;   test loads CL with a large value (20h) and shifts the AX
;   register right.  With the 8088, any bits in AX are shifted 
;   out, and becomes 0.  On all higher level processors, the
;   CL value of 20h is anded with 0Fh, before the shift.  This
;   means the effective number of shifts is 0, so AX is 
;   unaffected.

        mov     cl, 20h            ; load high CL value
        mov     ax, 1              ; load a non-zero value in AX
        shr     ax, cl             ; do the shift
        cmp     ax, 0              ; if zero, then 8088/86
        jne     up186              ; jump if not 8088/86

; V20/V30 test - It is now either a V20/V30 or a 8088.  I'll use
;   another undocumented trick to find out which.  On the 8088,
;   0Fh performs a POP CS.  On the V20/V30, it is the start of
;   a number of multi-byte instructions.  With the byte string
;   0Fh, 14h, C3h the CPU will perform the following:
;               8088/8086               V20/V30
;             pop     cs              set1   bl, cl  
;             adc     al, 0C3h

        xor     al, al             ; clear al and carry flag
        push    cs
        db      0Fh, 14h, 0C3h     ; instructions (see above)
        cmp     al, 0C3h           ; if al is C3h then 8088/8086
        jne     upV20
        mov     ax, 1              ; set 8088/8086 flag, ie 1!
        jmp     uP_Exit

upV20:
        pop     ax                 ; correct for lack of pop cs
        mov     ax, 1              ; set V20/V30 flag, ie 1!
        jmp     uP_Exit

; 80186/80188 test - Check what is pushed onto the stack with a 
;   PUSH SP instruction.  The 80186 updates the stack pointer 
;   before the value of SP is pushed onto the stack.  With all
;   higher level processors, the current value of SP is pushed
;   onto the stack, and then the stack pointer is updated.
        
up186:  
        mov     bx, sp             ; save the current stack ptr
        push    sp                 ; do test
        pop     ax                 ; get the pushed value
        cmp     ax, bx             ; did SP change ?
        je      up286              ; if not, it's a 286+ 
        mov     ax, 1              ; set 80186 flag, also 1!
        jmp     uP_Exit

; 80286 test A - We'll look at the top four bits of the EFLAGS 
;   register.  On a 286, these bits are always zero.  Later 
;   CPUs allow these bits to be changed.  During this test, 
;   We'll disable interrupts to ensure interrupts do not change 
;   the flags. 

up286: 
        cli                        ; disable interrupts
        pushf                      ; save the current flags

        pushf                      ; push flags onto stack 
        pop     ax                 ; now pop flags from stack
        or      ax, 0F000h         ; try and set bits 12-15 hi
        push    ax
        popf                       ; set new flags
        pushf
        pop     ax                 ; see if upper bits are 0

        popf                       ; restore flags to original
        sti                        ; enable interrupts
        test    ax, 0F000h         ; were any upper bits 1 ?
        jnz     up386              ; if so, not a 286

; 80286 test B - If the system was in V86 mode, (386 or higher) 
;   the POPF instruction causes a protection fault, and the 
;   protected mode software must emulate the action of POPF. If 
;   the protected mode software screws up, as occurs with a 
;   rarely encountered bug in Windows 3.1 enhanced mode, the 
;   prior test may look like a 286, but it's really a higher 
;   level processor. We'll check if the protected mode bit is 
;   on.  If not, it's guaranteed to be a 286.

.286P                              ; allow a 286 instruction
        smsw    ax                 ; get machine status word
        test    ax, 1              ; in protected mode ?
        jz      is286              ; jump if not (must be 286)

; 80286 test C - It's very likely a 386 or greater, but it is 
;   not guaranteed yet.  There is a small possibility the system 
;   could be in 286 protected mode so we'll do one last test. We 
;   will try out a 386 unique instruction, after vectoring the 
;   bad-opcode interrupt vector (int 6) to ourselves.  

        call    hook_int6          ; do it!
        mov     [badoff], offset upbad_op  ; where to go if bad
.386
        xchg    eax, eax           ; 32 bit nop (bad on 286)
        
        call    restore_int6       ; restore vector
        jmp     up386              ; only gets here if 386 
                                   ;  or greater!

; Interrupt vector 6 (bad opcode) comes here if system is a 
;   80286 (assuming the 286 protected mode interrupt 6 handler 
;   will execute the bad-opcode interrupt). 

upbad_op:
        call    restore_int6
is286:
        mov     ax, 2              ; set 80286 flag
        jmp     uP_Exit

; 80386 test - Bit 18 in EFLAGS is not settable on a 386, but is
;   changeable on the 486 and later CPUs.  Bit 18 is used to 
;   flag alignment faults. During this test, we'll disable 
;   interrupts to ensure no interrupt will change any flags.

.386                               ; allow 386 instructions

up386:
        cli                        ; disable interrupts
        pushfd                     ; push flags to look at
        pop     eax                ; get eflags
        mov     ebx, eax           ; save for later
        xor     eax, 40000h        ; toggle bit 18
        push    eax                                    
        popfd                      ; load modified eflags to CPU
        pushfd                     ; push eflags to look at
        pop     eax                ; get current eflags
        push    ebx                ; push original onto stack
        popfd                      ; restore original flags
        sti                        ; enable interrupts
        xor     eax, ebx           ; check if bit changed 
        jnz     up486              ; changed, so 486 or later
        mov     ax, 3              ; set 80386 flag
        jmp     uP_Exit

; 80486 test - Bit 21 in EFLAGS is not settable on a 486, but is
;   changeable on the Pentium CPU.  If bit 21 is changeable, it 
;   indicates the CPU supports the CPUID instruction.  It's 
;   amazing it's only taken 10 years to implement the CPUID 
;   instruction, which should have been included from the start!  
;   During this test, we'll disable interrupts to ensure no 
;   interrupt will change any flags. 

up486:
        cli                        ; disable interrupts
        pushfd                     ; push flags to look at
        pop     eax                ; get eflags
        mov     ebx, eax           ; save for later
        xor     eax, 200000h       ; toggle bit 21
        push    eax                                    
        popfd                      ; load modified eflags to CPU
        pushfd                     ; push eflags to look at
        pop     eax                ; get current eflags
        push    ebx                ; push original onto stack
        popfd                      ; restore original flags
        sti                        ; enable interrupts
        xor     eax, ebx           ; check if bit changed 
        jnz     upPentium          ; changed, it's a Pentium
        mov     ax, 4              ; set 80486 flag
        jmp     uP_Exit

; Pentium - It's possible the CPUID instruction may appear on 
;   other CPU chips, so run the CPUID instruction to see what 
;   CPU type it indicates.  The CPUID returns a family number 
;   0 to 5 for the processor type.  As of this date, only the 
;   Pentium supports the CPUID instruction and it is assigned 
;   type 5.

CPUID   macro                      ; get the CPUID information
        db      0Fh, 0A2h          ;  into eax, ebx, ecx, edx
        endm

upPentium:
        push    ecx                ; CPUID changes eax to edx
        push    edx
        mov     eax, 1             ; get family info function
        CPUID                      ; macro for CPUID instruction
        and     eax, 0F00h         ; find family info
        shr     eax, 8             ; move to al
        pop     edx
        pop     ecx
       
up_Exit:
        pop     es
        pop     ds
        pop     dx
        pop     cx
        ret
cpuvalue endp

.386
.387                               ; allow math instructions

fpuvalue proc    near
        fninit                     ; initialize FPU (reset)
        mov     [fpu_temp], 1234h  ; set any non zero value
        fnstsw  [fpu_temp]         ; get status word from FPU
        and     [fpu_temp], 0FFh   ; only look at bottom 8 bits
        jnz     fput_not_found     ; if non-zero, no FPU
        fnstcw  [fpu_temp]         ; get control word from FPU
        and     [fpu_temp], 103Fh  ; strip unneeded bits
        cmp     [fpu_temp], 3Fh    ; are the proper bits set ?
        je      fput_present       ; jump if so, FPU present

fput_not_found:
        mov     ax, 0              ; FPU not present
        jmp     fput_Exit 

; FPU was found, so see which type, 8087, 80287, or 80387

fput_present:
        mov     ax, 1              ; assume 8087
        cmp     [cpu_val], 2       ; CPU below 286 ?
        jb      fput_Exit          ; if so, must be 8087
        mov     ax, 2              ; assume 80287
        je      fput_Exit          ; if 80286, then FPU is 80287
        mov     ax, [cpu_val]      ; get cpu, 80386 or higher
        cmp     al, 3              ; 80386 ?
        jne     fput_Exit          ; jump if 486 or higher

; 80386 could have a 80287 or 80387 FPU.  To find out, check if
;   -infinity is equal to +infinity.  If not, it's an 80387.

        fld1                       ; push +1 onto stack
        fldz                       ; push +0 onto the stack
        fdiv                       ; 1/0 = infinity
        fld     st                 ; load +infinity onto stack
        fchs                       ; now -infinity on stack
        fcompp                     ; compare + and - infinity
        fstsw   [fpu_temp]         ; status of compare in temp
        test    [fpu_temp], 4000h  ; equal ? (test zero bit)
        jnz     fput_Exit          ; jump if not (387, al= 3)
        mov     al, 2              ; +/- infinity equal, 80287
fput_Exit:
        ret
fpuvalue endp
.8086

;
;    HOOK INTERRUPT 6
;       Save the old interrupt 6 vector and replace it with  
;       a new vector to the bad_op_handler.  Vectors are handled 
;       directly without using DOS.
;
;       Called with:    nothing
;                      
;       Returns:        vector hooked
;                       old vector stored at
;                         ds:[old_int6_seg]
;                         ds:[old_int6_off]
;
;       Regs used:      none

hook_int6 proc    near
        push    ax
        push    cx
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     ax, es:[6*4]       ; get offset of int 6
        mov     cx, es:[6*4+2]     ; get segment
        mov     es:[6*4], offset bad_op_handler
        mov     word ptr es:[6*4+2], seg bad_op_handler
        sti                        ; enable interrupts
        mov     [old_int6_seg], cx ; save original vector
        mov     [old_int6_off], ax
        pop     es
        pop     cx
        pop     ax
        ret
hook_int6 endp


;
;    RESTORE INTERRUPT 6
;       Restore the previously saved old interrupt 6 vector.
;       Vectors handled directly without using DOS.
;
;       Called with:    old vector stored at
;                         ds:[old_int6_seg]
;                         ds:[old_int6_off]
;                      
;       Returns:        vector restored
;
;       Regs used:      none

restore_int6 proc    near
        push    ax
        push    cx
        push    dx
        mov     cx, [old_int6_seg] ; get original vector
        mov     dx, [old_int6_off]
        push    es
        xor     ax, ax
        mov     es, ax
        cli                        ; disable interrupts
        mov     es:[6*4], dx       ; restore original int 6
        mov     es:[6*4+2], cx
        sti                        ; enable interrupts
        pop     es
        pop     dx
        pop     cx
        pop     ax
        ret
restore_int6 endp


;
;    BAD OFFSET INTERRUPT HANDLER
;       If a bad opcode occurs (80286 or later) will come here.
;       The saved BADOFF offset is used to goto the routine
;       previously stored in BADOFF.
;
;       In a few cases, it is also used for double faults. A few
;       instructions (RDMSR & WRMSR) can issue a double fault if
;       not supported, so well come here as well.
;
;       Called with:    cs:[badoff] previously set
;
;       Returns:        returns to address stored in badoff

bad_op_handler proc far
        push    ax
        push    bp
        mov     ax, cs:[badoff]
        mov     bp, sp
        mov     ss:[bp+4], ax      ; insert new return offset
        pop     bp
        pop     ax
        iret
bad_op_handler endp


CPUCODE		ENDS
		END
