#include "memsize.h"
:userdoc.
:title.'System Resources' Help
:body.

:h1 res=ID_MAIN.Introduction
:i1.Introduction
:artwork name='memsize.bmp' align=center.
:p.
This program displays several items related to system resources,
and updates the display once per second, providing it is given
CPU time to do so.  The items displayed are:
:p.
:hp2.Date/Time:ehp2. - The current date and time, in the format called for
in the default country information for your system, as specified in
the COUNTRY= entry of your CONFIG.SYS file.
:p.
:hp2.Elapsed Time:ehp2. - The elapsed time since the computer
was last restarted.
:p.
:hp2.Physical Memory Free:ehp2. - The amount of system memory
available, according to the :hp1.DosMemAvail:ehp1. function.
Under OS/2 2.0, the true amount of unused physical memory is reported,
or 512K, whichever is larger.
:note.If the utility program OS20MEMU and its device driver are
installed, this number will be correct, at the cost of a higher
CPU load.
:p.
:hp2.Virtual Memory Free:ehp2. - The amount of virtual memory
available, according to the :hp1.DosQuerySysInfo:ehp1. function.
This is the amount of free physical memory, plus the amount of
free space within the current swapping file, plus the amount of
space by which the swapping file could yet grow, less the amount
of free space reserved on the swapping drive.
:p.
:hp2.Swap File Size:ehp2. - The current size of the system
virtual memory swap file, SWAPPER.DAT.
To locate the file, the file CONFIG.SYS is scanned for its SWAPPATH entry.
That entry provides the full name of the swap-file's directory and
indicates the minimum free space that must be left on the swap-file's
disk drive.
:p.
:hp2.Available Swap Space:ehp2. - The amount of free disk space on the
logical disk drive where the system swap file resides, less the mininum
free space.  This is how much more the swap file could expand, if necessary.
:p.
:hp2.Spool File Size:ehp2. - The amount of disk space consumed by spool files.
:p.
:hp2.CPU Load (%):ehp2. - The approximate percentage of the CPU's available
horsepower that's being used at the moment.  It is averaged over the previous
second.
:note.This function and PULSE do not get along with each other.
:note.If you have the driver HRTIMER.SYS installed, this number
will be more accurate.
:p.
:hp2.Active Task Count:ehp2. - The number of entries in the system switch list,
which is the list displayed when you press CTRL+ESC.
:note.Not all entries in the system switch list are displayed in the
Window List.  Some are marked for non-display.
:p.
:hp2.Total Free Disk Space:ehp2. - The amount of free space on all the
local non-removable disks combined.
:p.
:hp2.Drive X Free:ehp2. - The amount of free space on drive X.
:p.
The help facility is active, as you've already seen, and those program
commands that exist may be accessed via the window's system menu.  The
following commands are available:
:sl compact.
:li.:hpt.Save Defaults:ehpt.:hdref res=IDM_SAVE_APPLICATION.
:li.:hpt.Reset Defaults:ehpt.:hdref res=IDM_RESET_DEFAULTS.
:li.:hpt.Hide Controls:ehpt.:hdref res=IDM_HIDE_CONTROLS.
:li.:hpt.Configure...:ehpt.:hdref res=IDM_CONFIGURE.
:li.:hpt.About:ehpt.:hdref res=IDM_ABOUT.
:esl.:p.
In addition to those features already described, this program accepts
commands from the OS/2 2.0 Font and Color Palette programs.

:h1 res=IDM_SAVE_APPLICATION.Save Defaults (Menu Option)
:i1.Save Defaults (Menu Option)
When you select this menu option, the program saves its current position
and the status of the Hide Controls option.  The next time the program
is started, it will be started with that position and with the controls
hidden (or not) according to the saved state.
:p.
The short-cut key for this command is F2.

:h1 res=IDM_RESET_DEFAULTS.Reset Defaults (Menu Option)
:i1.Reset Defaults (Menu Option)
Selecting this menu option will reset the program's font and color
attributes to their default values.

:h1 res=IDM_HIDE_CONTROLS.Hide Controls (Menu Option)
:i1.Hide Controls (Menu Option)
This menu option, when selected, will cause the program's frame controls
(the system menu, the titlebar and the minimize button) to be hidden.
This option can be toggled with a double-click on either mouse button.
Also, since I saw it as very useful to be able to move the window while
the controls were hidden, the window has been set up so that you can
drag it with either mouse button.
:p.
The key combination Alt+H will perform this function also.

:h1 res=IDM_CONFIGURE.Configure (Menu Option)
:i1.Configure (Menu Option)
This menu option, when selected, will cause the program's configuration
dialog to be displayed.
:note.The short-cut key to this option is Alt+C.

:h1 res=IDD_CONFIGURE.Configure (Dialog)
:i1.Configure (Dialog)
This dialog allows you to change all configurable aspects of this
program's operation.  To escape without effecting any changes, press
the ESCAPE key or click on the Escape pushbutton.
To save the changes you've made, press the ENTER key
or click on the OK pushbutton.
.br
The configurable items include the following:
:p.
:hp2.Display Items:ehp2.
You may select any or all of the items in the Display Items list for monitoring
and display.  Simply click on an item to highlight it, click again to remove
the highlight.  Highlighted items are monitored.
:p.
:hp2.Hide Controls:ehp2.
When the clock is not iconized, it can be show with or without the usual
title bar, system menu and minimize/maximize buttons.  If you chose to
hide these controls, the window may still be positioned by dragging its 
center area.
:p.
:hp2.Float to Top:ehp2.
This button activates an window's float-to-top function.
When this button has been check-marked, the clock will float to the top
of the window stack, making itself visible all the time.
:p.
:hp2.Animate:ehp2.
This button activates the window open &amp. close animation feature.
When this is active, the program window will open and close in the
same way as the folder objects do: with sound and motion.
As with folders, animation will not occur unless it has been
enabled at the system level.
:p.
:hp2.Show File System Names:ehp2.
This button causes the individual drive free space entries to show the type
of file system in use with the drive.  Use of this option results in
a wider monitor window.
:p.
:hp2.Show Disk Labels:ehp2.
This button causes the individual drive free space entries to show their
disk labels.  Use of this option results in a wider monitor window.
:p.
:hp2.Monitor Priority:ehp2.
This control allows you to set the absolute priority of the monitoring
thread of the program, within the time-critical priority class.
You may vary the priority from 0 to 31.  Priority 31 is the highest
possible priority in the system, short of physical interrupts.
Priority 0 is simply the lowest priority within the time-critical class.
Normally, you should set this to the maximum for more accuracy in
system monitoring.  However, some have complained that their communications
programs occasionally miss data while this program is running.  For that
reason the priority is now variable.
:p.
:hp2.Timer Interval:ehp2.
This control allows you to set the interval between monitor window
updates.  It can be varied from 1.0 seconds to 30.0 seconds, in
steps of 1/10 second.  The number displayed is in tenths of a second.

:h1 res=IDM_ABOUT.About (Menu Option)
:i1.About (Menu Option)
This menu option, when selected, will cause the program's About dialog
to be displayed.

:h1 res=IDD_ABOUT.About (Dialog)
:i1.About (Dialog)
This dialog box displays the program name, icon and copyright information.
To exit the dialog, press the ENTER key, the SPACE bar or the ESCAPE key,
or click on the OK button with the mouse.

:h1 res=IDM_KEYS_HELP.Keys Help
:i1.Keys Help
The following function keys have been defined for this program:
:sl compact.
:li.F1 - Help
:li.F2 - Save Defaults
:li.F3 - Exit
:li.Alt+C - Configure
:li.Alt+H - Hide Controls
:esl.:p.

:h1 res=IDD_PROFILE_PATH.Set Profile Path (Dialog)
:i1.Set Profile Path (Dialog)
This dialog is displayed when the program cannot find its profile (INI) file,
and asks you where the file is or where it is to be created.
:p.
Only a valid existing directory name will be accepted.
Once you have entered the name, press the ENTER key or click on the OK
button for the program to continue.
:p.
If you wish to abort the program's initialization sequence, press
the ESC key or click on the escape button.

:euserdoc.




