100 REM Julian/Gregorian Date Conversions for IBM Basic
110 REM Written by Richard L Tremmel, February 19, 1984

112 REM Subtle Modification by Robert Lund, January 23, 1995
114 REM will allow code to run in GWBASIC or QBASIC or QUICK BASIC

120 '
130 '
140 REM **********************************************************************
150 REM ***       Gregorian Date to Julian Date Conversion Function        ***
160 REM **********************************************************************
170 REM Requires: JC() - Julian date conversion array
180 REM Inputs:   M    - integer Month (1-12)
190 REM           D    - integer Day   (1-31)
200 REM           Y    - integer Year  (0-99)
210 REM Outputs:  FNJ  - integer Julian date (Based on 01/01/1900)

212 DIM JC(12): FOR I = 1 TO 12: READ JC(I): NEXT I  'initialize JC()
214 DATA 0,31,59,90,120,151,181,212,243,273,304,334

220 DEF FNJ (M, D, Y) = INT(Y * 365.25 + D + JC(M) + M * .01 - .03)

230 REM **********************************************************************
240 '
250 '
260 REM Julian/Gregorian Date Conversion - Demo Program
270 REM The following array is used by both the Gregorian-to-Julian function
280 REM (FNJ) and the Julian-to-Gregorian conversion subroutine, and it must
290 REM be initialized before either are used.

320 '
330 REM Start of Demo Program
340 CLS : KEY OFF: DIM JW$(7): FOR I = 1 TO 7: READ JW$(I): NEXT I
350 DATA Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday
360 M = INT(RND(1) * 12) + 1: D = INT(RND(1) * 28) + 1: Y = INT(RND(1) * 85) + 1
370                PRINT USING "##/##/##"; M; D; Y;
380 J = FNJ(M, D, Y): PRINT USING " = #####"; J;
390 GOSUB 9000: PRINT USING " = ##/##/## = Day ###"; JM; JD; JY; JJ;
400                PRINT " ("; JW$(JW); ")"
410 IF M = JM AND D = JD AND Y = JY THEN 360
420 PRINT CHR$(7); "Conversion Error!": STOP
430 '
440 '
9000 REM *********************************************************************
9010 REM ***      Julian Date to Gregorian Date Conversion Subroutine      ***
9020 REM *********************************************************************
9030 REM Requires: JC() - Julian date conversion array
9040 REM Inputs:   J    - integer Julian date (Based on 01/01/1900)
9050 REM Outputs:  JM   - integer Month (1-12)
9060 REM           JD   - integer Day   (1-31)
9070 REM           JY   - integer Year  (0-99)
9080 REM           JJ   - Julian Day of Year (1-366)
9090 REM           JL   - Leap Year flag (0=no Leap, 1=Leap Year)
9100 REM           JW   - integer Day of Week (Monday=1, Sunday=7)
9110 REM Uses:     JI   - JC() array index
9120 REM *********************************************************************
9130 JW = J - 1 - INT((J - 1) / 7) * 7 + 1                  'day of week
9140 JY = INT(J / 365.25)                                   'calculate year
9150 IF INT(JY / 4) = JY / 4 THEN JL = 1 ELSE JL = 0        'check for leap
9160 JJ = J - INT(JY * 365.25 - .25)                        'remaining days
9170 FOR JI = 1 TO 12                                       'calculate month
9180 IF JI < 3 THEN IF JC(JI) < JJ THEN JM = JI             'jan-feb months
9190 IF JI >= 3 THEN IF JC(JI) + JL < JJ THEN JM = JI       'mar-dec months
9200 NEXT JI: IF JM < 3 THEN JD = JJ - JC(JM) ELSE JD = JJ - JC(JM) - JL'calculate days
9210 RETURN

