100 REM Julian/Gregorian Date Conversions for IBM Basic
110 REM Originaly written by Richard L Tremmel, February 19, 1984

120 REM Modified by Robert Lund, January 23, 1995 for QBasic & Quick Basic.
130 REM Modified for dates beyond 1999

140 REM **********************************************************************
150 REM ***       Gregorian Date to Julian Date Conversion Function        ***
160 REM **********************************************************************
170 REM Requires: JC() - Julian date conversion array
180 REM Inputs:   M    - integer Month (1-12)
190 REM           D    - integer Day   (1-31)
200 REM           Y    - integer Year  (0-99) changed to (1900 - ????)
210 REM Outputs:  FNJ  - integer Julian date (Based on 01/01/1900)

220 REM Julian/Gregorian Date Conversion - Demo Program

230 REM The following array is used by both the Gregorian-to-Julian function
240 REM and the Julian-to-Gregorian conversion subroutine, and it must be
250 REM initialized before either are used.

260 DIM JC(12): FOR I = 1 TO 12: READ JC(I): NEXT I  'initialize JC()
270 DATA 0,31,59,90,120,151,181,212,243,273,304,334

280 REM The following array is not necessary to the function of the routines
290 REM but is a "value added" feature.

300 DIM JW$(7): FOR I = 1 TO 7: READ JW$(I): NEXT I
310 DATA MONDAY,TUESDAY,WEDNESDAY,THURSDAY,FRIDAY,SATURDAY,SUNDAY

320 REM **********************************************************************
330 REM Start of Demo Program

340 CLS
350 PRINT "* * * GREGORIAN > JULIAN > GREGORIAN DEMO PROGRAM * * *": PRINT
360 PRINT "  DOS Date of "; DATE$; " Converted to Julian and Back": PRINT
370 M = VAL(LEFT$(DATE$, 2))         ' M = current month
380 D = VAL(MID$(DATE$, 4, 2))       ' D = current day
390 Y = VAL(RIGHT$(DATE$, 4))        ' Y = current year
400 PRINT "       ";
410 PRINT USING "##/##/####"; M; D; Y;
420 J = INT((Y - 1900) * 365.25 + D + JC(M) + M * .01 - .03)
430 PRINT USING " = ########"; J;
440 GOSUB 9000
450 PRINT USING " = ##/##/#### "; JM; JD; JY;
460 PRINT JW$(JW)
470 IF M = JM AND D = JD AND Y = JY THEN END
480 PRINT SPACE$(98); : PRINT CHR$(7); "Conversion Error!"
490 END

9000 REM
9010 REM *********************************************************************
9020 REM ***      Julian Date to Gregorian Date Conversion Subroutine      ***
9030 REM *********************************************************************
9040 REM Requires: JC() - Julian date conversion array
9050 REM Inputs:   J    - integer Julian date (Based on 01/01/1900)
9060 REM Outputs:  JM   - integer Month (1-12)
9070 REM           JD   - integer Day   (1-31)
9080 REM           JY   - integer Year  (0-99)
9090 REM           JJ   - Julian Day of Year (1-366)
9100 REM           JL   - Leap Year flag (0=no Leap, 1=Leap Year)
9110 REM           JW   - integer Day of Week (Monday=1, Sunday=7)
9120 REM Uses:     JI   - JC() array index
9130 REM *********************************************************************

9140 JW = J - 1 - INT((J - 1) / 7) * 7 + 1                  'day of week
9150 JY = INT(J / 365.25)                                   'calculate year
9160 IF INT(JY / 4) = JY / 4 THEN JL = 1 ELSE JL = 0        'check for leap
9170 JJ = J - INT(JY * 365.25 - .25)                        'remaining days
9180 JY = JY + 1900
9190 FOR JI = 1 TO 12                                       'calculate month
9200     IF JI < 3 THEN IF JC(JI) < JJ THEN JM = JI         'jan-feb months
9210     IF JI >= 3 THEN IF JC(JI) + JL < JJ THEN JM = JI   'mar-dec months
9220 NEXT JI
9230 IF JM < 3 THEN JD = JJ - JC(JM) ELSE JD = JJ - JC(JM) - JL
9240 RETURN
