'   Ŀ
'     Julian/Gregorian Date Conversions                                    
'     Originaly written by Richard L Tremmel, February 19, 1984            
'     
'     Modified by Robert Lund, January 23, 1995 for QBasic & Quick Basic.  
'     Modified for dates beyond 1999, Rewritten using Function calls.      
'   

DECLARE FUNCTION JUL& (X$)
DECLARE FUNCTION GREG$ (X&)

COMMON SHARED JW, JJ, JM

DIM SHARED JC(12): FOR I = 1 TO 12: READ JC(I): NEXT I
DATA 0,31,59,90,120,151,181,212,243,273,304,334

DIM SHARED JW$(7): FOR I = 1 TO 7: READ JW$(I): NEXT I
DATA Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday

DIM SHARED JM$(12): FOR I = 1 TO 12: READ JM$(I): NEXT I
DATA January,February,March,April,May,June
DATA July,August,September,October,November,December

CLS : COLOR 2
PRINT "* * * GREGORIAN > JULIAN > GREGORIAN DEMO PROGRAM * * *": PRINT
PRINT "  DOS Date of "; DATE$; " Converted to Julian and Back": PRINT

PRINT TAB(11); DATE$; "  > ";
PRINT JUL&(DATE$); " >  ";
PRINT GREG$(JUL&(DATE$))
PRINT : PRINT TAB(14); "Day of the week ..... "; JW$(JW)
PRINT : PRINT TAB(14); "Day of the Year ....."; JJ
PRINT : PRINT TAB(14); "Month of the Year ... "; JM$(JM)

END

FUNCTION GREG$ (J&) STATIC

JW = J& - 1 - INT((J& - 1) / 7) * 7 + 1                 'day of week

JY = INT(J& / 365.25)                                   'calculate year
IF INT(JY / 4) = JY / 4 THEN JL = 1 ELSE JL = 0         'check for leap
JJ = J& - INT(JY * 365.25 - .25)                        'day of the year
JY = JY + 1900

FOR JI = 1 TO 12                                        'calculate month
    IF JI < 3 THEN IF JC(JI) < JJ THEN JM = JI          'jan-feb months
    IF JI >= 3 THEN IF JC(JI) + JL < JJ THEN JM = JI    'mar-dec months
NEXT JI

IF JM < 3 THEN                                          'calculate days
   JD = JJ - JC(JM)
   ELSE
   JD = JJ - JC(JM) - JL
END IF
                                                        'convert to string
JM$ = LTRIM$(STR$(JM)): IF LEN(JM$) = 1 THEN JM$ = "0" + JM$
JD$ = LTRIM$(STR$(JD)): IF LEN(JD$) = 1 THEN JD$ = "0" + JD$
JY$ = LTRIM$(STR$(JY)): GREG$ = JM$ + "-" + JD$ + "-" + JY$

END FUNCTION

FUNCTION JUL& (X$) STATIC

M = VAL(LEFT$(X$, 2))         ' M = current month
D = VAL(MID$(X$, 4, 2))       ' D = current day
Y = VAL(RIGHT$(X$, 4))        ' Y = current year

J = INT((Y - 1900) * 365.25 + D + JC(M) + M * .01 - .03)
JUL& = J

END FUNCTION

