;//////////////////////////////////////////////////////////////////////////////
;// MasterList Manager v2.00 Configuration File                              //
;// Copyright (c) 1994-95, Chris Frankforther - All Rights Reserved          //
;//////////////////////////////////////////////////////////////////////////////
;
;===[ Output Files ]===========================================================
;
; If any of the following output files are commented out, they will not created
;
; Directive     Description
; -----------   ---------------------------------------------------------------
; AscList       Path and name of the ASCII master file listing
; AnsList       Path and name of the ANSI master file listing
; AscInx        Path and name of Type 20 compatible ASCII .INX file
; AnsInx        Path and name of Type 20 compatible ANSI .INX file
; GlobalDir     Path and name of Type 46 compatible global .DIR file
; MissingFile   Path and name of missing file report

AscList         C:\MLIST\FILES.TXT
AnsList         C:\MLIST\FILES.ANS
AscInx          C:\MLIST\ASCFILES.INX
AnsInx          C:\MLIST\ANSFILES.INX
GlobalDir       C:\MLIST\GLOBAL.DIR
MissingFile     C:\MLIST\MISSING.TXT

;===[ Switches ]===============================================================
;
; Directive         Description
; ----------------- ---------------------------------------------------------------
; FullScreen        Turns fullscreen mode on.
; Debug             Turns debug mode on.  Useful for tracing problems.
; OmitStamp         Omits the time and date stamp added to the master listings.
; IncludeMissing    Includes "missing" files in the master listings.
; GlobalAddSizeDate Adds the size and date of files in the global .DIR file
; OmitDate          Omits file dates from the master listings.
; AlternateDate     Place file dates BEFORE the description instead of after.
; OmitAreaSize      Omits individual area size totals from the master listings.
; OmitTotalSize     Omits the total size from the master listings.
; NoSpinner         Disables the "working" spinner.

FullScreen
; Debug
OmitStamp
IncludeMissing
; GlobalAddSizeDate
; OmitDate
AlternateDate
; OmitAreaSize
; OmitTotalSize
; NoSpinner

;===[ Miscellaneous ]==========================================================
;
; Directive      Description
; -----------    --------------------------------------------------------------
; AscHeader      Path and name of the ASCII header for ASCII master listing
; AnsHeader      Path and name of the ANSI header for ANSI master listing
; Description    Default description given to files which have none
; SizeinBytes    Master files will display file sizes in bytes (default)
; SizeinK        Master files will display file sizes in Kbytes
; SizeINXinBytes INX files will display file sizes in bytes (default)
; SizeINXinK     INX files will display file sizes in Kbytes

AscHead         C:\MLIST\TBBSCMT.ASC
AnsHead         C:\MLIST\TBBSCMT.ANS
Description     No Description Available
; SizeinK
SizeinBytes
; SizeINXinK
SizeINXinBytes

;===[ Network Support ]========================================================
;
; This option allows network users to remap a drive to a different drive.  Note
; that this command only remaps drive paths that are found in the .DIR and .FAR
; files.  The format for this command is: Remap <OldDrive> <NewDrive>

; Remap C: E:
; Remap D: F:
; Remap E: G:
; Remap F: H:
; Remap G: I:

;===[ Colors ]=================================================================
;
; This is where you specify the colors for the output ANSI files.
;
; LineColor = Any lines or brackets used to seperate information
; AreaColor = Areaname color
; FileColor = Filename color
; SizeColor = Filesize color
; DateColor = Filedate color
; DescColor = Description color
;
; Valid Colors: 0 - Black  4 - Red       8 - Gray          12 - Bright Red
;               1 - Blue   5 - Magenta   9 - Bright Blue   13 - Bright Magenta
;               2 - Green  6 - Brown    10 - Bright Green  14 - Yellow
;               3 - Cyan   7 - White    11 - Bright Cyan   15 - Bright White

LineColor 12
AreaColor 13
FileColor 11
SizeColor 10
DateColor 8
DescColor 9

;===[ File Areas ]=============================================================
;
; The following is where you set up your file areas to be listed.
;
; Format is: Area <AreaTag> <Path> <FullArea>
;
; AREATAG  = A 1-10 character long tag signifying the specific file area.  If
;            this is a tag for a .FAR, the area number will be appended to
;            this tag, and if the supplied tag plus the area number exceeds
;            10 characters, the supplied tag will be truncated enough to fit
;            the area number inside the 10 characters.  It is recommended that
;            you only supply up to 8 characters when this is a FAR tag.
; PATH     = This must be the full path *AND* name of either a .DIR or .FAR
;            file.  FAR mode processing is turned on if the string ".FAR"
;            exists in this field.
; FULLAREA = This is the full area name, used for the master file listings.
;            If this is for a .FAR file, this parameter will precede each
;            area description contained within the .FAR file.

; This DEMO version only supports 20 areas. The FULL version supports virtually
; UNLIMITED areas!

Area DOS-       C:\FILES\DOS.FAR        DOS
Area WIN-       C:\FILES\WIN.FAR        Windows
Area MAC-       C:\FILES\MAC.FAR        Macintosh
Area UNIX-      C:\FILES\UNIX.FAR       Unix
Area FB-        C:\FILES\FILEBONE.FAR   Filebone

Area INTERNET   C:\FILES\INTERNET.DIR   Internet Files
Area GIFS       C:\FILES\GIFS.DIR       GIF Pictures
Area HAMRADIO   C:\FILES\HAMRADIO.DIR   Ham Radio Files
