{$I-} {disable I/O checking - trap errors by checking IOResult}
PROGRAM XErase;
USES DOS;

{SWAG routine (anonymous):  Read a key-press }
FUNCTION ReadKey : {output} CHAR; ASSEMBLER;
ASM
  mov AH, 00h
  Int 16h
END; { ReadKey }

FUNCTION isDir (CONST FileMask : STRING): BOOLEAN;
VAR
  Attr : WORD;
  f    : FILE;
BEGIN
  Assign (f, FileMask);
  GetFAttr (f, Attr);
  IF (DosError = 0) AND ( (Attr AND Directory) = Directory)
    THEN isDir := TRUE
    ELSE isDir := FALSE;
  END;

FUNCTION fileexists (CONST filename: PATHSTR): BOOLEAN;
VAR
  Attr : WORD;
  f    : FILE;
BEGIN
  Assign (f, filename);
  GetFAttr (f, Attr);
  IF (DosError <> 0) OR ( (Attr AND Directory) = Directory)
    THEN fileexists := FALSE
    ELSE fileexists := TRUE;
END;

PROCEDURE EraseFile (CONST CurrentFile : STRING);
VAR
  df : FILE;
BEGIN
  IF fileexists (CurrentFile) THEN BEGIN
    Assign (df, CurrentFile);
    SetFAttr (df, 0);
    WriteLn ('Deleting: [', CurrentFile, ']');
    Erase (df);
    IF IOResult <> 0 THEN BEGIN
      WriteLn ('Unable to delete: [', CurrentFile, ']');
    END;
  END;
END;

FUNCTION LoCase (c : CHAR): CHAR;
BEGIN
  IF c IN ['A'..'Z'] THEN
    Inc (c, 32);
  LoCase := c;
END;

VAR
  AttrMask  : WORD;
  FileMask,
  FName     : PATHSTR;
  FDir      : DIRSTR;
  FNam      : NAMESTR;
  FExt      : EXTSTR;
  DirInfo   : SEARCHREC;
  Response  : CHAR;

BEGIN
  Writeln('XErase v1.00 - Free DOS utility: erase ANY file, with prompting.');
  Writeln('April 8, 1995.  Copyright (c) 1995 by David Daniel Anderson - Reign Ware.');
  Writeln;
  FileMask := STRING (Ptr (PrefixSeg, $0080)^);
  FileMask := Copy (FileMask, 2, Length (FileMask) - 1); {remove leading space}
  AttrMask := $2F;

  IF isDir (FileMask) AND ( (FileMask [Length (FileMask) ] <> '\') ) THEN
    FileMask := FileMask + '\';

  FSplit (FExpand (FileMask), FDir, FNam, FExt);
  IF (FNam = '')
    THEN FileMask := FDir + '*.*'
    ELSE FileMask := FDir + FNam + FExt;
  WriteLn ('You will be prompted for: [', FileMask, ']');
  FindFirst (FileMask, AttrMask, DirInfo);

  WHILE DosError = 0 DO
  BEGIN
    FName := DirInfo. Name;
    Write ('Delete [', FDir + FName, '] (No, yes, quit)? ');
    Response := LoCase (ReadKey);
    WriteLn (Response);
    CASE Response OF
      'y' : erasefile (FDir + FName);
      'q' : Halt (0);
    END;
    FindNext (DirInfo);
  END;
END.
