/* ************************************************************* */
/* demo6.c For QuickC - Demonstrates how to set palettes         */
/*                                                               */
/* Use RM to create palette tables.                              */
/* ************************************************************* */

#include <stdio.h>
#include <dos.h>
#include <graph.h>

void setrgb(int c, int r, int g, int b)
{
  union REGS reg;

  reg.h.ah = 0x10;
  reg.h.al = 0x10;
  reg.x.bx = c;
  reg.h.dh = r;
  reg.h.ch = g;
  reg.h.cl = b;
  int86 (0x10, &reg,&reg);
}

void setnewpalette()
{
 /* C Palette Source, 16 Colors (RGB)  */

 char Pal[48] = {
          0x00,0x00,0x00,0x3F,0x15,0x15,0x3F,0x18,0x18,0x3F,0x1B,0x1B,
          0x3F,0x1E,0x1E,0x3F,0x21,0x21,0x3F,0x24,0x24,0x3F,0x27,0x27,
          0x3F,0x2A,0x2A,0x3F,0x2D,0x2D,0x3F,0x30,0x30,0x3F,0x33,0x33,
          0x3F,0x36,0x36,0x3F,0x39,0x39,0x3F,0x3C,0x3C,0x3F,0x3F,0x3F};

 int i;
 for(i=0;i<16;i++)
 {
  setrgb(i,Pal[i*3],Pal[i*3+1],Pal[i*3+2]);
 }
}

void drawbars()
{
 int i;
 int barwidth,barheight;
 int numcolors=16;

 barwidth=639 / numcolors;
 barheight=199 / 2;

 for(i=0;i<numcolors;i++)
 {
   _setcolor(i);
   _rectangle(_GFILLINTERIOR,i*barwidth,0,i*barwidth+barwidth,barheight);
 }
}

main()
{
  _setvideomode(_HRES16COLOR); /* replace with _MRES256COLOR for 256 color palettes */

  drawbars();
  getch();
  setnewpalette();
  _settextposition(20,40);
  _outtext("NEW PALETTE");
  getch();

  _setvideomode(_DEFAULTMODE);
}


