/* UDP packet tracing
 * Copyright 1991 Phil Karn, KA9Q
 */
/* Mods by PA0GRI */
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "internet.h"
#include "udp.h"
#include "ip.h"
#include "socket.h"
#include "trace.h"
  
void rwho_dump __ARGS((FILE *fp,struct mbuf **bpp));
  
/* Dump a UDP header */
void
udp_dump(fp,bpp,source,dest,check)
FILE *fp;
struct mbuf **bpp;
int32 source,dest;
int check;      /* If 0, bypass checksum verify */
{
    struct udp udp;
    struct pseudo_header ph;
    int16 csum;
  
    if(bpp == NULLBUFP || *bpp == NULLBUF)
        return;
  
#ifdef MONITOR
    if (!Trace_compact_header)
#endif
        fprintf(fp,"UDP:");
  
    /* Compute checksum */
    ph.source = source;
    ph.dest = dest;
    ph.protocol = UDP_PTCL;
    ph.length = len_p(*bpp);
    if((csum = cksum(&ph,*bpp,ph.length)) == 0)
        check = 0;  /* No checksum error */
  
    ntohudp(&udp,bpp);
  
#ifdef MONITOR
    if (!Trace_compact_header)
#endif
        fprintf(fp," len %u %u->%u",udp.length,udp.source,udp.dest);
#ifdef MONITOR
    if (!Trace_compact_header)
#endif
        if(udp.length > UDPHDR)
            fprintf(fp," Data %u",udp.length - UDPHDR);
    if(udp.checksum == 0)
        check = 0;
    if(check)
        fprintf(fp," CHECKSUM ERROR (%u)",csum);
  
    fprintf(fp,"\n");
  
    switch(udp.dest){
#ifdef RIP
        case IPPORT_RIP:
            rip_dump(fp,bpp);
#endif
#ifdef notdef
        case IPPORT_RWHO:
            rwho_dump(fp,bpp);
#endif
    }
  
}
  
