program DU;
uses Dos;

type str80 = string[80];

procedure Instructions;
begin
  writeln('DU -- Disk usage report -- M. Covington 1990');
  writeln;
  writeln('du \');
  writeln('    reports space used by all directories on disk');
  writeln('du \mydir');
  writeln('    reports space used by mydir and its subdirectories');
end;

function SearchDirectory(Path,FileSpec:str80):longint;
  { Searches the directory denoted by Path for files that match  }
  { FileSpec, then does the same for all subdirectories under it }
var  FileInfo: SearchRec;
     Space: longint;
begin
     Space := 0;
  { Look for files that match FileSpec }
     FindFirst(Path+FileSpec,0,FileInfo);
     while DOSerror = 0 do
       begin
         Space := Space + FileInfo.Size;
{         writeln(Path+FileInfo.Name); }
         FindNext(FileInfo)
       end;
  { Look for subdirectories and search them }
     FindFirst(Path+'*.*',Directory,FileInfo);
     while DOSerror = 0 do
       begin
         if ((FileInfo.Attr and Directory) > 0) and
             (FileInfo.Name <> '.') and
             (FileInfo.Name <> '..') then
   Space := Space + SearchDirectory(Path+FileInfo.Name+'\',FileSpec);
         FindNext(FileInfo)
       end;
  { Display and return the total space }
    writeln(Space:25,'  ',Path);
    SearchDirectory := Space
end;

{ Main program }
var
  Dir: Str80;
  discard: longint;
begin
  if ParamCount = 0 then
    Instructions
  else
    begin
      Dir := ParamStr(1);
      if Dir[length(Dir)] <> '\' then Dir := Dir + '\';
      discard := SearchDirectory(Dir,'*.*')
    end
end.
