/* Begin Install.CMD for AdeptXBBS */

'@Echo off'
say '[0m[2J'
say ''
say '[5C[0;1;44mĿ[40m'
say '[5C[44m                [36mAdeptXBBS [37m0.92 [33mInstallation Program                [37m[40m'
say '[5C[44m   AdeptXBBS is copyright (c) 1995 by AdeptSoft & Mark Kimes       [40m'
say '[5C[44m                        All rights reserved                        [40m'
say '[5C[44mĴ[40m'
say '[5C[44mĴ[40m'
say '[5C[44m        By running this program, you agree to the license          [40m'
say '[5C[44m                  as specified in AdpXBBS.DOC.                     [40m'
say '[5C[44m[0m'

rc = stream('adeptins.dat','c','query exists')
if rc = '' then
do
  say 'Sorry, ADEPTINS.DAT not found.  Must not be right directory. Terminating.'
  exit
end

curdir = directory()

do
  say ''
  say 'Current sub-directory: 'curdir
  say 'Install AdeptXBBS into the current'
  say 'sub-directory? (Y/N)'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

say 'Installing AdeptXBBS... Please wait...'
'@AdeptIns.dat /o >NUL'

/* save current directory */

/* load rexx utility functions */

rc = stream('adept.exe','c','query exists')
if rc = '' then
do
  say 'Sorry, ADEPT.EXE not found.  Must not be right directory. Terminating.'
  exit
end

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

say "Creating AdeptSoft folder..."

/* first, create AdeptSoft folder */

title = "AdeptSoft"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<AdeptSoft_Folder>;OPEN=DEFAULT'
result=SysCreateObject(classname,title,location,setup,f)

/* If folder exists, ask before updating */

if result = 0 then
do
  existed = 'TRUE'
  say ''
  say 'The AdeptXBBS folder already exists.'
  say 'Should I update the objects? (Y/N)'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

say "Creating objects in AdeptSoft folder..."

/* now, create program objects in AdeptSoft folder */

title = "AdeptXBBS 1 Node"
classname = 'WPProgram'
location = '<AdeptSoft_Folder>'
setup = 'EXENAME='curdir'\ADEPT.EXE;STARTUPDIR='curdir';PARAMETERS=/NODES 1'
call SysCreateObject classname,title,location,setup,u

title = "AdeptXBBS 2 Nodes"
classname = 'WPProgram'
location = '<AdeptSoft_Folder>'
setup = 'EXENAME='curdir'\ADEPT.EXE;STARTUPDIR='curdir';PARAMETERS=/NODES 2'
call SysCreateObject classname,title,location,setup,u

rc = stream('xsend.cmd','c','query exists')
if rc \= '' then
do
  title = "Send files"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
  setup = 'EXENAME='curdir'\XSEND.CMD;STARTUPDIR='curdir
  if existed = '' then setup = setup';PARAMETERS=%* 'curdir'\\'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('fileedit.exe','c','query exists')
if rc \= '' then
do
  title = "File area editor"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
  setup = 'EXENAME='curdir'\FILEEDIT.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('mail.cmd','c','query exists')
if rc \= '' then
do
  title = "Process mail"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
  setup = 'EXENAME='curdir'\mail.cmd;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('reindexfiles.exe','c','query exists')
if rc \= '' then
do
  title = "Reindex File Database"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
  setup = 'EXENAME='curdir'\ReIndexFiles.EXE;STARTUPDIR='curdir';PARAMETERS=/NUKE'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('reindexusers.exe','c','query exists')
if rc \= '' then
do
  title = "Reindex User File"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
setup = 'EXENAME='curdir'\ReIndexUsers.Exe;STARTUPDIR='curdir
call SysCreateObject classname,title,location,setup,u
end

rc = stream('bfsmake.exe','c','query exists')
if rc \= '' then
do
  title = "Convert file areas"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
  setup = 'EXENAME='curdir'\BFSMAKE.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('xmsg.cmd','c','query exists')
if rc \= '' then
do
  title = "Clean up msg areas"
  classname = 'WPProgram'
  location = '<AdeptSoft_Folder>'
  setup = 'EXENAME='curdir'\CLEAN.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('MUSTREAD.TXT','c','query exists')
if rc \= '' then
do
  title = "Must Read!"
  classname = 'WPShadow'
  location = '<AdeptSoft_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('AdpXBBS.DOC','c','query exists')
if rc \= '' then
do
  title = "AdeptXBBS Documentation!"
  classname = 'WPShadow'
  location = '<AdeptSoft_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('UserMod.Doc','c','query exists')
if rc \= '' then
do
  title = "Batch User Modifier"
  classname = 'WPShadow'
  location = '<AdeptSoft_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('REGISTER.TXT','c','query exists')
if rc \= '' then
do
  title = "How to Register"
  classname = 'WPShadow'
  location = '<AdeptSoft_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

  rc = directory('Menus')
  if rc \= '' then
  do
    call directory curdir
    title = "BBS Menus"
    classname = 'WPShadow'
    location = '<AdeptSoft_Folder>'
    setup = 'SHADOWID='rc
    call SysCreateObject classname,title,location,setup,u
  end

  rc = directory('Text')
  if rc \= '' then
  do
    call directory curdir
    title = "BBS Text"
    classname = 'WPShadow'
    location = '<AdeptXBBS_Folder>'
    setup = 'SHADOWID='rc
    call SysCreateObject classname,title,location,setup,u
  end

  rc = directory('System\SysNews')
  if rc \= '' then
  do
    call directory curdir
    title = "BBS System News"
    classname = 'WPShadow'
    location = '<AdeptSoft_Folder>'
    setup = 'SHADOWID='rc
    call SysCreateObject classname,title,location,setup,u
  end

  rc = directory('System\MiscNews')
  if rc \= '' then
  do
    call directory curdir
    title = "BBS Misc. News"
    classname = 'WPShadow'
    location = '<AdeptSoft_Folder>'
    setup = 'SHADOWID='rc
    call SysCreateObject classname,title,location,setup,u
  end

rc = stream('Adept.HLP','c','query exists')
if rc \= '' then
do
  rc = stream('SEEHELP.EXE','c','query exists')
  if rc \= '' then
  do
    title = "AdeptXBBS Online Help"
    classname = 'WPProgram'
    location = '<AdeptSoft_Folder>'
    setup = 'EXENAME='curdir'\SEEHELP.EXE;'
    setup = setup'STARTDIR='curdir';PARAMETERS=%*'curdir'\ADEPT.HLP'
    call SysCreateObject classname,title,location,setup,f
  end
end

rc = stream('adept.exe','c','query exists')
if rc = '' then
do
  say 'Sorry, ADEPT.EXE not found.  Unarchive does not appear to have '
  say 'been successful.'
  exit
end

do
  say ''
  say 'Install appears to have been sucessful!'
  say ''
  say 'Delete AdeptIns.dat, since we should not'
  say 'need it any longer?'
  parse upper pull dummy
  if left(dummy,1) = 'Y' then
  do
  '@del AdeptIns.dat >NUL'
  end
  say ''
end

do
  say ''
  say 'NOTE: This setup defaults to starting 2 nodes.  Both nodes will be'
  say '      started in  "'"NOINIT"'"  mode.  This is to be sure that it will'
  say '      not interupt anything else that is running.'
  say ''
  say '      You can setup the BBSs options from the Config pull down on'
  say '      the main screen.'
  say ''
  say '      Be sure to click on Shutdown in order to make sure your settings'
  say '      are properly saved.'
  say ''
  say 'Would you like to setup your copy of'
  say 'AdeptXBBS?'
  parse upper pull dummy
  if left(dummy,1) = 'Y' then
  do
      '@Adept.exe /NODES 2 /NOINIT 1 /NOINIT 2'
  end
  say ''
end

say 'Thank you for choosing AdeptSoft!'

/* END Install Program */
