/********************************************************************/
/*                                                                  */
/* Kartenspiele fr OS/2                                            */
/*                                                                  */
/* Deutsche Installation, Version 2.1 (ShareWare)                   */
/*                                                                  */
/* Copyright 1994, 1995 (C) by Felix Maschek, Schneverdingen        */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* REXXUTIL laden */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisieren */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say ' '
Say '+---------------------------------------------------------------+'
Say '+        Kartenspiele fr OS/2,  Version 2.1 (ShareWare)        +'
Say '+    Copyright 1994, 1995 by Felix Maschek, Schneverdingen      +'
Say '+---------------------------------------------------------------+'
Say ' '
Say 'Installation...'
Say ''

/* Nachprfen, ob bestimmte Bestandteile vorhanden sind. */

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: CARDS.EXE nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( "CARDSGER.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: CARDSGER.HLP nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( "CARDSGER.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: CARDSGER.DLL nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( "CARDSENG.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: CARDSENG.HLP nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( "CARDSENG.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: CARDSENG.DLL nicht gefunden!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Bitte geben Sie den vollen Verzeichnisnamen ein, wohin'
Say '  CARDS installiert werden soll (Standard: C:\CARDS): '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* Zielverzeichnis, falls ntig, anlegen. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEHLER: Kann das Zielverzeichnis nicht anlegen.'
    Signal DONE
    End
  End
Say '';


Folder = '<WP_DESKTOP>'

/* Installation durchfhren. */

Say 'Kopiere CARDS nach ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "CARDSGER.HLP" Directory"\CARDSGER.HLP" '1>NUL'
Copy "CARDSGER.DLL" Directory"\CARDSGER.DLL" '1>NUL'
Copy "CARDSENG.HLP" Directory"\CARDSENG.HLP" '1>NUL'
Copy "CARDSENG.DLL" Directory"\CARDSENG.DLL" '1>NUL'

Say 'Erzeuge Programmobjekt...'
Type = 'WPProgram'
Title = 'Kartenspiele'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;PARAMETERS=CARDSGER;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Objekt erzeugt!  Fertig.'
Else             
  Say 'FEHLER: Nicht erzeugt!'

Signal DONE

FAILURE:
Say 'Fehler in der REXX-Ausfhrung.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxfehler.'
Signal DONE

DONE:
Exit
