/********************************************************************/
/*                                                                  */
/* Card Games for OS/2                                              */
/*                                                                  */
/* English Installation, Version 2.1 (ShareWare)                    */
/*                                                                  */
/* Copyright 1994, 1995 (C) by Felix Maschek, Schneverdingen        */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisation */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say ' '
Say '+---------------------------------------------------------------+'
Say '+         Card Games for OS/2,  Version 2.1 (ShareWare)         +'
Say '+    Copyright 1994, 1995 by Felix Maschek, Schneverdingen      +'
Say '+---------------------------------------------------------------+'
Say ' '
Say 'Installation...'
Say ''


/* Check... */

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDS.EXE not found!'
  Signal DONE
  End

Result = SysFileTree( "CARDSENG.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDSENG.HLP not found!'
  Signal DONE
  End

Result = SysFileTree( "CARDSENG.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDSENG.DLL not found!'
  Signal DONE
  End

Result = SysFileTree( "CARDSGER.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDSGER.HLP not found!'
  Signal DONE
  End

Result = SysFileTree( "CARDSGER.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CARDSGER.DLL not found!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Please enter the full target path for CARDS'
Say '  Default: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Can''t create target path.'
    Signal DONE
    End
  End
Say '';

/* Create desktop object */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Copying CARDS to ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "CARDSGER.HLP" Directory"\CARDSGER.HLP" '1>NUL'
Copy "CARDSGER.DLL" Directory"\CARDSGER.DLL" '1>NUL'
Copy "CARDSENG.HLP" Directory"\CARDSENG.HLP" '1>NUL'
Copy "CARDSENG.DLL" Directory"\CARDSENG.DLL" '1>NUL'

Say 'Creating desktop object...'
Type = 'WPProgram'
Title = 'Cardgames'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;PARAMETERS=CARDSENG;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Desktop object was created!  Ready.'
Else             
  Say 'ERROR: Can''t create desktop object!'

Signal DONE

FAILURE:
Say 'Error while processing REXX.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxerror.'
Signal DONE

DONE:
Exit
