 .386P

code32 segment para public use32
       assume cs:code32,ds:code32

include 386power.inc

; COMMAND LINE SCANNER:
; EXECUTE _ArgInit BEFORE ANY FILE I/O
; OR THE DEFAULT DTA (the place where the command line arguments are)
; MAY BE TRASHED!!

; 386arg follows this simple parameter convention:
; Arguments are string made of non-blank (i.e space o tab) characters.
; Arguments with a "-" as the first character are command line switches.
; Arguments without a starting "-" are file names.

; so: 
;      -DEBUG  -F -f -FOOBAR -SELFDESCTRUCT  -SD -P:007:052 -78
; are "options".
; while:   
;      foobar.dat    d:\LonG\PaTh\Name.dat $%^&$$#  !wow!
;      rock'n'roll  *)(&#  +cool /unix/file/name
; are "file names".
; I found that this simple syntax fits most of my needs
; but of course you can enhance.

Params dd offset STOP
LastFN dd offset STOP
LastOP dd offset STOP
STOP   db 0

        public _ArgInit
_ArgInit:
        ; reads the command line parameters and convert it to a list
        ; of ASCIIZ (c strings) terminated by a null string
        ; No parsing is made on strings
        ; ALL blank character are skipped
        pushad
        mov esi,_PSPBase
        movzx ecx,byte ptr gs:[esi+80h] ; how many chars after program name?
        cmp ecx,0 
        je @nopars
        mov edi,_LoMemBase
        add esi,81h
        mov Params,edi  ; set up arglists
        mov LastOP,edi  ;
        mov LastFN,edi  ;
        jmp short skip
zstring:
        mov byte ptr [edi],0
        inc edi
ztest:  
        cmp ecx,0
        je @pend
skip:   mov al,gs:[esi]
        dec ecx
        inc esi
        cmp al,32 ; space ?
        je ztest
        cmp al,08 ; tab ?
        je ztest
stringa:
        stosb
        cmp ecx,0
        je @pend                
        mov al,gs:[esi]
        dec ecx
        inc esi
        cmp al,32 ; space ?
        je zstring
        cmp al,08 ; tab ?
        je zstring
        jmp short stringa
@pend:
        mov word ptr [edi],0
        add edi,2
        mov _LoMemBase,edi
@nopars:
        popad
        ret        

        public _ArgFile
_ArgFile:
        ; reads from the command line a "file name"
        ; and returns it into ESI, if all file names have been read
        ; or if no file name are present it returns a NULL ASCIIZ
        ; ( a pointer to character 0).
        push edi
        push eax
        mov esi,LastFN
   finp:      
        cmp byte ptr [esi],0
        je @ffend
        mov edi,esi ;save pointer
   guut:     
        lodsb     ; get to end of string
        cmp al,0  ;
        jne guut  ;
        mov LastFN,esi 
        cmp byte ptr [edi],45 ; '-' dash ?
        jne @fend
        jmp short finp
   @fend:
        mov esi,edi
   @ffend:     
        pop eax
        pop edi
        ret
        
        public _ArgOpt
_ArgOpt:
        ; reads from the command line an "option"
        ; and returns a pointer to it into ESI, if all options have been read
        ; or if no options are present it returns a NULL ASCIIZ
        ; ( a pointer to character 0).
        ; N.B. the "-" header of the option string is automatically
        ;      discarded
        push edi
        push eax
        mov esi,LastOP
   oinp:      
        cmp byte ptr [esi],0
        je @oend
        mov edi,esi
   guot:     
        lodsb
        cmp al,0
        jne guot
        mov LastOP,esi
        cmp byte ptr [edi],45 ; '-' dash ?
        je doend
        jmp short oinp
   doend:     
        inc edi ; remove the '-' header
        mov esi,edi
   @oend:
        pop eax
        pop edi
        ret

code32 ends        
	   END

