 .386P
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc

; Microsoft mouse interface
;  "real" mouse handler included into 386power
;  together with the "pseudo balistic" keyboard-mouse and joystick-mouse
;  emulators

hole  db 'XID: The selected mouse driver is not present',CR,LF,'$'

none: ; dummy entry
        mov _386Return,offset hole
        jmp _Exit
        
mickey  db 'MS-DOS MOUSE DRIVER (386P default)',0
        ; offsets to asciiz containing mouse device name
        ; (max 40 chars including the final NUL (0) byte )
        
        align dword
_MouseName dd offset mickey, 0, 0, 0
        ; mouse movement limits, they must be set before mouse positioning               
_MouseX1 dd 4 dup(0)
_MouseX2 dd 4 dup(0)
_MouseY1 dd 4 dup(0)
_MouseY2 dd 4 dup(0)
_MouseZ1 dd 4 dup(0)
_MouseZ2 dd 4 dup(0)
        ; mouse stepping sensitivity
        ; (controls ballistic/stepping if supported by driver)
_MouseMX dd 4 dup(0)
_MouseMY dd 4 dup(0)        
_MouseMZ dd 4 dup(0)        
        ; mouse coords  
                      ; "low"        "high"
_MouseX  dd 4 dup(0)  ; left     to right
_MouseY  dd 4 dup(0)  ; up       to down
_MouseZ  dd 4 dup(0)  ; backward to forward
_AngXY   dd 4 dup(0)  ; right   to up
_AngZY   dd 4 dup(0)  ; forward to up     
_AngXZ   dd 4 dup(0)  ; right   to forward
_Buttons dd 4 dup(0)  ; Mouse button flags
               ; meaning of _Buttons
               ; bit0 = button 0
               ; bit1 = button 1
               ; bit2 = button 3
               ; ...
               ; bitN = button N
               ; YEAH! This baby can support up to 32 buttons
               ; but usually a mouse will have 2..3 buttons
               ; (duplicate the button3 function on the keyboard 
               ;  if you wanna be safe)
               ; If you duplicate button functions on the keyboard
               ; you don't have to check the existence of buttons.
               ; Anyway, if you own one of those weird mouse-with-keypad
               ; you can fully use it once you get a XID driver.

        public _MouseX,_MouseY,_MouseZ,_AngXY,_AngZY,_AngXZ,_Buttons
        public _MouseX1,_MouseX2,_MouseY1,_MouseY2,_MouseZ1,_MouseZ2
        public _MouseMX,_MouseMY,_MouseMZ,_MouseName               


               
_MReset dd offset MMReset
        dd offset none
        dd offset none
        dd offset none
        
_MRead  dd offset MMRead
        dd offset none
        dd offset none
        dd offset none
        
_MWrite dd offset MMWrite
        dd offset none
        dd offset none
        dd offset none
        
_MRange dd offset MMRange
        dd offset none
        dd offset none
        dd offset none        
        
_MSetup dd offset MMSetup
        dd offset none
        dd offset none
        dd offset none        
        
                
        
        align byte
        public _MouseReset
_MouseReset:
        ; in: esi = mouse device id
        ; out:
        ;    eax == 00000h if mouse not installed
        ;    eax == 0FFFFh if mouse installed
        ;             mouse hidden & positioned on center of screen
        ;    coordinates not supported are set to 0
        ;    angles not supported are set to -1
        ;    the supported ones are initially set to zero
        ;    all the mouse data vars must be set correctly before calling this
        call [esi*4+_MReset]  ; reset
        or eax,eax
        jz theend
        call [esi*4+_MRange]  ; set initial range
        
        mov eax,[esi*4+_MouseX2]
        add eax,[esi*4+_MouseX1]
        sar eax,1
        mov [esi*4+_MouseX],eax
        mov eax,[esi*4+_MouseY2]
        add eax,[esi*4+_MouseY1]
        sar eax,1
        mov [esi*4+_MouseY],eax
        call [esi*4+_MWrite]   ; write central position
        
        call [esi*4+_MRead]   ; & read it for safe
        mov eax,0FFFFh
theend:
        ret        
        
MMReset: ; default mouse
        mov V86eax,0
        mov eax,33h
        call _ExecINT
        xor  eax,eax
        mov [esi*4+_MouseZ],eax
        mov eax,-1
        mov [esi*4+_AngXY],eax
        mov [esi*4+_AngZY],eax
        mov [esi*4+_AngXZ],eax
        mov eax,V86eax
        ret
        
        public _MouseRead
_MouseRead:        
        jmp [esi*4+_MRead]
        ; mouse status vars set
        
MMRead: push eax
        push ecx
        push ebx
        mov V86eax,3 ; poll current mouse buttons & position
        ; OUT:
        ;       V86bx = button status
        ;               bit0 = 1 if LEFT  button pressed
        ;               bit1 = 1 if RIGHT button pressed
        ;       V86cx = column
        ;       V86dx = row
        mov al,33h
        call _ExecINT
        mov   eax,V86ebx
        movsx ecx,V86cx
        and eax,7 ; up to three buttons supported in microsoft mouse mode
        movsx ebx,V86dx
        mov [esi*4+_Buttons],eax
        mov [esi*4+_MouseX],ecx
        mov [esi*4+_MouseY],ebx
        pop ebx
        pop ecx
        pop eax
        ret
        
        public _MouseWrite
_MouseWrite:
        jmp [esi*4+_MWrite]
        
MMWrite:push eax
        push ebx
        push ecx
        mov V86eax,4 ; set mouse pointer position
        ;  IN: V86cx = new column
        ;      V86dx = new row
        ;  N.B. depending on the video mode some mouse drivers
        ;       either TRUNC or ROUND the row/column values received
        mov ecx,[esi*4+_MouseX]
        mov ebx,[esi*4+_MouseY]
        mov V86ecx,ecx
        mov V86edx,ebx
        mov al,33h
        call _ExecINT
        pop ecx
        pop ebx
        pop eax
        ret
        
        public _MouseRange
_MouseRange:
        jmp [esi*4+_MRange]
        
MMRange: ; sets ranges, and balistic/stepping of movements
        push eax
        push ebx
        push ecx
        ; X Range
        mov V86eax,7
        mov ecx,[esi*4+_MouseX1]
        mov ebx,[esi*4+_MouseX2]
        mov V86ecx,ecx
        mov V86edx,ebx
        ; IN: V86cx = min column
        ;     V86dx = max column
        mov al,33h
        call _ExecINT
        ; Y Range
        mov V86eax,8
        mov ecx,[esi*4+_MouseY1]
        mov ebx,[esi*4+_MouseY2]
        mov V86ecx,ecx
        mov V86edx,ebx
        ; IN: V86cx = min row
        ;     V86dx = max row
        mov al,33h
        call _ExecINT
        pop ecx
        pop ebx
        pop eax
        ret
        
        public _MouseSetup
_MouseSetup:
        jmp [esi*4+_MSetup]        
        
MMSetup: ret ; this one needs no setups
       
code32 ends        
	   END
