; Assembly implementation of BlowFish E function.
;
; Original algoritm by Bruce Schneier
; First assembly implementation by John Lots and Walter van Holst
; Assembly rewrite by Jeroen Pluimers
;
; This code is hereby donated to the public domain
;
; Version history of rewritten code:
;   19941230 1.00.00 jwp - implemented assembly code from scratch
;
; Original Pascal code:
;   Type
;     TPArray = array[1..18] of Longint;
;     TSBox = array[1..4,0..255] of Longint;
;   procedure BlowEncrypt(var paramXl,paramXr:LongInt; PArray:TPArray; SBox: TSBox);
;   var
;     Xl,Xr, Temp: Longint;
;     i: Byte;
;   begin
;     Xl := paramXl;
;     Xr := paramXr;
;     for i := 1 to 16 do begin
;       Xl:=Xl XOR P[i];
;       Xr:=F(Xl,S) XOR Xr;
;       Temp:=Xl;
;       Xl:=Xr;
;       Xr:=Temp;
;     end;
;     Temp:=Xl;
;     Xl:=Xr;
;     Xr:=Temp;
;     Xr:=Xr XOR P[17];
;     Xl:=Xl XOR P[18];
;     paramXl := Xl;
;     paramXr := Xr;
;   end;

Ideal
P386
Model   TPascal

CodeSeg

  Struc TPArray
    contents      dd      18 dup(?)
  EndS

  Struc TSBox
    box1          dd      256 dup(?)
    box2          dd      256 dup(?)
    box3          dd      256 dup(?)
    box4          dd      256 dup(?)
  EndS

  Proc    BlowEncrypt Far Xl: DWord, Xr: DWord, PArray: DWord, SBox: DWord
  Public  BlowEncrypt
  ; NOTE:
  ;  - This routine is FAR

  Extrn   F: Near
  ; Volgens de handleiding moet dit ook kunnen, maar het werkt niet:
  ; ProcDesc F Near Input: DWord, SBox: DWord

  ; stack frame is automatically generated

          push    ds

          ; load the passed data
          lds     si,  [Xl]
          mov     ebx, [ds:si]
          lds     si,  [Xr]
          mov     edx, [ds:si]
          lds     si,  [PArray]
          les     di,  [SBox]

  ; ds:si = PArray[i]
  ; es:di = SBox
  ; B = Xl
  ; D = Xr

  ; note: each time we call F, we must save ds:si, es:di, B and D

          mov     cx,  16

  @@Loop:

          ; Xl := Xl XOR PArray[i];

          pushf   ; be nice to software that expects the D flag to be saved
          cld
          lodsd   ; Get PArray[i] into eax and increment si by 4
          popf
          xor     ebx, eax

          ; Xr := F(Xl,SBox) XOR Xr;

          push    cx
          push    ebx   ; new Xl
          push    edx   ; old Xr
          push    ds
          push    si
          push    es
          push    di

          push    ebx
          push    es
          push    di
          call    F

          ; get dx:ax into edx
          shl     edx, 16
          mov     dx,  ax

          pop     di
          pop     es
          pop     si
          pop     ds
          pop     eax     ; old Xr
          pop     ebx     ; new Xl
          pop     cx

          xor     edx, eax   ; new Xr

          ; Swap new Xl and new Xr

          xchg    ebx, edx

          loop    @@Loop

          ; Swap new Xl and new Xr back

          xchg    ebx, edx

          ; Xr:=Xr XOR PArray[17];
          ; Xl:=Xl XOR PArray[18];

          pushf   ; be nice to software that expects the D flag to be saved
          cld
          lodsd   ; get PArray[17]
          xor     edx, eax
          lodsd   ; get PArray[18]
          xor     ebx, eax
          popf

          lds     si,  [Xl]
          mov     [ds:si], ebx
          lds     si,  [Xr]
          mov     [ds:si], edx

          pop     ds

          ret

  ; stack cleanup is automatically generated

  EndP ; BlowEncrypt


EndS  ; CodeSeg

End   ; Source