PROGRAM cryptblw;

{ CryptBlw.Pas (c) 1994 by Walter H. van Holst <2:281/201.4>
  Example program of the usage of the BlowFish unit.            
  
  Hereby donated to the public domain                           }

USES Dos,Blowfish;

CONST
     BufferSize=8192;

{$M $9000,0,$20000}

VAR
   Key:String[56];
   InputFile,OutputFile:PathStr;
   Argument:STRING[2];
   Teller,FillBuffer,NumRead,NumWritten:WORD;
   Input,Output:File;
   Buffer:ARRAY [0..BufferSize-1] OF LongInt;
   InputSize,Counter,Debug,Test1,Test2:LongInt;
   Buf:BYTE ABSOLUTE Buffer;
   P:PArray;
   S:SBox;
   Hour,Minute,Second,Second100:Word;


function File_Exists(const FileName: string): Boolean;
   var
      F: File;

   begin
        Assign(F, FileName);
        {$i-} Reset(F,1); {$i+}
         File_Exists := IoResult = 0;
   end;


FUNCTION Passes(InputSize:LongInt):Longint;
 BEGIN
       Passes:=((InputSize DIV (BufferSize*4) ) + (InputSize MOD (BufferSize*4)) * 1 -
        ((InputSize MOD (BufferSize *4)) * 1 - 1));
 END;

BEGIN
     WriteLn('******');
     Argument:=Copy(ParamStr(1),1,2);
     InputFile:=ParamStr(3);
     OutputFile:=ParamStr(4);
     Debug:=SizeOf(Buffer);
     IF (ParamStr(1)<>'') AND (ParamStr(2)<>'') AND (ParamStr(3)<>'') THEN
      BEGIN
           IF File_Exists(ParamStr(3)) THEN
            BEGIN
             Key:=Copy(ParamStr(2),1,56);
             WriteLn('Initializing key');
             InitBlowFish(Key,P,S);
             Filemode:=2;
             Assign(Input,InputFile);
             Reset(Input,1);
             InputSize:=FileSize(Input);
             IF OutPutFile<>'' THEN Assign(Output,OutPutFile) ELSE Assign(Output,'OUT.BLW');
             ReWrite(Output,1);
             Debug:=Passes(InputSize);
             GetTime(Hour,Minute,Second,Second100);
             WriteLn(Hour,':',Minute,':',Second,':',Second100);
             IF Argument='-e' THEN
              BEGIN
               FOR Counter:=1 TO Passes(InputSize) DO
                BEGIN
                 IF Counter<Passes(InputSize) THEN FillBuffer:=BufferSize*4 ELSE
                   FillBuffer:=InputSize-((Passes(InputSize)-1)*(BufferSize*4));
                 WriteLn('Filling buffer with data');
                 BlockRead(Input,Buffer,SizeOf(Buffer),NumRead);
                 WriteLn('Encrypting the data');
                 FOR Teller:=0 TO (FillBuffer DIV 4)-1 DO
                  BEGIN
                   BlowEncrypt(Buffer[Teller],Buffer[Teller+1],P,S);
                   Inc(Teller);
                   {WriteLn(Teller);}
                  END;
                 WriteLn('Writing the data');
                 BlockWrite(Output,Buffer,NumRead,NumWritten);
                 Write  ('Pass ');
                 Write  (Counter);
                 Write  (' of ');
                 WriteLn(InputSize DIV BufferSize);
                END;
               Close(Input);
               Close(Output);
              END
             ELSE
             IF ParamStr(1)='-d' THEN
              BEGIN
               WriteLn('Decrypting '+ParamStr(3));
               FOR Counter:=1 TO Passes(InputSize) DO
                BEGIN
                 IF Counter<Passes(InputSize) THEN FillBuffer:=BufferSize*4 ELSE
                   FillBuffer:=InputSize-((Passes(InputSize)-1)*(BufferSize*4));
                 BlockRead(Input,Buffer,SizeOf(Buffer),NumRead);
                 FOR Teller:=0 TO (FillBuffer DIV 4)-1 DO
                  BEGIN
                   BlowDecrypt(Buffer[Teller],Buffer[Teller+1],P,S);
                   Inc(Teller);
                  END;
                 BlockWrite(Output,Buffer,NumRead,NumWritten);
                END;
               Close(Input);
               Close(Output);
               END;
             GetTime(Hour,Minute,Second,Second100);
             WriteLn(Hour,':',Minute,':',Second,':',Second100);
            END;
      END;
END.
