------------- Listing 7: The file tsstream.c ------------------

// test <sstream>
#include <cassert>
#include <iostream>
#include <sstream>

void t1()
        {       // test stringbuf
        _STD string s0("s0"), s1("s1"), s2("s2"), s3("s3");
        _STD stringbuf sb0, sb1(_STD ios::in), sb2(_STD ios::out),
                sb3(_STD ios::in | _STD ios::out);
        _STD stringbuf sb10(s0), sb11(s1, _STD ios::in),
                sb12(s2, _STD ios::out),
                sb13(s3, _STD ios::in | _STD ios::out);
        _STD ostream outs(&sb0);
        outs << "dynamic stringbuf 0";
        s3 = sb0.str();
        assert(s3 == "dynamic stringbuf 0");
        sb0.str(s0);
        assert(sb0.str() == "s0");
        outs.rdbuf(&sb2);
        outs << "dynamic stringbuf 2";
        assert(sb2.str() == "dynamic stringbuf 2");
        outs.rdbuf(&sb10);
        outs << "x";
        assert(sb10.str() == "x0");
        outs.rdbuf(&sb11);
        outs << "x";
        assert(!outs.good() && sb11.str() == "s1");
        outs.rdbuf(&sb12);
        outs << "x";
        assert(sb12.str() == "x");
        assert(sb12.pubseekoff(2, _STD ios::beg).offset() == 2
                && sb12.str() == "x2");
        }

void t2()
        {       // test istringstream
        _STD string s0("s0"), s1("s1"), s2("s2"), s3("s3");
        _STD istringstream is0, is1(_STD ios::in),
                is2(_STD ios::out), is3(_STD ios::in | _STD ios::out);
        _STD istringstream is10(s0), is11(s1, _STD ios::in),
                is12(s2, _STD ios::out),
                is13(s3, _STD ios::in | _STD ios::out);
        assert(is10.rdbuf()->str() == "s0");
        assert(is11.str() == "s1");
        is0.str("abc");
        assert(is0.str() == "abc");
        is0 >> s0;
        assert(s0 == "abc");
        }

void t3()
        {       // test ostringstream
        _STD string s0("s0"), s1("s1"), s2("s2"), s3("s3");
        _STD ostringstream os0, os1(_STD ios::in),
                os2(_STD ios::out), os3(_STD ios::in | _STD ios::out);
        _STD ostringstream os10(s0), os11(s1, _STD ios::in),
                os12(s2, _STD ios::out),
                os13(s3, _STD ios::in | _STD ios::out);
        assert(os10.rdbuf()->str() == "");
        assert(os13.str() == "s3");
        os0.str("abc");
        assert(os0.str() == "");
        assert(os0.rdbuf()->pubseekoff(2, _STD ios::beg).offset()
                == 2 && os0.str() == "ab");
        os0 << "Cde";
        assert(os0.str() == "abCde");
        }

int main()
        {       // test basic workings of stringstream definitions
        t1();
        t2();
        t3();
        _STD cout << "SUCCESS testing <sstream>" << _STD endl;
        return (0);
        }

