LISTING 4 - Illustrates several <math.h> functions

#include <stdio.h>
#include <math.h>

main()
{
    double x = 1234.56, y = 90.1234, z, w;
    int p;

    printf("x == %g, y == %g\n",x,y);
    printf("fmod(x,y) == %g\n",fmod(x,y));
    printf("floor(y) == %g\n",floor(y));
    printf("ceil(y) == %g\n",ceil(y));
    w = modf(y,&z);
    printf("after modf(y,&z): w == %g, z == %g\n",w,z);
    w = frexp(y,&p);
    printf("after frexp(y,&p): w == %g, p == %d\n",w,p);
    printf("ldexp(w,p) == %g\n",ldexp(w,p));
    return 0;
}

/* Output:
x == 1234.56, y == 90.1234
fmod(x,y) == 62.9558
floor(y) == 90
ceil(y) == 91
after modf(y,&z): w == 0.1234, z == 90
after frexp(y,&p): w == 0.704089, p == 7
ldexp(w,p) == 90.1234
*/
