#include "random.h"

#ifndef _INC_CHROM_
#define _INC_CHROM_

class CGAChromosome
{
public:
   static void    InitializeChromosomeClass(
                     size_t Length);
  ~CGAChromosome();
   CGAChromosome(float Prob = 0.0);

   CGAChromosome* Compliment() const;
   void           Mutate(float Prob);
   inline size_t  GetLength() const;
   inline float   GetFitness() const;
   friend void    Crossover(CGAChromosome*  Parent1,
                     CGAChromosome*  Parent2,
                     CGAChromosome*& Child1,
                     CGAChromosome*& Child2,
                     float Prob);
   friend float   CalcSimilarityRatio(
                     CGAChromosome* Chrom1,
                     CGAChromosome* Chrom2);
   inline GABool& operator[](size_t Idx);

private:
   static void InitializeCrossoverMask(float Prob);

   static GABool*   m_CrossoverMask;
   static size_t    m_Count;
   static size_t    m_Length;
   GABool*          m_Data;
   float            m_Fitness;
};

size_t CGAChromosome::GetLength() const
{
   return m_Length;
}

float  CGAChromosome::GetFitness() const
{
   return m_Fitness;
}

GABool& CGAChromosome::operator[](size_t Idx)
{
   return m_Data[Idx];
}

float CalcFitness(CGAChromosome* Chromosome);

#endif
