/* WINDOWS VERSION */

/* This sample program demonstrates the use of the .EXE file validation */
/* system. This program simply checks whether its .EXE file is valid,   */
/* and displays a message accordingly. To rebuild this file, create a   */
/* "makefile" / "project file" that includes exedemo.c and exevalid.c.  */
/* After compiling the .EXE file, use the exestamp program to create a  */
/* valid hash stamp in the .EXE file.                                   */

#include "windows.h"

/* Include the EXEValid header file. */
#include "exevalid.h"

/* Program execution begins here. */
int PASCAL WinMain(HINSTANCE hinstCurrent,
                   HINSTANCE hinstPrevious,
                   LPSTR lpszCmdLine,
                   int nCmdShow)
{
   char szEXEFileName[100];

   if(!GetModuleFileName(hinstCurrent, szEXEFileName, sizeof(szEXEFileName)))
   {
      MessageBox(NULL, "Unable to determine .EXE file name.",
         ".EXE Validation Demo", MB_OK);
   }

   /* Validate EXE and act accordingly. */
   switch(ValidateEXE(szEXEFileName))
   {
      case kInvalid:
           MessageBox(NULL,
              "EXE file does not have a valid hash stamp; aborting.",
            ".EXE Validation Demo", MB_OK);
         return(1);
      case kGeneralFailure:
           MessageBox(NULL,
              "Internal error - not enough system resources available.",
            ".EXE Validation Demo", MB_OK);
         return(1);
   }
   
   /* Program execution will only get to this point if .EXE is valid. */
   MessageBox(NULL, "EXE file is valid, proceeding normally.",
      ".EXE Validation Demo", MB_OK);

   /* Exit program. */   
   return(0);
}


