// Windows Marquee Control Test Program

#include <windows.h>
#include "marquee.h"
#include "marqtest.h"

extern "C" {
  long far pascal _export WndProc(HWND, UINT, WORD, LONG);
  int pascal WinMain(HINSTANCE, HINSTANCE, LPSTR, int);
}

long far pascal _export WndProc(HWND hwnd, UINT message, WORD wParam,
  LONG lParam)
{
  switch (message)
  {
    case WM_CREATE:
      return 0;
    case WM_COMMAND:
      switch (wParam)
      {
        case INCREASE:
          SendDlgItemMessage(hwnd, MARQUEE, MA_SETSPEED,
            (int) SendDlgItemMessage(hwnd, MARQUEE, MA_GETSPEED, 0, 0L) + 1,
            0L);
          SetDlgItemInt(hwnd, SPEED,
            (int) SendDlgItemMessage(hwnd, MARQUEE, MA_GETSPEED, 0, 0L),
            TRUE);
          return 0; 
        case DECREASE:
          SendDlgItemMessage(hwnd, MARQUEE, MA_SETSPEED,
            (int) SendDlgItemMessage(hwnd, MARQUEE, MA_GETSPEED, 0, 0L) - 1,
            0L);
          SetDlgItemInt(hwnd, SPEED,
            (int) SendDlgItemMessage(hwnd, MARQUEE, MA_GETSPEED, 0, 0L),
            TRUE);
          return 0; 
      }
      break;
    case WM_CLOSE:
      DestroyWindow(hwnd);
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0);
      return 0;
  }
  return DefDlgProc (hwnd, message, wParam, lParam);
}

#pragma argsused
int pascal WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    HWND hwnd;
    MSG msg;

    if (!hPrevInstance)
    {
      WNDCLASS wndclass;
      wndclass.style = 0;
      wndclass.lpfnWndProc = (WNDPROC) WndProc;
      wndclass.cbClsExtra = 0;
      wndclass.cbWndExtra = DLGWINDOWEXTRA;
      wndclass.hInstance = hInstance;
      wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
      wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
      wndclass.hbrBackground = NULL;
      wndclass.lpszMenuName = NULL;
      wndclass.lpszClassName = "MARQUEETEST";
      RegisterClass (&wndclass);
    }

    hwnd = CreateDialog(hInstance, "MARQUEETEST", 0, NULL);
    SetDlgItemInt(hwnd, SPEED,
      (int) SendDlgItemMessage(hwnd, MARQUEE, MA_GETSPEED, 0, 0L), TRUE);
    ShowWindow(hwnd, nCmdShow == SW_SHOWMAXIMIZED ? SW_SHOW : nCmdShow);
    UpdateWindow(hwnd);

    while (GetMessage(&msg, NULL, 0, 0))
      if (!IsDialogMessage (hwnd, &msg))
          DispatchMessage (&msg);

    return msg.wParam;
}



