         .486p
DGROUP   GROUP _TEXT

_TEXT    SEGMENT BYTE PUBLIC 'CODE'
         ASSUME CS:_TEXT,DS:DGROUP,SS:DGROUP

;
;
; Flynn_Plasma display routine - flat video mode or memory buffer
;
; In:
;  ESI = plasma start position 1 (x,y in data)
;  EBX = plasma start position 2 (x,y in data)
;  EDI = screen/window start (x,y on screen or memory buffer)
; Out=In:
;
; During routine:
;  EBP = y height of window ( for clipping )
;  EAX = x width  of window ( for clipping )
;  ECX = x width  of plasma ( from data )
;  EDX = x width  of screen ( video mode or buffer width )
;
;  Written by: John McCarthy
;              1316 Redwood Lane
;              Pickering, Ontario.
;              Canada, Earth, Milky Way (for those out-of-towners)
;              L1X 1C5
;
;  Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;
;  (Send me a postcard from someplace near where you live)
;
;

_y_height_of_window dd 200
_x_width_of_window  dd 320 ; width for clipping
_x_width_of_plasma  dd 768 ; width of original plasma data file (made from genplas.exe)
_x_width_of_screen  dd 320 ; width of screen or memory buffer

         public flynn_plasma_

         public _y_height_of_window
         public _x_width_of_window
         public _x_width_of_plasma
         public _x_width_of_screen

         xmax equ 320             ; size of unrolled loop/maximum x window size

pl_jump_address     dd 0

flynn_plasma_:
         pushad
         mov ecx,_x_width_of_plasma
         mov edx,_x_width_of_screen
         mov eax,_x_width_of_window
         mov ebp,_y_height_of_window

         sub ebx,esi
         sub ecx,eax
         sub edx,eax
         push eax
         mov eax,dword ptr pl_loop_offsets[eax*4]
         mov pl_jump_address,eax
         pop eax
         xor al,3
         inc al
         and eax,3
         sub ecx,eax
         jmp [pl_jump_address]

pl_unrolled_loop0:
         rept xmax/4
         lodsd                    ; get 4 source pixels                <- 5 bytes long
         add eax,[esi+ebx]        ; add 4 source pixels                <- for unrolled
         stosd                    ; and store them to screen or buffer <- loops
         endm

         add esi,ecx              ; xwidth_of_plasma - xwidth_of_window
         add edi,edx              ; xwidth_of_screen - xwidth_of_window (0 if full screen)
         dec ebp
         jz short pl_out0
         jmp [pl_jump_address]
pl_out0:
         popad
         ret

pl_unrolled_loop1:
         rept xmax/4
         lodsd                    ; get 4 source pixels                <- 5 bytes long
         add eax,[esi+ebx]        ; add 4 source pixels                <- for unrolled
         stosd                    ; and store them to screen or buffer <- loops
         endm

         lodsd                    ; 1 extra pixel
         add eax,[esi+ebx]
         stosb
         add esi,ecx              ; xwidth_of_plasma - xwidth_of_window
         add edi,edx              ; xwidth_of_screen - xwidth_of_window (0 if full screen)
         dec ebp
         jz short pl_out1
         jmp [pl_jump_address]
pl_out1:
         popad
         ret

pl_unrolled_loop2:
         rept xmax/4
         lodsd                    ; get 4 source pixels                <- 5 bytes long
         add eax,[esi+ebx]        ; add 4 source pixels                <- for unrolled
         stosd                    ; and store them to screen or buffer <- loops
         endm

         lodsd                    ; 2 extra pixels
         add eax,[esi+ebx]
         stosw
         add esi,ecx              ; xwidth_of_plasma - xwidth_of_window
         add edi,edx              ; xwidth_of_screen - xwidth_of_window (0 if full screen)
         dec ebp
         jz short pl_out2
         jmp [pl_jump_address]
pl_out2:
         popad
         ret

pl_unrolled_loop3:
         rept xmax/4
         lodsd                    ; get 4 source pixels                <- 5 bytes long
         add eax,[esi+ebx]        ; add 4 source pixels                <- for unrolled
         stosd                    ; and store them to screen or buffer <- loops
         endm

         lodsd                    ; 3 extra pixels
         add eax,[esi+ebx]
         stosw
         shr eax,16
         stosb
         add esi,ecx              ; xwidth_of_plasma - xwidth_of_window
         add edi,edx              ; xwidth_of_screen - xwidth_of_window (0 if full screen)
         dec ebp
         jz short pl_out3
         jmp [pl_jump_address]
pl_out3:
         popad
         ret

pl_loop_offsets:
         i = xmax/4 * 5
         rept xmax/4
         dd offset pl_unrolled_loop0 + i
         dd offset pl_unrolled_loop1 + i
         dd offset pl_unrolled_loop2 + i
         dd offset pl_unrolled_loop3 + i
         i = i - 5
         endm
         dd offset pl_unrolled_loop0 + i

_TEXT    ends
         end
