/*
 Plasma Data Generator. - modifed from JCLPLASM

 usage:  genplas filename xsize ysize random_seed granularity
    eg:  ganplas test.dat 320   200   7623        70


 inner loop for displaying the plasma line:

esi = plasma start position 1 (x,y)
ebx = plasma start position 2 (x,y) - esi
edi = screen/window start (x,y)

 mov ebp,yheight_of_window
next2:
 mov ecx,xwidth_of_window
next1:
 lodsd                   ; get 4 source pixels                 <- 5 bytes long
 add  eax,[esi+ebx]      ; add 4 source pixels                 <- for unrolled
 stosd                   ; and store them to screen or buffer  <- loops

 dec ecx
 jnz short next1

 add esi,xwidth_of_plasma - xwidth_of_screen
 add edi,xwidth_of_screen - xwidth_of_window (0 if full screen)
 dec ebp
 jnz short next2

where "window" is the area to draw the plasma in (may or may not be full screen)
      "plasma" is the data generated by this program
      "screen" is like, 320x200 if in mode 13h

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

int xmax;
int ymax;
float a;
float b;
int temp;
float g;

main(argc, argv, envp)
   int argc;
   char *argv[];
   char *envp[];
{
        float   x,y,count,i;
        int     lead,offset;
        FILE    *fp;
        unsigned char value;

        printf("\nPlasma Generator 1.1 by John McCarthy, brian.mccarthy@canrem.com\n");
        printf("\nUsage: genplas FILENAME xsize ysize random_seed granularity\n");

        if (argc!=6) {
                printf("\nSupply 5 parameters\n",argv[1]);
                exit(255);
        } /* endif */

        if (!(fp=fopen(argv[1],"wb")))
        {
                printf("Cant open output file %s\n",argv[1]);
                exit(255);
        }

        /* First generate the plasma map.  This is effectively just an
           arbitrary function of x and y which gives a smooth but
           non-uniform surface */

        sscanf(argv[2],"%d",&xmax);
        sscanf(argv[3],"%d",&ymax);
        sscanf(argv[4],"%d",&temp);
        srand(temp);
        sscanf(argv[5],"%f",&g);

        a = (rand() % 28) + 20;
        b = (rand() % 28) + 20;

        for (y=0;y<ymax;y++)
        for (x=0;x<xmax;x++)
        {
               value=84*(3+(cos(0.09*sqrt(((x*g)-xmax/2)*((x*g)-xmax/2)+((y*g)-ymax/2)*((y*g)-ymax/2))))+
               cos(x*g/a)+cos(y*g/b));
               fputc((unsigned char) value,fp);
        }

        fclose(fp);
}
