//****************************************************************************
// File:
//
//     mainwnd.h
//
// Purpose:
//
//     This file provides function prototypes for the callback functions
//     exported from the executable. It also provides the class declaration
//     for the CMainWindow object. 
//
//
// Development Team:
//
//     Joel Krist
//
// Written by Microsoft Product Support Services, Languages Developer Support
// Copyright (c) 1993 Microsoft Corporation. All rights reserved.
//****************************************************************************

#ifndef __MAINWND_H__
#define __MAINWND_H__

#ifndef __AFXWIN_H__
    #error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"

// Define INTERFACE correctly so this file can be used both when building the executable
// and when building the DLL that uses the functions exported from the executable
#undef INTERFACE

#ifdef _BUILDING_EXE_
#define INTERFACE __declspec(dllexport)
#else
#define INTERFACE __declspec(dllimport)
#endif

// Function prototypes for the callback functions exported from the executable
INTERFACE void RegisterThreadsFinished();
INTERFACE void ShowResults( int SortType, int nSwaps, int nComparisons );
INTERFACE void ShowElapsedTime( int SortType, DWORD Time );


/////////////////////////////////////////////////////////////////////////////
// CMainWindow dialog

class CMainWindow : public CDialog
{
// Construction
public:
    CMainWindow(CWnd* pParent = NULL);    // standard constructor

// Dialog Data
    //{{AFX_DATA(CMainWindow)
    enum { IDD = IDD_MAINWINDOW };
    CButton    m_ExitButton;
    CButton    m_ClearResultsButton;
    CButton    m_DoSortButton;
    CButton    m_BubbleControl;
    CButton    m_CancelSortButton;
    int        m_nElements;
    int        m_nListOrder;
    BOOL       m_fDoBubbleSort;
    BOOL       m_fDoExchangeSort;
    BOOL       m_fDoHeapSort;
    BOOL       m_fDoInsertionSort;
    BOOL       m_fDoQuickSort;
    BOOL       m_fDoShellSort;
    int        m_nWhenToDisplayResults;
    //}}AFX_DATA

    int m_nSelectedSortMask;   // Used to represent the sort types selected by the user

// Implementation
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    // Generated message map functions
    //{{AFX_MSG(CMainWindow)
    afx_msg void OnClickedAbout();
    virtual BOOL OnInitDialog();
    afx_msg void OnClickedDoSort();
    afx_msg void OnClickedClearResults();
    afx_msg void OnClickedCancelSort();
    afx_msg void OnSysColorChange();
    //}}AFX_MSG

    DECLARE_MESSAGE_MAP()
};

#endif __MAINWND_H__
