//****************************************************************************
// File:
//
//     sortdemo.cpp    
//
// Purpose:
//
//     Implementation file for the CSortdemoApp class.
//
// Functions:
//
//     CSortdemoApp::InitInstance() - Application initialization
//     CSortdemoApp::ExitInstance() - Application termination
//
//
// Development Team:
//
//     Joel Krist
//
//
// Written by Microsoft Product Support Services, Languages Developer Support
// Copyright (c) 1993 Microsoft Corporation. All rights reserved.
//****************************************************************************

#include "stdafx.h"
#include <stdlib.h>
#include "mainwnd.h"
#include "sortdemo.h"
#include "ctl3d.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// Global pointer to the main window
CMainWindow * pMainWnd;

// The one and only CSortdemoApp object
CSortdemoApp NEAR theApp;

//***********************************************************************
// Function: CSortdemoApp::InitInstance()
//
// Purpose:
//
//     This function handles the CSortdemoApp initialization.
//
// Parameters:
//
//     None.
//
// Returns:
//
//     A BOOL representing the success or failure of the initialization.
//
// Comments:
//
//     This sample uses CTL3D32.DLL to enable 3-D controls. The
//     initialization required to use this DLL is done in this function.
//     For more information on using the CTL3D library please see the
//     article entitled 'Adding 3-D Effects to Controls' provided on the
//     Microsoft Developer Network (MSDN) CD-ROM.
// 
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 10/12/93    Created                                          JKK
//***********************************************************************

BOOL CSortdemoApp::InitInstance()
{
    // Register ourselves with the CTL3D32 DLL and setup things to use
    // the automatic subclassing offered by the DLL
    Ctl3dRegister( AfxGetInstanceHandle() );
    Ctl3dAutoSubclass( AfxGetInstanceHandle() );

    // Create the main dialog window object and save a pointer to it
    // for later use
    if( (pMainWnd = new CMainWindow) == NULL )
        return FALSE;
    
    // Display the main dialog window
    pMainWnd->DoModal();

    // The dialog was dismissed so quit the application
    ::PostQuitMessage(0);

    return TRUE;
}

//***********************************************************************
// Function: CSortdemoApp::ExitInstance()
//
// Purpose:
//
//     This function handles the CSortdemoApp termination.
//
// Parameters:
//     
//     None
//
// Returns:
//
//     An int representing the application's exit code.
//
// Comments:
//
//     None.
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 10/12/93 Created                                             JKK
//***********************************************************************

int CSortdemoApp::ExitInstance()
{
    //Unregister ourselves with the DLL 
    Ctl3dUnregister( AfxGetInstanceHandle() );
    
    // Call the base class ExitInstance
    return CWinApp::ExitInstance();
}
