//****************************************************************************
// File:
//
//     sortdll.h
//
// Purpose:
//
//     Provides type definitions and function prototypes for the routines
//     implemented in sortdll.cpp.
//
// Development Team:
//
//     Joel Krist
//
// Written by Microsoft Product Support Services, Languages Developer Support
// Copyright (c) 1993 Microsoft Corporation. All rights reserved.
//****************************************************************************

#ifndef __SORTDLL_H__
#define __SORTDLL_H__

// Define INTERFACE so this header file can be used in both the DLL and
// the calling executable.
#undef INTERFACE

#ifdef _BUILDING_DLL_
#define INTERFACE __declspec(dllexport)
#else
#define INTERFACE __declspec(dllimport)
#endif

// Defines used when generating list to be sorted
#define ORDERED 0
#define RANDOM  1
#define REVERSE 2

// Struct used to pass information to the sorting threads
struct ThreadParamBlock
{
    int * pListToSort;     // Pointer to the master list to be sorted
    int nNumberOfElements; // The number of elements in the list to be sorted
};

// Prototypes for exported functions
INTERFACE int DoSorts( int nSelectedSortMask, int nListOrder, int nElements, int nWhenToDisplayResults, HWND hwndMainWnd );
INTERFACE void CleanUp( void );

// Critical section object used to control access to the display
INTERFACE CRITICAL_SECTION GlobalCriticalSection;

// Flag used to tell the sorting threads to terminate
INTERFACE int fStopSortingNow;

// Prototypes for non-exported functions
BOOL GenerateList( int nListOrder, int nElements );
void QuickSort(void *);
static void DoQuickSort(int nLeft, int nRight);
void BubbleSort(void *);
void InsertSort(void *);
void ExchangeSort( void * );
void HeapSort( void * );
void ShellSort( void * );
void PercolateUp( int iMaxLevel, int * pList );
void PercolateDown( int iMaxLevel, int * pList );

#endif __SORTDLL_H__
