/*******************************************************************************
 *                                                                             *
 *  MODULE      : FILENAME.C                                                   *
 *                                                                             *
 *  DESCRIPTION : Open file dialog                                             *
 *                                                                             *  
 *******************************************************************************
 *                                                                             *
 *  Last modified: 1/20/95 by Mike Irvine                                      *
 *                                                                             *
 ******************************************************************************/  

#include <windows.h>
#include "filename.h"
#include <io.h>

// Globals

WORD  glbwBPP = 0;
DWORD glbdwComp = 0;

LONG CALLBACK FormatHookProc(HWND, UINT, WPARAM, LPARAM);

DWORD GetDIBComp() 
{
  return glbdwComp; 
}

WORD GetDIBBPP() 
{
  return glbwBPP; 
}


BOOL GetFilename(LPSTR szFilename, LPSTR szMask, BOOL bSave)
{
  	OPENFILENAME ofn;       	 /* common dialog box structure */
  	char szDirName[MAX_PATH];    /* directory string */
  	char szFile[MAX_PATH];       /* filename string */
  	char szFileMask[MAX_PATH];
	static bFirstTime = TRUE;

    if (bFirstTime) {
	  GetWindowsDirectory(szDirName, sizeof(szDirName));
	  bFirstTime = FALSE;
	} else
      GetCurrentDirectory(sizeof(szDirName), szDirName);

    szFile[0] = '\0';

     /* Set the members of the OPENFILENAME structure. */
	strcpy(szFileMask,szMask);
	memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = GetActiveWindow();
    ofn.lpstrFilter = "All files (*.*)\0 *.*\0\0";
    ofn.nFilterIndex = 0;
    ofn.lpstrFile = szFileMask;
    ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrInitialDir = szDirName;
	ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

    /* Display the Open dialog box. */

	if (bSave) {
		if (GetSaveFileName(&ofn)) {
			strcpy(szFilename,ofn.lpstrFile);
			return TRUE;
		}
	} else
	    if (GetOpenFileName(&ofn)) {
			strcpy(szFilename,ofn.lpstrFile);
			return TRUE;
		} 

    return FALSE; 
}

BOOL GetDIBFilename(LPSTR szFilename, LPSTR szMask, WORD wBPP, DWORD dwComp, BOOL bSave)
{
  	OPENFILENAME ofn;       	 /* common dialog box structure */
  	char szDirName[MAX_PATH];    /* directory string */
  	char szFile[MAX_PATH];       /* filename string */
  	char szFileMask[MAX_PATH];
	static bFirstTime = TRUE;

    if (bFirstTime) {
	  GetWindowsDirectory(szDirName, sizeof(szDirName));
	  bFirstTime = FALSE;
	} else
      GetCurrentDirectory(sizeof(szDirName), szDirName);

    szFile[0] = '\0';

  	glbwBPP = wBPP;
  	glbdwComp = dwComp;

     /* Set the members of the OPENFILENAME structure. */
	strcpy(szFileMask,szMask);
	memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = GetActiveWindow();
    ofn.lpstrFilter = "Bitmaps (*.bmp,*.dib;*.rle)\0*.BMP;*.DIB;*.RLE\0Animations (*.1)\0*.1\0All files (*.*)\0 *.*\0\0";
    ofn.nFilterIndex = 0;
    ofn.lpstrFile = szFileMask;
    ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrInitialDir = szDirName;
    ofn.lpTemplateName = "DIBFILEOPEN";
    ofn.lpfnHook = FormatHookProc;
    ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_ENABLEHOOK |
	            OFN_FILEMUSTEXIST | OFN_ENABLETEMPLATE;

    /* Display the Open dialog box. */

	if (bSave) {
        ofn.lpstrTitle = "Save Bitmap";
		if (GetSaveFileName(&ofn)) {   
			strcpy(szFilename,ofn.lpstrFile);
			return TRUE;
		}
	} else  {
        ofn.lpstrTitle = "Open Bitmap";
	    if (GetOpenFileName(&ofn)) {
         	strcpy(szFilename,ofn.lpstrFile);
			return TRUE;
		} 
    }

    return FALSE; 
}


BOOL FileExist(LPSTR szFilename)
{
	return (_access(szFilename, 0) != -1);
}

void ClearRadioButtons(HWND hwnd) 
{
   EnableWindow(GetDlgItem (hwnd, IDC_1BPP), FALSE);
   EnableWindow(GetDlgItem (hwnd, IDC_4BPP), FALSE);
   EnableWindow(GetDlgItem (hwnd, IDC_8BPP), FALSE);
   EnableWindow(GetDlgItem (hwnd, IDC_16BPP), FALSE);
   EnableWindow(GetDlgItem (hwnd, IDC_24BPP), FALSE);
   EnableWindow(GetDlgItem (hwnd, IDC_32BPP), FALSE);
   CheckDlgButton(hwnd, IDC_1BPP, FALSE);
   CheckDlgButton(hwnd, IDC_4BPP, FALSE);
   CheckDlgButton(hwnd, IDC_8BPP, FALSE);
   CheckDlgButton(hwnd, IDC_16BPP, FALSE);
   CheckDlgButton(hwnd, IDC_24BPP, FALSE);
   CheckDlgButton(hwnd, IDC_32BPP, FALSE);
}   

void ProcessRadioButtons(HWND hwnd, WORD wFormat)
{
    switch (wFormat) {
        case IDC_BITFIELDS:
           ClearRadioButtons(hwnd);
           EnableWindow(GetDlgItem (hwnd, IDC_16BPP), TRUE);
           EnableWindow(GetDlgItem (hwnd, IDC_32BPP), TRUE);
           CheckDlgButton(hwnd, IDC_32BPP, TRUE);
           CheckDlgButton(hwnd, IDC_BITFIELDS, TRUE);
           break;

        case IDC_RLE4:
           ClearRadioButtons(hwnd);
           EnableWindow(GetDlgItem (hwnd, IDC_4BPP), TRUE);
           CheckDlgButton(hwnd, IDC_4BPP, TRUE);
           CheckDlgButton(hwnd, IDC_RLE4, TRUE);
           break;

        case IDC_RLE8:
           ClearRadioButtons(hwnd);
           EnableWindow(GetDlgItem (hwnd, IDC_8BPP), TRUE);
           CheckDlgButton(hwnd, IDC_8BPP, TRUE);
           CheckDlgButton(hwnd, IDC_RLE8, TRUE);
           break;

        case IDC_RGB:
           ClearRadioButtons(hwnd);
           EnableWindow(GetDlgItem (hwnd, IDC_1BPP), TRUE);
           EnableWindow(GetDlgItem (hwnd, IDC_4BPP), TRUE);
           EnableWindow(GetDlgItem (hwnd, IDC_8BPP), TRUE);
           EnableWindow(GetDlgItem (hwnd, IDC_16BPP), TRUE);
           EnableWindow(GetDlgItem (hwnd, IDC_24BPP), TRUE);
           EnableWindow(GetDlgItem (hwnd, IDC_32BPP), TRUE);
           CheckDlgButton(hwnd, IDC_8BPP, TRUE);
           CheckDlgButton(hwnd, IDC_RGB, TRUE);
           break;
    }
}

void InitializeRadioButtons(HWND hwnd, WORD bpp, DWORD comp) 
{     
   switch (comp) {
      case BI_RLE4      : ProcessRadioButtons(hwnd, IDC_RLE4); break;
      case BI_RLE8      : ProcessRadioButtons(hwnd, IDC_RLE8); break;
      case BI_RGB       : ProcessRadioButtons(hwnd, IDC_RGB); break;
      case BI_BITFIELDS : ProcessRadioButtons(hwnd, IDC_BITFIELDS); break;
   }   
   
   CheckDlgButton(hwnd, IDC_1BPP, FALSE);
   CheckDlgButton(hwnd, IDC_4BPP, FALSE);
   CheckDlgButton(hwnd, IDC_8BPP, FALSE);
   CheckDlgButton(hwnd, IDC_16BPP, FALSE);
   CheckDlgButton(hwnd, IDC_24BPP, FALSE);
   CheckDlgButton(hwnd, IDC_32BPP, FALSE);
   
   switch (bpp) {
      case 1  : CheckDlgButton(hwnd, IDC_1BPP, TRUE); break;
      case 4  : CheckDlgButton(hwnd, IDC_4BPP, TRUE); break;
      case 8  : CheckDlgButton(hwnd, IDC_8BPP, TRUE); break;
      case 16 : CheckDlgButton(hwnd, IDC_16BPP, TRUE); break;
      case 24 : CheckDlgButton(hwnd, IDC_24BPP, TRUE); break;
      case 32 : CheckDlgButton(hwnd, IDC_32BPP, TRUE); break;
   } 
}   


LONG CALLBACK FormatHookProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg) {
        case WM_INITDIALOG:
            InitializeRadioButtons(hwnd, glbwBPP, glbdwComp); 
            SendMessage(hwnd, WM_COMMAND, IDC_FORMAT, 0);
            if ((glbwBPP == 0) && (glbdwComp == 0))
              EnableWindow(GetDlgItem(hwnd, IDC_FORMAT), FALSE);
            return TRUE;

        case WM_COMMAND:
            switch (LOWORD(wParam)) {   
              case IDOK:
                   if (IsDlgButtonChecked(hwnd, IDC_1BPP))  glbwBPP = 1;
                   if (IsDlgButtonChecked(hwnd, IDC_4BPP))  glbwBPP = 4;
                   if (IsDlgButtonChecked(hwnd, IDC_8BPP))  glbwBPP = 8;
                   if (IsDlgButtonChecked(hwnd, IDC_16BPP)) glbwBPP = 16;
                   if (IsDlgButtonChecked(hwnd, IDC_24BPP)) glbwBPP = 24;
                   if (IsDlgButtonChecked(hwnd, IDC_32BPP)) glbwBPP = 32;

                   if (IsDlgButtonChecked(hwnd, IDC_RGB))   glbdwComp = BI_RGB;
                   if (IsDlgButtonChecked(hwnd, IDC_RLE4))  glbdwComp = BI_RLE4;
                   if (IsDlgButtonChecked(hwnd, IDC_RLE8))  glbdwComp = BI_RLE8;
                   if (IsDlgButtonChecked(hwnd, IDC_BITFIELDS)) glbdwComp = BI_BITFIELDS;
                   return FALSE;

              case IDC_FORMAT:
                   {
                     HWND hWndCtrl = GetDlgItem (hwnd, IDC_BITFIELDS);
                     RECT rectWnd, rectCtrl;
                     
                     GetWindowRect(hwnd, &rectWnd);
                     GetWindowRect(hWndCtrl, &rectCtrl);
                     if (rectWnd.right < rectCtrl.left)
                       MoveWindow(hwnd, rectWnd.left,    rectWnd.top, 
                                        (rectCtrl.right+5) - rectWnd.left,  
                                        rectWnd.bottom - rectWnd.top, TRUE);
                     else
                       MoveWindow(hwnd, rectWnd.left,    rectWnd.top, 
                                        (rectCtrl.left-1) - rectWnd.left, 
                                        rectWnd.bottom - rectWnd.top, TRUE); 
                   }
                   break;

              case IDC_BITFIELDS:
              case IDC_RLE4:
              case IDC_RLE8:
              case IDC_RGB:
                   ProcessRadioButtons(hwnd, LOWORD(wParam));
                   break;

                default:
                   return FALSE; 
            }
            return TRUE;
            break;

        default:
            return FALSE;

    } /* end switch */
}
