
/******************************************************************************\
*       This is a part of the Microsoft Source Code Samples. 
*       Copyright (C) 1993 Microsoft Corporation.
*       All rights reserved. 
*       This source code is only intended as a supplement to 
*       Microsoft Development Tools and/or WinHelp documentation.
*       See these sources for detailed information regarding the 
*       Microsoft samples programs.
\******************************************************************************/

#include <stdio.h>
#include "resource.h"

/****************************************************************************
 *                                                                          *
 *  FILE        : SHOWDIB.H                                                 *
 *                                                                          *
 *  DESCRIPTION : Header/include file for ShowDIB example.                  *
 *                                                                          *
 ****************************************************************************/

typedef    POINTS       MPOINT;

#define GET_WM_ACTIVATE_STATE(wp, lp)   LOWORD(wp)
#define GET_WM_VSCROLL_CODE(wp, lp)     LOWORD(wp)
#define GET_WM_VSCROLL_POS(wp, lp)      HIWORD(wp)
#define GET_WM_HSCROLL_CODE(wp, lp)     LOWORD(wp)
#define GET_WM_HSCROLL_POS(wp, lp)      HIWORD(wp)
#define GET_EM_SETSEL_MPS(iStart, iEnd) (UINT)(iStart), (LONG)(iEnd)
#define GET_WM_COMMAND_CMD(wp, lp)      HIWORD(wp)
#define MAKEMPOINT(l)                   (*((MPOINT *)&(l)))

/* struct to be passed in for the SETDIBSCALING printer escape */
typedef struct {
        SHORT ScaleMode;
        SHORT dx, dy;
} DIBPARAMS;

extern HWND hWndApp;                   /* The handle to the app. window     */

/***************** GLOBAL VARIABLES *************************/

extern CHAR           achFileName[128]; /* File pathname                       */
extern DWORD          dwOffset;     /* Current position if DIB file pointer    */
extern RECT           rcClip;       /* Current clip rectangle.                 */
extern BOOL           fPalColors;   /* TRUE if the current DIB's color table   */
                                    /* contains palette indexes not rgb values */
extern BOOL           bDIBToDevice; /* Use SetDIBitsToDevice() to BLT data.    */
extern BOOL           bLegitDraw;   /* We have a valid bitmap to draw          */
extern WORD           wTransparent; /* Mode of DC                              */
extern CHAR           szAppName[];  /* App. name                               */
extern HPALETTE       hpalCurrent;  /* Handle to current palette               */
extern HANDLE         hdibCurrent;  /* Handle to current memory DIB            */
extern HBITMAP        hbmCurrent;   /* Handle to current memory BITMAP         */
extern HANDLE         hbiCurrent;   /* Handle to current bitmap info struct    */
extern DWORD          dwStyle;      /* Style bits of the App. window           */

/***************** FUNCTION DECLARATIONS *******************/

/***********************************************************/
/* Declarations of functions used in seedib.c module       */
/***********************************************************/

LONG     APIENTRY WndProc  (HWND, UINT, UINT, LONG) ;
BOOL               MenuCommand (HWND hWnd, UINT wParam);
INT                InitDIB (HWND);
VOID               FreeDIB (VOID);

/***********************************************************/
/* Declarations of functions used in drawdib. c module     */
/***********************************************************/

VOID               PrintDIB (HWND hWnd, HDC hDC, INT x, INT y, INT dx, INT dy);
VOID               AppPaint (HWND hWnd, HDC hDC, INT x, INT y);
INT                ErrMsg (PSTR sz,...);
BOOL               fDialog (INT id, HWND hwnd, FARPROC fpfn);
VOID               BandDIB (HWND hWnd, HDC hDC, INT x, INT y);
BOOL     APIENTRY AppAbout (HWND, UINT, UINT, LONG) ;
HANDLE             CopyHandle (HANDLE h);
VOID               SizeWindow (HWND hWnd);
VOID               GetRealClientRect (HWND hwnd, PRECT lprc);
VOID               SetScrollRanges (HWND hwnd);
VOID               DrawSelect (HDC hdc, BOOL fDraw);
VOID        PASCAL NormalizeRect (RECT *prc);
VOID               TrackMouse (HWND hwnd, MPOINT pt);
HBITMAP            CopyBitmap (HBITMAP hbm);
HPALETTE           CopyPalette (HPALETTE hpal);
HBITMAP            CropBitmap (HBITMAP hbm, PRECT prc);
HANDLE             RenderFormat (INT cf);
HANDLE             RealizeDIBFormat (DWORD biStyle, WORD biBits);

