/*
** Copyright (C) by Intratek Computing, 1994-1995. All rights reserved.
*/

/*
** SMLTools
*/

/*
** put_sml_error()              print SML error condition to stderr
**
** Input:
**      - none
**
** Output:
**      - none
**
** Notes:
**      - Don't call directly, use put_sml_error()
*/

void _put_sml_error(char *file, int line);

#define put_sml_error() _put_sml_error(__FILE__, __LINE__)

/*
** sar()                        Search-and-replace
**
** Input:
**      - string = string to be searched
**      - srch = substring to search for (to be replaced)
**      - rep = substring to replace srch with
**      - cs = is sar() case-sensitive or case-insensitive
**
** Output:
**      - pointer to passed string
**              - NULL if fail condition
**
** Notes:
**      - make sure total memory controlled by string is large enough
**        for rep insert
*/

char * sar(char *string, char *srch, char *rep, SML_CASE cs);
