; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

include ctrl\packint.ah
include ctrl\encode.ah
include lzss\lzssgen.ah
include shuffman\packtabl.ah

; Dette modul srger for selve pakningen og inkluderer, hvis det
; nskes, selv den statiske huffman

pack_text segment

; Flgende skriver en streng i LZSS bufferen.
;   enc.curpos=Nuvrende offset
;   DI        =Match offset
;   DX        =Lngden
write_packed macro
  mov si,enc.curpos
  dist si,di
  ; DI=Det offset vi skal gemme
  push di
  mov bx,dx
  add bx,256-min_pack_len ; BX=Huffman kode der skal gemmes
  call huff_encode_char   ; Encod det med huffman
  call write_bits         ; Og skriv det
  jc error1pop
  pop ax

  ; Gem nu offsetet i AX
  ifdef usetabl
    ; Hvis positionen skal gemmes med dynamisk huffman:
    mov bx,ax                ; BX=AX=Koden afstanden vi skal gemme
    and ax,111111b           ; AX=6 mindst betydende bits
    shr bx,6                 ; BX=6 mest betydende bits
    mov cl,huff_pack_len[bx] ; CL=Lngde p kode
    shl ax,cl                ; AX=6 mindst betydende bits som de skal st
    or al,huff_pack_code[bx] ; AL=Koden
    mov ch,6
    add ch,cl                ; CL=Antal bits koden bestr af
  else
    mov ch,12                ; Skriv 12 bits fra AX
  endif
  call write_bits
  jc error1
endm

  lop_stp:
  cmp ax,0    ; Er vi net til EOF?
  jz end_lop  ; Hvis ja, s fortst almindeligt.
  jmp ferror  ; Ellers: S signaler fejl

  exit_lop:
  ; Dette svarer til den sidste del af encode proceduren.
  ; Skriv en slut kode:
  mov bx,100h
  call huff_encode_char
  call write_bits
  jc ferror                ; Skriv en kode med lngden 3

  ; Skriv nu en slut kode
  ifdef usetabl
    mov ax,11111100000000b ; Slut kode
    mov ch,14              ; Antal buts
  else
    mov ax,-1              ; Slut kode
    mov ch,12              ; Antal bits
  endif
  call write_bits          ; Skriv!
  jc ferror

  call bitwrite_done ; Flush buffer - returner dens fejl
  ret

  ferror:
  stc
  ret

encode proc near
  call bitwrite_init ; Initer bitwrite modulet
  call byteread_init ; Og byteread
  call huff_init     ; Initer dynamisk huffman
  call lzsspack_init ; Initer LZSS komprimering

  ; Ls nu op til max_pack_len frem i bufferen
  mov enc.curpos,0

  xor di,di
  lop:
    push di
    call get_byte           ; BL=En karakter
    pop di
    jc lop_stp              ; Hop ved fejl/EOF
    mov lzpck.ascbuf[di],bl ; Gem karakteren
    inc di
    cmp di,max_pack_len     ; Bliv ved til max_pack_len karaketerer er lst
  jb lop
  end_lop:
  mov enc.curlen,di

  ; Indst den frste node:
  xor bp,bp
  call lzsspack_insertnode

  ; G igang med selve kompressionen:
  main_loop:
    cmp enc.curlen,0
    jz exit_lop

    cmp dx,enc.curlen    ; Er matchlen strre end den m?
    jbe godt
    mov dx,enc.curlen    ; S st den til maximalt tilladte vrdi
    godt:

    cmp dx,min_pack_len  ; dx=bestlen
    jge pack             ; Hvis bestlen>=min_pack_len s pak
      mov enc.a,1        ; enc.a=Antal chars der processes
      ; Skriv karakteren direkte med huffman:
      mov di,enc.curpos
      mov bl,lzpck.ascbuf[di] ; BL=Karakteren der skal gemmes
      xor bh,bh               ; BX=Karaketeren
      call huff_encode_char   ; Encod med huffman
      call write_bits         ; Og skriv det kodedde
      jc ferror               ; Hop ved fejl
      jmp char_written

      ; Her er plads til lidt kode:
        test_read_err:
        cmp ax,0      ; Er vi net til EOF?
        jz passed_eof ; Hvis ja, s fortst almindeligt.
        stc           ; Ellers: S signaler fejl:
        ret

        error1pop:
        add sp,2    ; Fjern AX fra stakken
        stc         ; Vi har stadig fejl
        error1:
        ret

    pack:
      mov enc.a,dx            ; enc.a=Antal chars der processes
      ; Pak den givne streng:
      write_packed

    char_written:

    ; enc.a indeholder antallet af karakkterer vi har processet fra bufferen
    ; Indls nu det antal bytes:

    read_in_loop:
      cmp enc.curlen,max_pack_len   ; Er vi forbi EOF?
      jb passed_eof                 ; Hvis ja s hop
      call get_byte                 ; Ellers: Ls en byte
      jc test_read_err
      inc enc.curlen                ; Og neutralisere nste instruktiom
      passed_eof:
      dec enc.curlen                ; Angiv hvor langt der er til vi skal stoppe
      ; BL=Karakter vi skal bruge

      inc enc.curpos                ; G en postion frem
      mov di,enc.curpos             ; DI=Position
      cmp di,bufsize                ; Er vi stadig inden for bufferen
      jnz god_ofs                   ; S hop
      mov enc.curpos,0              ; Ellers: Start forfra
      xor di,di
      god_ofs:

      ; Indst nu det lste forskellige steder:
      mov lzpck.ascbuf[di+max_pack_len-1],bl ; Indst den lste karakter
      cmp di,bufsize-(max_pack_len-1) ; Er vi i de sidste max_pack_len-1 bytes?
      jb normal                       ; Hvis nej, s hop
        ; Slet fra starten og st ogs ind her
        add di,max_pack_len-1-bufsize
        mov lzpck.ascbuf[di],bl
        jmp lab777
      normal:
        add di,max_pack_len-1
      lab777:

      call lzsspack_deletenode ; Slet den valgt node

      mov bp,enc.curpos
      call lzsspack_insertnode ; Og indst den nye

      dec enc.a
    jnz read_in_loop ; Fortst med nste karakter
  jmp main_loop
endp

ends
end
