// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

// This module holds the C++ interface for the assembler library.

// Declare errorcodes. Note that negative errorcodes are reserved
// for use by library.
#define PACK_NOERR   0 // No error
#define PACK_EOD    -1 // End Of Data before end of unpacking
#define PACK_NO_MEM -2 // Out of memory

struct packing {
  virtual int read(char far* buffer, unsigned far* size)=0;
  // This function should read *size bytes to buffer. In *size the number of
  // bytes actually read should be stored. Should return PACK_NOERR or a
  // possitive errorcode.

  virtual int write(char far* buffer, unsigned size)=0;
  // This function should write size bytes from buffer. Should return
  // PACK_NOERR or a possitive errorcode.

  int do_decode();
  // This function does the unpacking. It returns PACK_NOERR if the
  // unpacking were succesfull and returns PACK_EOD if the entier block
  // of packed data couldn't be read. It returns PACK_NO_MEM if there
  // isn't enough free-store memory. Returns the same as the read/write
  // functions if they return an error code.

  int do_encode();
  // This starts packing. Returns as do_decode (cannot return
  // PACK_EOD).
};