{  These packing routines are based on the LZHUF.C program by
   Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

   This is an example on a program that uses the OOP Pascal packing interface.
}

Uses SupOPack;

Const
  { Internal errorcodes: }
  READ_ERR =1;
  WRITE_ERR=2;

Type
  FileIO=Object(Packing)
    infile : File;
    outfile: File;
    rd     : Longint;
    written: Longint;

    Function Read(Var Buffer:Byte; Var Size:Word):Integer;Virtual;
    Function Write(Var Buffer:Byte; Size:Word):Integer;Virtual;

    Procedure WriteStatus;

    Constructor Init(SourceFile:String; DestFile:String);
    Destructor Done;
  end;

Function FileIO.Read(Var Buffer:Byte; Var Size:Word):Integer;
Begin
  BlockRead(infile, Buffer, Size, Size);
  Inc(rd, Size);

  If InOutRes=0 Then
    Read:=PACK_NOERR
  Else
    Read:=READ_ERR;
End;

Function FileIO.Write(Var Buffer:Byte; Size:Word):Integer;
Var
  BytesWritten:Word;
Begin
  BlockWrite(outfile, buffer, size, BytesWritten);
  Inc(written, BytesWritten);
  WriteStatus;

  If BytesWritten=size Then
    write:=PACK_NOERR
  Else
    write:=WRITE_ERR;
End;

Procedure FileIO.WriteStatus;
Begin
  System.Write(#13'Read ', rd, '. Written ', written) ;
End;

Constructor FileIO.Init(SourceFile:String; DestFile:String);
Begin
  rd:=0; written:=0;
  Assign(infile, SourceFile);
  Assign(outfile, DestFile);
  Reset(infile,1);
  ReWrite(outfile,1);
  InOutRes:=0; { Ignores errors, it'll show later anyway }
End;

Destructor FileIO.Done;
Begin
  Close(infile);
  Close(outfile);
  WriteStatus;
  WriteLn;
end;

{----------------------------------------------------------------------------}

Var
  FIO:^FileIO;
  err:Integer;
  str:String;
Begin
  Str:=ParamStr(1);
  If (ParamCount<>3) Or Not (Str [1] In ['A','a','E','e']) Then
    Begin
      WriteLn ('Syntax: SUPPACK.EXE a|e packedfile unpackedfile');
      Halt (1) ;
    End ;

  err:=PACK_NOERR;

  if UpCase(Str[1])='E' then begin { Pak ud }
    New(FIO,Init(ParamStr(2),ParamStr(3)));
    err:=FIO^.DoDeCode;
  end else begin
    New(FIO,Init(ParamStr(3),ParamStr(2)));
    err:=FIO^.DoEnCode;
  end;

  { Show possible error: }
  InOutRes:=0;
  Case err Of
    PACK_EOD   : WriteLn('Unexpected end of file');
    READ_ERR   : WriteLn('Read error');
    WRITE_ERR  : WriteLn('Write error');
  End;

  Halt(err);
End.
