/*****************************************************************************
*       TrueColour Graphics version 1.03                                     *
*                                                                            *
*       The TrueColour Graphics code and documentation are                   *
*       Copyright (c) 1994-1995 by Matthew Hildebrand; all rights reserved.  *
*                                                                            *
*       Unauthorised usage or modification of any or all of TrueColour       *
*       Graphics is strictly prohibited.                                     *
*****************************************************************************/

#include <alloc.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "..\include\tcg.h"
#include "..\include\fixfont.h"

extern "C" FILE *TCG_openFile(char *filename, char *assumeExt, char *envVar, char *mode);


//*****
//***** Constructors
//*****

FixedFont::FixedFont(Colour *fg, Colour *bg, int fgI, int bgI)
{
  //*** Initialize member variables
  rawData = NULL;
  if (fg != NULL)
  {
    fgRed = fg->r;
    fgGreen = fg->g;
    fgBlue = fg->b;
  }
  else
    fgRed = fgGreen = fgBlue = 0xFF;
  fgInv = fgI;
  if (bg != NULL)
  {
    bgRed = bg->r;
    bgGreen = bg->g;
    bgBlue = bg->b;
  }
  else
    bgRed = bgGreen = bgBlue = 0x00;
  bgInv = bgI;
}


FixedFont::FixedFont(char *filename, Colour *fg, Colour *bg, int fgI, int bgI)
{
  //*** Initialize member variables
  rawData = NULL;
  if (fg != NULL)
  {
    fgRed = fg->r;
    fgGreen = fg->g;
    fgBlue = fg->b;
  }
  else
    fgRed = fgGreen = fgBlue = 0xFF;
  fgInv = fgI;
  if (bg != NULL)
  {
    bgRed = bg->r;
    bgGreen = bg->g;
    bgBlue = bg->b;
  }
  else
    bgRed = bgGreen = bgBlue = 0x00;
  bgInv = bgI;

  //*** Load font file
  load(filename);
}


//*****
//***** Destructor
//*****

FixedFont::~FixedFont(void)
{
  if (rawData)					// was memory allocated?
    farfree(rawData);				// yes, free it
  if (image)					// same procedure
    farfree(image);
}


//*****
//***** Load a font
//*****

int FixedFont::load(char *filename)
{
  char signature[8];
  unsigned long fileLen;
  FILE *inFile;

  //*** Open font file
  if ((inFile=TCG_openFile(filename,".fnt","TGEFONTS","rb")) == NULL)
    return (0);

  //*** Parse header
  if (!fread(signature, 8, 1, inFile))          // read in signature
    return (0);
  if (memcmp(signature, "TGEFONT1", 8))         // is signature there?
    return (0);                                 // no, quit

  if (!fread(&realCharWide, 2, 1, inFile))      // read in character width
    return (0);
  if (!fread(&charDeep, 2, 1, inFile))          // read in character depth
    return (0);

  if (realCharWide % 8)                         // ensure even multiple of 8
    charWide = realCharWide + 8-(realCharWide%8);
  else
    charWide = realCharWide;
  charSize = charWide * charDeep;               // precalculate for speed

  //*** Ensure format is correct (ie., file size is charWide*charDeep+12)
  fseek(inFile, 0L, SEEK_END);                  // seek to end of file
  fileLen = ftell(inFile);                      // get file length
  fseek(inFile, 12L, SEEK_SET);                 // seek past header

  fileLen -= 12L;                               // remove header length
  if (fileLen != (charSize/8)*256L)             // verify size OK
    return (0);

  //*** Read in character data
  rawData = farmalloc(fileLen);                 // allocate some RAM
  if (rawData == NULL)                          // was allocation successful?
    return (0);                                 // no, quit

  if (!fread(rawData, (unsigned)fileLen, 1, inFile)) // read in font data
  {                                             // clean up and quit on error
    farfree(rawData);
    return (0);
  }
  fclose(inFile);                               // close the file

  image = farmalloc(imageSizeDim(charWide,charDeep)); // allocate the image buffer
  if (image == NULL)                            // was function successful?
  {                                             // no, clean up and quit
    farfree(rawData);
    return (0);
  }
  imageWidth(image) = charWide;                 // fill in dimensions
  imageHeight(image) = charDeep;

  mask = farmalloc(charSize);                   // allocate mask buffer
  if (mask == NULL)
  {
    farfree(rawData);
    farfree(image);
    return (0);
  }

  return (1);
}


//*****
//***** Compute the width, in pixels, of the given string
//*****

unsigned FixedFont::width(char *str)
{
  return (realCharWide * strlen(str));
}


//*****
//***** Write a string at the specified location
//*****

void FixedFont::put(int x, int y, char *str)
{
  unsigned count, length;

  length = strlen(str);		       		// store for speed
  for (count=0; count<length; count++)		// loop for each character
    put(x+count*realCharWide, y, str[count]);	// put the character
}


//*****
//***** Write a single character at the specified location
//*****

void FixedFont::put(int x, int y, char ch)
{
  register unsigned count;
  unsigned char huge *in, huge *out, huge *m;
  register unsigned char byte;

  //*** Initialize pointers
  (void far*)in = rawData;                  // pointer to bit-image buffer
  in += (charSize/8) * (unsigned)ch;        // point to correct bit-image
  (void far*)out = image;                   // pointer to image buffer
  out += 4;                                 // bump past dimension info
  (void far*)m = mask;                      // pointer to mask buffer

  //*** Convert font data from 1 bit/pixel format
  for (count=0; count<charSize/8; count++)
  {
    byte = *in++;                           // get current byte

    if ((byte>>7) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if ((byte>>6) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if ((byte>>5) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if ((byte>>4) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if ((byte>>3) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if ((byte>>2) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if ((byte>>1) & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }

    if (byte & 1)
    {
      *out++ = fgRed;
      *out++ = fgGreen;
      *out++ = fgBlue;
      *m++ = fgInv==Opaque ? 0xFF : 0x00;
    }
    else
    {
      *out++ = bgRed;
      *out++ = bgGreen;
      *out++ = bgBlue;
      *m++ = bgInv==Opaque ? 0xFF : 0x00;
    }
  }

  putImageMask(x, y, image, mask);          // draw the character
}
