;  Inkey by Peter Zicari, 1992; all rights reserved.
;
;  no fee is requested for use of this code, but I accept no liability for
;  problems that might arise from your use of it.
;  If you find it useful or find a bug and want to comment, you can contact
;  me at peter.zicari@pcohio.com
;
;
; keyboard reader that reads unrecognized key combinations replaces BP's
; readkey. The function returns key code and sets two global variables,
; Functn, which identifies the returned code as a non-letter key, and Escape. 
; The two must be declared either in the same unit or as a global variable.
; The function must be declared in a unit or used with {F+}
; The function works by calling BIOS function 10H, which was not available
; before about 1985. Using this function in your program provides the 
; key combinations without need to load ANSI with the /X paramater.

DATA segment byte public
     Assume  DS:DATA
     Extrn   Functn:Byte
     Extrn   Escape:Byte   ;defined in unit
DATA ends
CODE segment
;
assume cs:CODE
INKEY PROC FAR
PUBLIC Inkey                 ;
PUSH BX                      ;
MOV BL, 224                   ; BL now contains E0h, 224.
XOR AX,AX                    ; zero AX
MOV Functn,AH                ; set Functn to 0
MOV Escape,AH                ; set Escape to 0
MOV AH,10H                   ; request new keyboard function
INT 16H                      ; execute interrupt. results return in AX
CMP AL,0                     ; 0 is function key,
JE Fun                       ; proceed with funtion if it is.
CMP AL,BL                    ; if not 0 is it 224? (from odd keys).
JNE Endfun                   ; skip to chars if it's not.
Fun:
MOV AL,AH                    ; if it is function, AH holds right data
MOV AH,1                     ; 1=true
MOV Functn,AH                ; Function = true
JMP the_end
Endfun:                      ; begin checking character : missing
CMP AL,1BH                   ; is it Escape?
jne the_end                  ; if not, exit, leaving char in AL.
MOV Escape,AH                ; if it is, exit, leaving 1 in escape
;
the_end:
POP BX
RET
Inkey ENDP
CODE ENDS
END

