%
%    "art.t" demonstrates the use of color graphics
%

const Memory_size : int := 32

var
  X1, X2, Y1, Y2,
  Current_line,
  Color_count,
  Increment_count,
  Delta_X1, Delta_Y1, Delta_X2, Delta_Y2,
  Max_X, Max_Y, Max_color,
  I, Color, Graph_mode : int

var Line: array( Memory_size ) of record
                                    LX1, LY1: int
                                    LX2, LY2: int
                                    LColor:   int
                                  end record

program

    label program_exit :
    var vm, vt : int

    check
    init

    vm := videomode                         % save current mode
    vt := videotype                         % hardware type

    if vt = 8 then                          % vga
        Graph_mode := 18 
        Max_X := 639
        Max_Y := 479
        Max_color := 15
    elsif vt = 4 then                       % ega
        Graph_mode := 13 
        Max_X := 319
        Max_Y := 199
        Max_color := 15
    elsif vt = 2 then                       % cga
        Graph_mode := 4 
        Max_X := 319
        Max_Y := 199
        Max_color := 3
    else
        goto program_exit
    end if

    setvideo( Graph_mode )
    wandering_lines

    program_exit:
    setvideo( vm )

end program


procedure check
    
    var ch : char

    put "This program will only work with a color graphics adapter "
    put "Continue Y/N: "...
    ch := chr( getkey )
    assert ch = 'y' or ch = 'Y'

end check


procedure init

    for I := 0 ... Memory_size-1 do
        Line(I).LX1 := 0
        Line(I).LX2 := 0
        Line(I).LY1 := 0
        Line(I).LY2 := 0
    end for

    X1 := 0
    Y1 := 0
    X2 := 0
    Y2 := 0
  
    Current_line := 0
    Color_count := 0
    Increment_count := 0

end init


procedure wandering_lines

    loop

        %
        % erase old current line
        %
        putline( Line( Current_line ).LX1,
                 Line( Current_line ).LY1,
                 Line( Current_line ).LX2,
                 Line( Current_line ).LY2,
                 0 )

        if Color_count = 0 then 
            select_new_color
        end if

        if Increment_count = 0 then 
            select_new_delta_values
        end if

        adjust_X( X1, Delta_X1 )
        adjust_Y( Y1, Delta_Y1 )
        adjust_X( X2, Delta_X2 )
        adjust_Y( Y2, Delta_Y2 )

        putline( X1, Y1, X2, Y2, Color )

        save_current_line                   % new current line

        Current_line := succ( Current_line )

        if Current_line >= Memory_size then 
            Current_line := 0
        end if
            
        Color_count := pred( Color_count )

        Increment_count := pred( Increment_count )

    end loop
        
end wandering_lines


procedure adjust_X( var X, dX : int )

    var tX : int

    tX := X + dX
    if ( tX < 0 ) or ( tX > Max_X ) then
        tX := X
        dX := -dX
    end if
    X := tX

end adjust_X


procedure adjust_Y( var Y, dY : int )

    var tY : int

    tY := Y + dY
    if ( tY < 0 ) or ( tY > Max_Y ) then
        tY := Y
        dY := -dY
    end if
    Y := tY

end adjust_Y


procedure select_new_color

    Color := randint( 1, Max_color ) 
    Color_count := 5 * randint( 1, 15 ) 

end select_new_color


procedure select_new_delta_values

    Delta_X1 := randint( -3, 3 )
    Delta_X2 := randint( -3, 3 )
    Delta_Y1 := randint( -3, 3 )
    Delta_Y2 := randint( -3, 3 )
    Increment_count := 4 * randint( 1, 15 )

end select_new_delta_values


procedure save_current_line

    Line( Current_line ).LX1 := X1
    Line( Current_line ).LY1 := Y1
    Line( Current_line ).LX2 := X2
    Line( Current_line ).LY2 := Y2
    Line( Current_line ).LColor := Color

end save_current_line

