%
% "graph" draws a graph
%

include colors.t

program

   label program_exit :
   var vm, vt, key : int

   vm := videomode
   watch( vm )
   vt := videotype
   watch( vt )

   if vt <= 0 then
      goto program_exit
   elsif vt = 8 then                  % VGA 
      setvideo( 18 )
   elsif vt = 4 then                  % EGA 
      setvideo( 13 )
   elsif vt = 2 then                  % CGA 
      setvideo( 4 )
   else
      goto program_exit
   end if

   draw_sincostan

   program_exit:
   key := getkey
   setvideo( vm )

end program

procedure draw_sincostan

   var i, j : int
   var x, y : real

   putline( 0,   0,   0, 479, light_blue )
   putline( 0, 239, 639, 239, light_blue )

   for i := 0 ... 639 do

      x := i
      y := -50 * sin( x / 100.0 ) + 240
      j := round( y )
      putpixel( i, j, light_green )

   end for

   for i := 0 ... 639 do

      x := i
      y := -50 * cos( x / 100.0 ) + 240
      j := round( y )
      putpixel( i, j, light_red )

   end for

   for i := 0 ... 639 do

      x := i
      y := -50 * tan( x / 100.0 ) + 240
      j := round( y )
      if 0 < j and j < 480 then
         putpixel( i, j, white )
      end if

   end for

end draw_sincostan

