%
% "instab" compresses text files by inserting tabs
%

const Out_file_name : string := "instab.out"
const Tab_size : int := 8

var In_file_name : string( 16 )
var In_file, Out_file : int
var Line: string


program

    put "Enter name of file to compress: "...
    get In_file_name 
    In_file := open( In_file_name, "r" )
    Out_file := open( Out_file_name, "w" )

    put "Inserting tabs . . . "

    loop

        exit when eof( In_file ) 
        get : In_file, Line : *
        put : Out_file, insert_tabs( Line )

    end loop

    if not close( In_file ) then
        put "file close error"
    end if

    if not close( Out_file ) then
        put "file close error"
    end if

    put In_file_name, " -> ", Out_file_name 

end program


function insert_tabs( in : string ) : string

    var i, j, k : int
    var tab : boolean
    var out : string

    j := 0

    for i := 0...255 do

        exit when in( i ) = '\0'

        if in( i ) = ' ' then

            tab := true

            for k := 1...Tab_size - 1 do
                if in( i + k ) ~= ' ' then
                    tab := false
                    exit
                end if
            end for

            if tab then
                out( j ) := '\t'            % ascii tab character
                i := i + Tab_size - 1
            else
                out( j ) := in( i )
            end if

        else

            out( j ) := in( i )

        end if

        watch( in )
        watch( out )

        j := succ( j )

    end for

    out( j ) := '\0'

    return out

end insert_tabs

