% "invert2.t" inverts a two by two matrix

program

    var x11 : real := 6.0           % matrix to invert
    var x12 : real := 3.0
    var x21 : real := 2.0
    var x22 : real := 4.0

    var det : real                  % determinant of the matrix
    var singular : boolean

    var y11, y12, y21, y22 : real   % inverted matrix

    % calculate the determinant:
    det := x11 * x22 - x12 * x21

    singular := det = 0.0           % invertible if false
    assert not singular

    % calculate the inverted matrix
    y11 :=  x22 / det
    y12 := -x12 / det
    y21 := -x21 / det
    y22 :=  x11 / det

    put y11, "  ", y12
    put y21, "  ", y22

end program

