%
% "remtab.t " removes tabs
%

const Out_file_name : string := "remtab.out"
const Tab_width : int := 8

var In_file_name: string( 16 )
var In_file, Out_file: int
var Line: string


program

    label program_exit :

    put "Enter name of file to de-compress: "...
    get In_file_name 
    
    In_file := open( In_file_name, "r" )
    if In_file = 0 then
        put "cannot open file"
        goto program_exit
    end if

    Out_file := open( Out_file_name, "w" )
    put "Removing tabs . . . "

    loop

        exit when eof( In_file ) 
        get :In_file, Line : *
        put :Out_file, remove_tabs( Line )

    end loop

    if not close( In_file ) then
        put "file close error"
    end if
    
    if not close( Out_file ) then
        put "file close error"
    end if
    
    put In_file_name, " -> ", Out_file_name 

    program_exit:

end program


function remove_tabs( in: string ) : string

    var out : string
    var i, j, k : int

    j := 0
    for i := 0 ... length( in ) - 1 do

        if in( i ) = '\t' then
            for k := 1...Tab_width do
                out( j ) := ' '
                j := succ( j )
            end for
        else
            out( j ) := in( i )
            j := succ( j )
        end if

    end for

    out( j ) := '\0'
    watch( out )

    return out    

end remove_tabs

