%
%   "roman.t" converts integers < 4000 into roman numerals
%   adapted for "More C Tools for Scientists and Engineers"
%

const wh : string( 8 ) := "IVXLCDM"

program

    var out : string
    var in : int

    loop

        put "convert int to roman numeral ( < 1 to stop )"
        put "int: "...
        get in
        exit when in < 1
        out := roman( in )
        put "roman: ", out

    end loop

end program


%
%   convert from integer to roman numeral
%
function roman( in : int ) : string

    var number, divisor : int
    var i, j, k, p : int
    var str : string

    number := in
    divisor := 1000
    p := 0

    if number >= 4000 then
        put "Too big, re-enter"
        number := number mod 4000
    end if

    for decreasing k := 3 ... 0 do
        i := number div divisor
        number := number mod divisor

        watch( k )
        watch( i )
        watch( number )
        
        case i of

            value 0:
                % do nothing

            value 5:
                str( p ) := wh( 2*k+1 )
                p := p + 1

            value 9:
                str( p ) := wh( 2*k )
                p := p + 1
                str( p ) := wh( 2*k+2 )
                p := p + 1

            value 4:
                str( p ) := wh( 2*k )
                p := p + 1
                str( p ) := wh( 2*k+1 )
                p := p + 1

            value: 
                if i > 5 then
                    str( p ) := wh( 2*k+1 )
                    p := p + 1
                    i := i - 5
                end if
                for j := 0 ... i-1 do
                    str( p ) := wh( 2*k )
                    p := p + 1
                end for

        end case

        divisor := divisor div 10

    end for

    str( p ) := chr( 0 )

    return str

end roman
