UNIT VTFAST; { Fast Screen operations & etc.}

INTERFACE
Const MaxBoxTypes = 2;
            Type BoxType = Record
                              LeftVLine,
                              RightVline,
                              UpHLine,
                              DownHline,
                              LUCorner,
                              RUCorner,
                              LDCorner,
                              RDCorner : Char;
                             End;
                Boxes =  array [0..MaxBoxTypes] of BoxType;
 Const      VPageL : Word = 4256; { Video Page Length }
{============== DEFINES DRAWING BOX CHARACTERS ================}
       Box :  Boxes =((), (),(){*=-- EXTEND HERE TO MaxBoxTypes--=*} );
       CursorTop : Byte = 0;
       CursorBot : Byte = 0;
         TempBot : Byte = 0;
         TempTop : Byte = 0;
    ExplodeSpeed : Word = 20000; {* = 65535 No delay *}

 VAR      VSeg, { Video segment /$B800/ }
          VOFF, { Video offset /Current Video Page * VPageL/ }
     VideoInfo, { Video Information Word }
          VPage : Word; { Current Video Page }

{****  MAIN INFORMATION FUNCTIONS ****}
 Function DetectVideo : word;
 Function ColorScreen : Boolean;
 Function CurrentPage : Byte;
Procedure SetPage(Page : Byte);
Procedure Cls(Attr : Word);
 Function EGAVGASystem : boolean;
{**** EXTERNAL FAST TYPING PROCEDURES ****}
Procedure PlainWrite(col,row : Word; StrW : String);
Procedure ColorWrite(col,row,F,B : Word; StrW : String);
Procedure SetCharAttr(col,row,attr : Word);
{**** CURSOR ROUTINES ****}
Procedure HideCursor;
Procedure ShowCursor;
Procedure HalfCursor;
Procedure FullCursor;
Procedure SmallCursor;
Procedure SetCursor(Bot,top : Byte);
Procedure GetCursor(Var Bot,top : Byte);
Procedure XY(X,Y : Byte);
Procedure GetXY(Var X,Y : Byte);
{**** CHAR ROUTINES ****}
Procedure PlainWriteChar(Col,Row : Byte;Ch : Char);
Procedure ColorWriteChar(Col,Row,F,B : Byte;Ch : Char);
 Function GetCharFromScreen( Col,Row : Byte) : Char;
 Function GetCharAttrFromScreen( Col,Row : Byte) : Byte;
Procedure GetCharAttributes(Col,Row : Byte;Var F,B : Word);
{**** DESIGN ROUTINES ****}
Procedure PlainClearText(X,Y,X1,Y1 : Byte);
Procedure ClearText(X,Y,X1,Y1,F,B : Byte);
Procedure DrawBox(X,Y,X1,Y1,BoxT : Byte);
Procedure DrawFillBox(X,Y,X1,Y1,F,B,BoxT : Byte);
Procedure ExplodeBox(X,Y,X1,Y1,F,B,BoxT : Byte);
Procedure PlainWriteVert(X,Y : Byte;Txt : String);
Procedure ColorWriteVert(X,Y,F,B : Byte;Txt : String);
Procedure PlainHorizLine(X,X1,Y,LineType : Byte);
Procedure ColorHorizLine(X,X1,Y,F,B,LineType : Byte);
Procedure PlainVertLine(X,Y,Y1,LineType : Byte);
Procedure ColorVertLine(X,Y,Y1,F,B,LineType : Byte);
Procedure PlainWriteCenter(Line : Byte;Txt : String);
Procedure ColorWriteCenter(Line,F,B : Byte;Txt : String);
Procedure PlainWriteBetween(X,X1,Y : Byte; Txt : String);
Procedure ColorWriteBetween(X,X1,Y,F,B : Byte; Txt : String);

{**** OTHER ROUTINES ****}
 Function ReplicateChar(N : Byte; Ch : Char) : String;
 Function Attrib(F,B : Byte) : Byte;
Procedure SetBlink (Stat : Boolean);
Procedure FillScreen(F,B : Byte; Ch : Char);
Procedure PartFillScreen(X,Y,X1,Y1,F,B : Byte; Ch : Char);
Procedure ScrollUp(X,Y,X1,Y1,Num,Attr : Byte);
Procedure ScrollDown(X,Y,X1,Y1,Num,Attr : Byte);
IMPLEMENTATION

{$L VTFAST.OBJ}
{$F+}
Procedure PlainWrite(col,row : Word; StrW : String); External;
Procedure ColorWrite(col,row,F,B : Word; StrW : String); External;
Procedure SetCharAttr(col,row,attr : Word); External;
Procedure Cls(Attr : Word); External;
{$F-}
Procedure FastError(ECode : Byte);
Begin
 Write('VTFAST Runtime Error: ',Ecode);
 Case Ecode of
        1 : WriteLn('. Invalid range requested!');
 End;
 Halt;
End;
{===========================================================================
                 ** MAIN INFORMATION FUNCTIONS **
 ===========================================================================}
Function DetectVideo : word; assembler;
asm
 mov ax,0f00h
 int 10h
End;

Function ColorScreen : Boolean; assembler;
asm
 mov ax,0f00h
 int 10h
 cmp al,07h
 jne @NotMonochrome
  xor ax,ax
 jmp @EndColorScreen
 @NotMonochrome:
  mov ax,01h
 @EndColorScreen:
End;

Function CurrentPage : Byte; assembler;
asm
 mov ax,0f00h
 int 10h
 mov al,bh
end;

Procedure SetPage(Page : Byte);
Begin
asm
 mov al,Page
 mov ah,05h
 int 10h
End;
 VOff := Page * VPageL;
end;
  Function EGAVGASystem : boolean; assembler;
  asm
    MOV AX,1C00h
    MOV CX,7
     INT 10h
     CMP AL,1Ch {VGA ?}
     JNE @MCGACheck
     MOV AL,1
     XOR CX,CX
     JMP @EndProc
   @MCGACheck:
     MOV AX,1200h
     MOV BL,32h
      INT  10h
     CMP AL,12h {MCGA ?}
     JNE @EGACheck
     XOR CX,CX
     MOV AL,1
     JMP @EndProc
   @EGACheck:
     MOV AH,12h
     MOV BL,10h
     MOV CX,0FFFFh
      INT 10h
     CMP CX,0FFFFh {EGA ?}
     JE @EndProc
     MOV AL,1
     XOR CX,CX
   @EndProc:
    CMP CX,0
     JE @EGAVGAPresent
    XOR AL,AL
  @EGAVGAPresent:
  end;

{===========================================================================
                 ** CURSOR ROUTINES **
 ===========================================================================}

Procedure HideCursor;
Begin
If TempTop <> 32 Then GetCursor(TempTop,TempBot);
  asm
   MOV AH,01
   MOV CH,32d
   MOV CL,0
    INT 10H
  End;
End;
Procedure ShowCursor;
Begin
 SetCursor(TempTop,TempBot);
End;
Procedure HalfCursor;
Begin
 SetCursor(7,4);
End;
Procedure FullCursor;
Begin
 SetCursor(7,0);
End;
Procedure SmallCursor;
Begin
 SetCursor(7,6);
End;
Procedure SetCursor(Bot,Top : Byte); assembler;
asm
  MOV AH,01
  MOV CH,BYTE PTR top
  MOV CL,BYTE PTR Bot
   INT 10h
End;
Procedure GetCursor(Var Bot,Top : Byte); assembler;
asm
   MOV AH,03
   MOV BH,1
    INT 10h
   MOV AX,CX
   LES DI,Bot
    STOSB
   ROR AX,8
   LES DI,Top
    STOSB
End;
Procedure XY(X,Y : Byte); assembler;
asm
   MOV AH,02
   MOV BX,WORD PTR VPage
   MOV DH,BYTE PTR Y
   MOV DL,BYTE PTR X
   DEC DH
   DEC DL
    INT 10H
End;
Procedure GetXY(Var X,Y : Byte); assembler;
asm
   MOV AH,03
   MOV BX,WORD PTR VPage
   INC BX
    INT 10h
   INC DH
   INC DL
   LES DI,Y
   MOV AL,DH
    STOSB
   LES DI,X
   MOV AL,DL
    STOSB
End;

{===========================================================================
                 ** CHAR ROUTINES **
 ===========================================================================}
Procedure PlainWriteChar(Col,Row : Byte;Ch : Char);
Begin
 PlainWrite(Col,Row,Ch);
End;
Procedure ColorWriteChar(Col,Row,F,B : Byte;Ch : Char);
Begin
 ColorWrite(Col,Row,F,B,Ch);
End;

 Function GetCharFromScreen(Col,Row : Byte) : Char; assembler;
 Asm
  PUSH DS
   XOR BX,BX
   XOR AX,AX
   MOV AL,BYTE PTR Col
   MOV BL,BYTE PTR Row
   DEC AX
   DEC BX
   SHL BX,8
   SHR BX,1
   MOV Si,BX
   SHR SI,2
   ADD SI,BX
   SHL AX,1
   ADD SI,AX
   ADD SI,VOff
   MOV DS,VSeg
   XOR AX,AX
    LODSB
  POP  DS
 End;
 Function GetCharAttrFromScreen(Col,Row : Byte) : Byte; assembler;
 Asm
  PUSH DS
   XOR BX,BX
   XOR AX,AX
   MOV AL,BYTE PTR Col
   MOV BL,BYTE PTR Row
   DEC AX
   DEC BX
   SHL BX,8
   SHR BX,1
   MOV Si,BX
   SHR SI,2
   ADD SI,BX
   SHL AX,1
   ADD SI,AX
   ADD SI,VOff
   INC SI
   MOV DS,VSeg
   XOR AX,AX
    LODSB
  POP  DS
 End;
Procedure GetCharAttributes(Col,Row : Byte;Var F,B : Word);
Var Tmp : Byte;
 Begin
   Tmp := GetCharAttrFromScreen(Col,Row);
   B := Tmp DIV 16;
   F := Tmp MOD 16;
 End;
{===========================================================================
                 ** DESIGN ROUTINES **
 ===========================================================================}

Procedure PlainClearText(X,Y,X1,Y1 : Byte);
Var i : Byte;
Begin
 If X1-X+1 < 1 Then FastError(1);
 For i := Y to Y1 Do PlainWrite(X,i,ReplicateChar(X1-X+1,' '));
End;
Procedure ClearText(X,Y,X1,Y1,F,B : Byte);
Var i : Byte;
Begin
 If X1-X+1 < 1 Then FastError(1);
 For i := Y to Y1 Do ColorWrite(X,i,F,B,ReplicateChar(X1-X+1,' '));
End;

Procedure DrawBox(X,Y,X1,Y1,BoxT : Byte);
Var I : Byte;
Begin
 If X < 1 Then FastError(1);
 If X1-X-1 < 1 Then FastError(1);
 If BoxT > MaxBoxTypes Then FastError(1);
 PlainWrite(X+1,Y,ReplicateChar(X1-X-1,Box[Boxt].UpHLine));
 PlainWrite(X+1,Y1,ReplicateChar(X1-X-1,Box[Boxt].UpHLine));
 For I := Y+1 To Y1-1 Do Begin
                           PlainWrite(X,I,Box[BoxT].LeftVLine);
                           PlainWrite(X1,I,Box[BoxT].LeftVLine);
                         End;
 With Box[BoxT] Do Begin
                    PlainWrite(X,Y,LUCorner);
                    PlainWrite(X1,Y,RUCorner);
                    PlainWrite(X,Y1,LDCorner);
                    PlainWrite(X1,Y1,RDCorner);
                   End;
End;
Procedure DrawFillBox(X,Y,X1,Y1,F,B,BoxT : Byte);
Var I : Byte;
Begin
 If X < 1 Then FastError(1);
 If X1-X-1 < 1 Then FastError(1);
 If BoxT > MaxBoxTypes Then FastError(1);
 ClearText(X,Y,X1,Y1,F,B);
 ColorWrite(X+1,Y,F,B,ReplicateChar(X1-X-1,Box[Boxt].UpHLine));
 ColorWrite(X+1,Y1,F,B,ReplicateChar(X1-X-1,Box[Boxt].UpHLine));
 For I := Y+1 To Y1-1 Do Begin
                           ColorWrite(X,I,F,B,Box[BoxT].LeftVLine);
                           ColorWrite(X1,I,F,B,Box[BoxT].LeftVLine);
                         End;
 With Box[BoxT] Do Begin
                    ColorWrite(X,Y,F,B,LUCorner);
                    ColorWrite(X1,Y,F,B,RUCorner);
                    ColorWrite(X,Y1,F,B,LDCorner);
                    ColorWrite(X1,Y1,F,B,RDCorner);
                   End;
End;

Procedure ExplodeBox(X,Y,X1,Y1,F,B,BoxT : Byte);
  Var MidX,MidY,
   MaxPases,Tmp,
      TmpX,TmpY,
            Cnt : Byte;  
             dr : Word;

 Function Minimal (First,Second : Byte) : Byte;
 Begin
   Minimal := First;
   If First > Second Then Minimal := Second;
 End;

Begin {* ExplodeBox *}
 MidX := (X+X1) Div 2; TmpX := MidX-X;
 MidY := (Y+Y1) Div 2; TmpY := MidY-Y;
 Tmp := TmpX DIV TmpY;
 If Tmp = 0 Then Tmp := TmpY Div TmpX;
 MaxPases := Minimal(TmpX,TmpY);
 For Cnt := 1 To MaxPases Do Begin For DR := MidX-Cnt*Tmp To MidX+Cnt*Tmp DO
                                       Begin
                                        SetCharAttr(Dr,MidY-Cnt,Attrib(F,B));
                                        SetCharAttr(Dr,MidY+Cnt,Attrib(F,B));
                                       End;
                                   For Dr := MidY-Cnt To MidY+Cnt DO
                                       Begin
                                        SetCharAttr(MidX-Cnt*Tmp,DR,Attrib(F,B));
                                        SetCharAttr(MidX+Cnt*Tmp,DR,Attrib(F,B));
                                       End;
                                   DrawBox(MidX-Cnt*Tmp,MidY-Cnt,
                                               MidX+Cnt*Tmp,MidY+Cnt,
                                               BoxT);
                                   ClearText((MidX-Cnt*Tmp)+1,(MidY-Cnt)+1,
                                               (MidX+Cnt*Tmp)-1,(MidY+Cnt)-1,
                                               F,B);
                                   For DR := 65535 DownTo ExplodeSpeed DO ;
                             End;
 DrawFillBox(X,Y,X1,Y1,F,B,BoxT);
End;

Procedure PlainWriteVert(X,Y : Byte;Txt : String);
Var Len,
     Cnt : Byte;
Begin
 Len := Length(Txt) + Y-1;
 For Cnt := Y To Len Do PlainWrite(X,Cnt,Txt[Cnt-Y+1])
End;

Procedure ColorWriteVert(X,Y,F,B : Byte;Txt : String);
Var Len,
     Cnt : Byte;
Begin
 Len := Length(Txt) + Y-1;
 For Cnt := Y To Len Do ColorWrite(X,Cnt,F,B,Txt[Cnt-Y+1])
End;

Procedure PlainHorizLine(X,X1,Y,LineType : Byte);
Begin
 If X1 <= X Then FastError(1);
 PlainWrite(X,Y,ReplicateChar(X1-X+1,Box[LineType].UpHLine));
End;

Procedure ColorHorizLine(X,X1,Y,F,B,LineType : Byte);
Begin
 If X1 <= X Then FastError(1);
 ColorWrite(X,Y,F,B,ReplicateChar(X1-X+1,Box[LineType].UpHLine));
End;
Procedure PlainVertLine(X,Y,Y1,LineType : Byte);
Begin
 If Y1 <= Y Then FastError(1);
 PlainWriteVert(X,Y,ReplicateChar(Y1-Y+1,Box[LineType].LeftVLine));
End;
Procedure ColorVertLine(X,Y,Y1,F,B,LineType : Byte);
Begin
 If Y1 <= Y Then FastError(1);
 ColorWriteVert(X,Y,F,B,ReplicateChar(Y1-Y+1,Box[LineType].LeftVLine));
End;
Procedure PlainWriteCenter(Line : Byte;Txt : String);
Var Mid : Byte;
Begin
 Mid := Length(Txt) Div 2;
 PlainWrite(40-Mid,Line,Txt);
End;
Procedure ColorWriteCenter(Line,F,B : Byte;Txt : String);
Var Mid : Byte;
Begin
 Mid := Length(Txt) Div 2;
 ColorWrite(40-Mid,Line,F,B,Txt);
End;
Procedure PlainWriteBetween(X,X1,Y : Byte; Txt : String);
Var TMid,PMid : Byte;
Begin
 Tmid := Length(Txt) Div 2;
 Pmid := X + ((X1-X) Div 2);
 PlainWrite(PMid-TMid,Y,Txt);
End;
Procedure ColorWriteBetween(X,X1,Y,F,B : Byte; Txt : String);
Var TMid,PMid : Byte;
Begin
 Tmid := Length(Txt) Div 2;
 Pmid := X + ((X1-X) Div 2);
 ColorWrite(PMid-TMid,Y,F,B,Txt);
End;
{===========================================================================
                 ** OTHER ROUTINES **
 ===========================================================================}


Function Attrib(F,B : Byte) : Byte;
Var t : Byte;
Begin
 Attrib := (B shl 4) + F;
End;

 Function ReplicateChar(N : Byte; Ch : Char) : String;
 Var i : Byte;
   Res : String;
 Begin
   Res :='';
   For i := 1 to N do Res := Res + Ch;
   ReplicateChar := Res;
 End;
Procedure SetBlink (Stat : Boolean); assembler;
asm
    MOV BL,STAT { VGA ONLY }
    MOV AX,1003h
     INT 10h
End;
Procedure FillScreen(F,B : Byte; Ch : Char);
 Var Cnt : Byte;
     Tmp : String[80];
Begin
 Tmp := ReplicateChar(80,ch);
 For Cnt := 1 To 25 Do ColorWrite(1,Cnt,F,B,Tmp);
End;
Procedure PartFillScreen(X,Y,X1,Y1,F,B : Byte; Ch : Char);
 Var Cnt : Byte;
     Tmp : String[80];
Begin
 Tmp := ReplicateChar(X1-X+1,ch);
 For Cnt := Y to Y1 Do ColorWrite(X,Cnt,F,B,Tmp);
End;
Procedure ScrollUp(X,Y,X1,Y1,Num,Attr : Byte); assembler;
asm
   MOV AL,Num
   MOV BH,Attr
   MOV CH,Y
   MOV CL,X
   MOV DH,Y1
   MOV DL,X1
   DEC CL
   DEC CH
   DEC DL
   DEC DH
   MOV AH,6
    INT 10h
end;
Procedure ScrollDown(X,Y,X1,Y1,Num,Attr : Byte); assembler;
asm
   MOV AL,Num
   MOV BH,Attr
   MOV CH,Y
   MOV CL,X
   MOV DH,Y1
   MOV DL,X1
   DEC CL
   DEC CH
   DEC DL
   DEC DH
   MOV AH,7
    INT 10h

end;

Procedure InitVTFast;

 Begin
  VideoInfo := DetectVideo;
  If ColorScreen Then VSeg := $B800
  Else VSeg := $0B000;
  VPage := CurrentPage;
  VOff :=  Vpage * VPageL;
  With Box[0] Do Begin
                     LeftVLine  := ' ';     RightVline := ' ';
                     UpHline    := ' ';     DownHline  := ' ';
                     LUCorner   := ' ';     RUCorner   := ' ';
                     LDCorner   := ' ';     RDCorner   := ' ';
                  End;

  With Box[1] Do Begin
                     LeftVLine  := '';     RightVline := '';
                     UpHline    := '';     DownHline  := '';
                     LUCorner   := '';     RUCorner   := '';
                     LDCorner   := '';     RDCorner   := '';
                  End;
  With Box[2] Do Begin
                     RightVline := '';     LeftVline  := '';
                     UpHline    := '';     DownHline  := '';
                     LUCorner   := '';     RUCorner   := '';
                     LDCorner   := '';     RDCorner   := '';
                  End;
  GetCursor(CursorTop,CursorBot);
 End; {INITVTFAST}

BEGIN
 InitVTFast;
END.
