                .286
DATA    SEGMENT BYTE PUBLIC


        EXTRN     VSeg : WORD
        EXTRN     Voff : WORD
        EXTRN   VPageL : WORD
DATA    ENDS


CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE,DS:DATA
  PUBLIC GetScreen,PutScreen,GetFromScreen,PutToScreen

;============================== GetScrren procedure
  GetScreen proc far
   enter 0,0
    push ds es si di
     mov es,[bp+08d]            ;Load destination
     mov di,[bp+06]
     mov si,Voff                ;Load Video address
     Mov cx,VPageL
     shr cx,1
     mov ax,VSeg
     mov ds,ax
        rep movsw               ;Move all screen to destination
     pop di si es ds
     leave
     retf 4d
  GetScreen Endp
;============================== PutScreen procedure
  PutScreen proc far
  enter 0,0
   push ds es si di
    mov di,Voff                ;Load Video address
    mov ax,Vseg
    mov es,ax
    mov cx,VPageL
    shr cx,1
    mov ds,[bp+08d]           ;Load and source
    mov si,[bp+06]
       rep movsw              ;Move source to video...
    pop di si es ds
  leave
   retf 4d
  PutScreen Endp

;============================== Get a block from screen
  GetFromScreen proc far
           enter 0,0
    push  es si di ds

          mov di,[bp+6]
          mov es,[bp+8]       ;Load destination


          mov cx,[bp+12d]     ;Load    X1
          mov bx,[bp+14d]     ;Load    Y

          dec cx              ;Convert to std coordinates
          dec bx

          mov si,Voff         ;Load Destination
          mov ax,Vseg
          mov ds,ax           ;Destination

          mov ax,160d
          mul bx
          add si,ax           ;Offset + Y*160
          mov dx,[bp+10d]     ;        Y1
          dec dx              ;Convert to std coordinate


  GetLine:

          mov ax,[bp+16d]    ;Load X
          dec ax             ;Convert to std coordinate
          shl ax,1
          add si,ax          ;Offset = X*2
          shr ax,1

  GetChar:                   ;Move line to destination
          Movsw              ;Load Char & attributes
          inc ax
          cmp ax,cx          ;Finish line ?
        jna GetChar          ;No -> Go for next char

          sub si,cx          ;Back to the begining of line
          sub si,cx
          sub si,2
          add si,160d        ;Prepare next line

          inc bx
          cmp bx,dx          ;Finish Block ?
          jna GetLine        ;No-> Here ya, go for next line

     pop ds di si es
           leave
           retf 12d
  GetFromScreen Endp
;============================== Put a block from screen
  PutToScreen proc far
          enter 0,0
    push  es si di ds

          mov di,Voff           ;Load Destination
          mov es,Vseg           ;Destination loaded

          mov si,[bp+6]
          mov ds,[bp+8]       ;Load source


          mov cx,[bp+12d]     ;Load    X1
          mov bx,[bp+14d]     ;Load    Y

          dec cx              ;Convert to std coordinates
          dec bx


          mov ax,160d
          mul bx
          add di,ax           ;Offset + Y*160
          mov dx,[bp+10d]     ;        Y1
          dec dx              ;Convert to std coordinate


  GetLine1:
          mov ax,[bp+16d]    ;Load X
          dec ax             ;Convert to std coordinate
          shl ax,1
          add di,ax          ;Offset = X*2
          shr ax,1

  GetChar1:                  ;Move line to destination
          Movsw              ;Load Char & attributes
          inc ax
          cmp ax,cx          ;Finish line ?
        jna GetChar1         ;No -> Go for next char

          sub di,cx          ;Back to the begining of line
          sub di,cx
          sub di,2
          add di,160d        ;Prepare next line

          inc bx
          cmp bx,dx          ;Finish Block ?
          jna GetLine1       ;No-> Here ya, go for next line

     pop ds di si es
          leave
          retf 16d
  PutToScreen Endp

Public CopyScreenBlock
       copyscreenblock proc far
           enter 0,0
           push  es si di ds
                                  ;LOAD DESTINATION
           Mov di,VOff            ;Load offset
           mov ax,[bp+6]
           dec ax
           mov bx,160d
           mul bx
           add di,ax
           mov ax,[bp+8]
           dec ax
           shl ax,1
           add di,ax              ;Offset destination loaded
           mov es,Vseg            ;Load video segment
                                  ;LOAD SOURCE
           mov si,VOff
           mov ax,[bp+14d]        ;Y
           dec ax
           mov bx,160d
           mul bx
           add si,ax
           mov ax,[bp+16d]        ;X
           dec ax
           shl ax,1
           add si,ax
           mov ax,VSeg
           mov ds,ax               ;Source loaded
           mov ax,[bp+16d]         ;Load coordinates
           mov bx,[bp+14d]
           mov dx,[bp+10d]
           cmp ax,[bp+12d]         ; X1 < X ?
           jnb InvalidData         ;Yes -> Exit from procedure
           cmp bx,dx               ;Y1 < Y ?
           jnb InvalidData         ;No -> Continue...

   NextL:
           mov cx,[bp+12d]         ;Load X1
           sub cx,ax               ;Line length = X1 - X
           Rep movsw               ;Move line

           add si,160d             ;Prepare next line for reading
           sub si,[bp+12d]
           sub si,[bp+12d]
           shl ax,1
           add si,ax
           add di,160d             ;Prepare next line for storing
           sub di,[bp+12d]
           sub di,[bp+12d]
           add di,ax
           shr ax,1
           inc bx                  ;Increment line counter
           cmp bx,dx               ;Finish ?
           jna NextL               ;If no -> Go for next line
   InvalidData :
           pop ds di si es
           leave
          retf 12d
       copyscreenblock endp
CODE ENDS
     END
