;   This program is a TASM version of the MASM pogram in Example 1 of the XLIB
;documentation.  TASM programs must resize the DOS memory block in which they
;are contained so that there will be some free memory for allocation by
;INITXLIB.  The include file RESIZE.INC accomplishes this task.

               MASM51                        ;Use MASM 5.1 compatibility mode
               QUIRKS                        ;Allow MASM 5.1 quirks

PUSHW          MACRO IMMEDIATE16:REST        ;Macro to PUSH 16-bit contant
               IF (@WordSize EQ 4)
               DB             66H
               ENDIF
               DB             68H
               DW             IMMEDIATE16
               ENDM

PUSHD          MACRO IMMEDIATE32:REST        ;Macro to PUSH 32-bit constant
               IF (@WordSize EQ 2)
               DB             66H
               ENDIF
               DB             68H
               DD             IMMEDIATE32
               ENDM

               .MODEL        LARGE,PASCAL,FARSTACK
               .386

               INCLUDE        XLIBB.INC      ;Include XLIB public symbols
               INCLUDELIB     XLIBB.LIB      ;Link with XLIBB.LIB

               .STACK         1024
               .CODE
               .STARTUP
               INCLUDE        RESIZE.INC     ;Free unused DOS memory

               CALL           INITXLIB       ;Initialize XLIB
               OR             EAX,EAX        ;EAX = 0 if successful
               JZ             INITDONE
               MOV            AX,4C01H       ;Initialization failed
               INT            21H

INITDONE:      PUSHD          OFFSET DEMOPROC
               CALL           CALLPM         ;Execute DEMOPROC in protected
               MOV            AX,4C00H
               INT            21H

;Protected-mode routines must be placed in following segment:
TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG, SS:TSEG, DS:TSEG, ES:TSEG, FS:DSEG, GS:DGROUP

;Protected-mode routine to print message to the screen using DOS function.
DEMOPROC       PROC NEAR
               MOV            EBX,OFFSET PMMSG
               MOV            AH,02H
MSGLOOP:       MOV            DL,CS:[EBX]    ;32-bit offset!!!!!
               OR             DL,DL
               JZ             EXIT
               INT            21H            ;Print character with DOS
               INC            EBX
               JMP            MSGLOOP
EXIT:          RET                           ;Go back to real or V86 mode
PMMSG          DB  "In 32-bit protected mode!!!  "
               DB  "Returning to real mode.",10,13,0
DEMOPROC       ENDP

TSEG           ENDS
               END
