{$C FIXED PRELOAD PERMANENT}
{R-,D-,X+}

Library AttSupp;

Uses WinTypes, WinProcs;
Const
    HookInUse           : boolean = false;         { true if hooks are set }
    CallWndProcHookProc : tfarproc = nil;
    gReceived : WordBool = False;
    gJobs : Word = 0;
    gJobStatus : Word = 0;


Var
    SaveExit : Pointer;
    PrevMsgHook : TFarProc;
    gHwnd : Hwnd;
    gCommand : Word;
    gWindow : Hwnd;

{ ------------ }
type
  TCallData = record      { message record as passed to CallWndProc hook }
    lParam : longint;
    wParam : word;
    Msg    : integer;
    Hwnd   : hwnd;
  end;

{-- Function Declarations -----------------------------------------------}

function CallWndProcHook(    nCode    : integer;
                             wParam   : word;
                         var CallData : TCallData) : longint; export;
{
  This is a hook to intercept messages passed by the SendMessage API call
  before they are processed by an application.  This function sees all
  such messages, but we only want left button clicks.  When we get one, we
  post an AppMsg message to the window specified by AppHandle.

  AppHandle and AppMsg are initialized by a call to SetTheHook.
}
  begin
    { REQUIRED }
    if nCode < 0 then begin
      CallWndProcHook := DefHookProc(ncode,wParam,longint(addr(CallData)),addr(CallWndProcHookProc));
      exit;
    end;

    { YOUR CODE GOES HERE }
    (*
    if (CallData.Msg = wm_LButtonDown) and (AppHandle <> 0) then
      PostMessage(AppHandle,AppMsg,0,0);
    *)

    If (CallData.Msg = wm_Command) then
          Begin
          gReceived := True;
          gHwnd := CallData.hwnd;
          gCommand := CallData.wParam;
          End;
    If (CallData.Msg = wm_SpoolerStatus) then
          Begin
          gJobSTatus := CallData.wParam;
          gJobS := CallData.lParam and $ffff;
          End;


    { REQUIRED }
    if CallWndProcHookProc <> nil then
      CallWndProcHook := DefHookProc(ncode,wParam,longint(addr(CallData)),addr(CallWndProcHookProc))
    else
      CallWndProcHook := 0;
  end { CallWndProcHook };

procedure UnsetTheHook; export;
{
  Unhook the hooks, but only if they're already set.
}
  begin
    if (HookInUse) then begin
      HookInUse := false;
      UnhookWindowsHook(wh_CallWndProc,addr(CallWndProcHook));
      CallWndProcHookProc := nil;
    end;
  end { UnsetTheHook };
{ ------------ }


Procedure LibExit; export;
    Begin
    UnSetTheHook;
    ExitProc := SaveExit;
    End;

function SetTheHook : boolean; export;
{
  Sets the GetMessage and CallWndProc hooks.  Also sets up these two
  variables:

    AppHandle  The handle of the app that needs to be notified when
               a message is received.

    AppMsg     The message to send to NewAppHandle when a message
               is received.

  If the hooks are already set (as indicated by HookInUse) then no hooks
  are set and this function returns false.  We also check for appropriate
  values for NewAppHandle and NewAppMsg before setting the hooks.
}
  begin
    SetTheHook := false;
    if (HookInUse) then exit;
    SaveExit := ExitProc;
    ExitProc := @LibExit;
    CallWndProcHookProc := SetWindowsHook(wh_CallWndProc,addr(CallWndProcHook));
    HookInUse := true;
    SetTheHook := true;
  end { SetTheHook };

Function wndEnumProc (AnHWnd :HWnd; lParam : LongInt) : Boolean; export;
Begin
While AnHwnd <> 0
 do
   Begin
   gWindow := AnHWnd;
   AnHWnd := GetParent(AnHwnd);
   End;
wndEnumProc := False;
End;

Function TaskWindow (hTask :Word): HWND; export;
Begin
   TaskWindow := 0;
   If EnumTaskWindows (hTask, @wndEnumProc, 0) then ;
   TaskWindow := gWindow;
End;

Function MessageReceived : LongInt; export;
    Begin
    If not gReceived then
       MessageReceived := 0
    Else
       MessageReceived := ghWnd * 65536 + gCommand;

    gReceived := False;
    End;

Function PrinterJobs : Word; export;
    Begin
    PrinterJobs := gJobs;
    End;

Function PrinterStatus : Word; export;
    Begin
    PrinterStatus := gJobstatus;
    End;


Exports
    wndEnumProc index 3,
    TaskWindow index 4,
    MessageReceived index 5,
    PrinterJobs index 6,
    PrinterStatus index 7,
    SetTheHook   index 8,
    UnsetTheHook index 9;

Begin
End.
